/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.util.Vector;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.help.UAContentFilter;
import org.eclipse.help.internal.UAElementFactory;
import org.eclipse.ui.internal.intro.impl.model.AbstractBaseIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroIdElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroAnchor;
import org.eclipse.ui.internal.intro.impl.model.IntroContentProvider;
import org.eclipse.ui.internal.intro.impl.model.IntroGroup;
import org.eclipse.ui.internal.intro.impl.model.IntroHTML;
import org.eclipse.ui.internal.intro.impl.model.IntroHead;
import org.eclipse.ui.internal.intro.impl.model.IntroImage;
import org.eclipse.ui.internal.intro.impl.model.IntroInclude;
import org.eclipse.ui.internal.intro.impl.model.IntroLink;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroPageTitle;
import org.eclipse.ui.internal.intro.impl.model.IntroSeparator;
import org.eclipse.ui.internal.intro.impl.model.IntroText;
import org.eclipse.ui.internal.intro.impl.model.loader.ExtensionPointManager;
import org.eclipse.ui.internal.intro.impl.util.IntroEvaluationContext;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractIntroContainer
extends AbstractBaseIntroElement {
    protected static final String ATT_BG_IMAGE = "bgImage";
    protected Vector<AbstractIntroElement> children;
    protected boolean loaded = false;
    protected boolean resolved = false;
    protected Element element;
    protected String base;

    AbstractIntroContainer(IConfigurationElement element) {
        super(element);
    }

    AbstractIntroContainer(Element element, Bundle bundle) {
        super(element, bundle);
        this.element = element;
    }

    AbstractIntroContainer(Element element, Bundle bundle, String base) {
        super(element, bundle);
        this.element = element;
        this.base = base;
    }

    public AbstractIntroElement[] getChildren() {
        if (!this.loaded) {
            this.loadChildren();
        }
        if (!this.loaded) {
            return new AbstractIntroElement[0];
        }
        if (!this.resolved) {
            this.resolveChildren();
        }
        Vector<AbstractIntroElement> filtered = this.filterChildren(this.children);
        AbstractIntroElement[] childrenElements = (AbstractIntroElement[])this.convertToModelArray(filtered, 131071);
        return childrenElements;
    }

    public Object[] getChildrenOfType(int elementMask) {
        AbstractIntroElement[] childrenElements = this.getChildren();
        Vector<AbstractIntroElement> typedChildren = new Vector<AbstractIntroElement>();
        int i = 0;
        while (i < childrenElements.length) {
            AbstractIntroElement element = childrenElements[i];
            if (element.isOfType(elementMask)) {
                typedChildren.addElement(element);
            }
            ++i;
        }
        return this.convertToModelArray(typedChildren, elementMask);
    }

    private Object[] convertToModelArray(Vector vector, int elementMask) {
        int size = vector.size();
        AbstractIntroElement[] src = null;
        switch (elementMask) {
            case 16: {
                src = new IntroGroup[size];
                break;
            }
            case 64: {
                src = new IntroLink[size];
                break;
            }
            case 512: {
                src = new IntroText[size];
                break;
            }
            case 128: {
                src = new IntroImage[size];
                break;
            }
            case 524288: {
                src = new IntroSeparator[size];
                break;
            }
            case 32: {
                src = new IntroHTML[size];
                break;
            }
            case 256: {
                src = new IntroInclude[size];
                break;
            }
            case 8: {
                src = new IntroPage[size];
                break;
            }
            case 12: {
                src = new AbstractIntroPage[size];
                break;
            }
            case 29: {
                src = new AbstractIntroContainer[size];
                break;
            }
            case 2048: {
                src = new IntroHead[size];
                break;
            }
            case 4096: {
                src = new IntroPageTitle[size];
                break;
            }
            case 8192: {
                src = new IntroAnchor[size];
                break;
            }
            case 16384: {
                src = new IntroContentProvider[size];
                break;
            }
            default: {
                src = new AbstractIntroElement[size];
            }
        }
        vector.copyInto(src);
        return src;
    }

    protected void loadChildren() {
        this.children = new Vector();
        NodeList nodeList = this.element.getChildNodes();
        Vector<Node> vector = new Vector<Node>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                vector.add(node);
            }
            ++i;
        }
        Object[] filteredElements = new Element[vector.size()];
        vector.copyInto(filteredElements);
        this.insertElementsBefore((Element[])filteredElements, this.getBundle(), this.base, this.children.size(), null);
        this.loaded = true;
    }

    protected void insertElementsBefore(Element[] childElements, Bundle bundle, String base, int index, String mixinStyle) {
        int i = 0;
        while (i < childElements.length) {
            Element childElement = childElements[i];
            AbstractIntroElement child = this.getModelChild(childElement, bundle, base);
            if (child != null) {
                child.setParent(this);
                child.setMixinStyle(mixinStyle);
                this.children.add(index, child);
                ++index;
            }
            ++i;
        }
    }

    protected void insertElementsBefore(Element[] childElements, Bundle bundle, String base, AbstractIntroElement child, String mixinStyle) {
        int childLocation = this.children.indexOf(child);
        if (childLocation == -1) {
            return;
        }
        this.insertElementsBefore(childElements, bundle, base, childLocation, mixinStyle);
    }

    protected AbstractIntroElement getModelChild(Element childElement, Bundle bundle, String base) {
        AbstractIntroElement child = null;
        if (childElement.getNodeName().equalsIgnoreCase("group")) {
            child = new IntroGroup(childElement, bundle, base);
        } else if (childElement.getNodeName().equalsIgnoreCase("link")) {
            child = new IntroLink(childElement, bundle, base);
        } else if (childElement.getNodeName().equalsIgnoreCase("text")) {
            child = new IntroText(childElement, bundle);
        } else if (childElement.getNodeName().equalsIgnoreCase("img")) {
            child = new IntroImage(childElement, bundle, base);
        } else if (childElement.getNodeName().equalsIgnoreCase("hr")) {
            child = new IntroSeparator(childElement, bundle, base);
        } else if (childElement.getNodeName().equalsIgnoreCase("html")) {
            child = new IntroHTML(childElement, bundle, base);
        } else if (childElement.getNodeName().equalsIgnoreCase("include")) {
            child = new IntroInclude(childElement, bundle);
        } else if (childElement.getNodeName().equalsIgnoreCase("anchor")) {
            child = new IntroAnchor(childElement, bundle);
        } else if (childElement.getNodeName().equalsIgnoreCase("contentProvider")) {
            child = new IntroContentProvider(childElement, bundle);
        }
        return child;
    }

    protected void resolveChildren() {
        AbstractIntroElement[] array = this.children.toArray(new AbstractIntroElement[this.children.size()]);
        int i = 0;
        while (i < array.length) {
            AbstractIntroElement child = array[i];
            if (UAContentFilter.isFiltered((Object)UAElementFactory.newElement((Element)child.getElement()), (IEvaluationContext)IntroEvaluationContext.getContext())) {
                this.children.remove(child);
            } else if (child.getType() == 256) {
                this.resolveInclude((IntroInclude)child);
            }
            ++i;
        }
        this.resolved = true;
    }

    private void resolveInclude(IntroInclude include) {
        AbstractIntroElement target = this.findIncludeTarget(include);
        if (target == null) {
            return;
        }
        if (target.isOfType(21232)) {
            this.insertTarget(include, target);
        }
    }

    private <T> Vector<T> filterChildren(Vector<T> unfiltered) {
        Vector<T> filtered = new Vector<T>();
        for (T element : unfiltered) {
            if (UAContentFilter.isFiltered(element, (IEvaluationContext)IntroEvaluationContext.getContext())) continue;
            filtered.add(element);
        }
        return filtered;
    }

    private AbstractIntroElement findIncludeTarget(IntroInclude include) {
        String path = include.getPath();
        IntroModelRoot targetModelRoot = (IntroModelRoot)this.getParentPage().getParent();
        String targetConfigID = include.getConfigId();
        if (targetConfigID != null) {
            targetModelRoot = ExtensionPointManager.getInst().getModel(targetConfigID);
        }
        if (targetModelRoot == null) {
            return null;
        }
        AbstractIntroElement target = this.findTarget(targetModelRoot, path);
        return target;
    }

    public AbstractIntroElement findTarget(AbstractIntroContainer container, String path) {
        String[] pathSegments = path.split("/");
        if (container == null) {
            return null;
        }
        AbstractIntroElement target = container.findChild(pathSegments[0]);
        if (target == null) {
            return null;
        }
        int i = 1;
        while (i < pathSegments.length) {
            if (!(target instanceof AbstractIntroContainer)) {
                return null;
            }
            String pathSegment = pathSegments[i];
            if ((target = ((AbstractIntroContainer)target).findChild(pathSegment)) == null) {
                return null;
            }
            ++i;
        }
        return target;
    }

    public AbstractIntroElement findTarget(AbstractIntroContainer container, String path, String extensionId) {
        IntroModelRoot root;
        if (path.contains("@") && (root = this.getModelRoot()) != null && (path = root.resolvePath(extensionId, path)) == null) {
            return null;
        }
        return this.findTarget(container, path);
    }

    public AbstractIntroElement findTarget(String path) {
        return this.findTarget(this, path);
    }

    public AbstractIntroElement findChild(String elementId) {
        return this.findChild(elementId, 29437);
    }

    public AbstractIntroElement findChild(String elementId, int elementMask) {
        if (!this.loaded) {
            this.loadChildren();
        }
        int i = 0;
        while (i < this.children.size()) {
            AbstractIntroIdElement child;
            AbstractIntroElement aChild = this.children.elementAt(i);
            if (aChild.isOfType(29437) && (child = (AbstractIntroIdElement)aChild).getId() != null && child.getId().equals(elementId) && child.isOfType(elementMask)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    private void insertTarget(IntroInclude include, AbstractIntroElement target) {
        int includeLocation = this.children.indexOf(include);
        if (includeLocation == -1) {
            return;
        }
        this.children.remove(includeLocation);
        this.handleIncludeStyleInheritence(include, target);
        AbstractIntroElement clonedTarget = null;
        try {
            clonedTarget = (AbstractIntroElement)target.clone();
        }
        catch (CloneNotSupportedException ex) {
            Log.error("Failed to clone Intro model node.", ex);
            return;
        }
        clonedTarget.setParent(this);
        this.children.insertElementAt(clonedTarget, includeLocation);
    }

    private void handleIncludeStyleInheritence(IntroInclude include, AbstractIntroElement target) {
        if (!include.getMergeStyle()) {
            return;
        }
        if (target.getParent().getType() == 1 || target.getParentPage().equals(include.getParentPage())) {
            return;
        }
        String style = target.getParentPage().getStyle();
        if (style != null) {
            this.getParentPage().addStyle(style);
        }
        if ((style = target.getParentPage().getAltStyle()) != null) {
            Bundle bundle = target.getBundle();
            this.getParentPage().addAltStyle(style, bundle);
        }
        this.getParentPage().addStyles(target.getParentPage().getStyles());
        this.getParentPage().addAltStyles(target.getParentPage().getAltStyles());
    }

    protected AbstractIntroElement cloneTarget(AbstractIntroElement target) {
        return null;
    }

    @Override
    public int getType() {
        return 29;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractIntroContainer clone = (AbstractIntroContainer)super.clone();
        clone.children = new Vector();
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                AbstractIntroElement cloneChild = (AbstractIntroElement)this.children.elementAt(i).clone();
                cloneChild.setParent(clone);
                clone.children.add(i, cloneChild);
                ++i;
            }
        }
        return clone;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    public String getBase() {
        return this.base;
    }

    public void clearChildren() {
        this.children.clear();
    }

    public void addChild(AbstractIntroElement child) {
        this.children.add(child);
    }

    public void removeChild(AbstractIntroElement child) {
        this.children.remove(child);
    }

    public String getBackgroundImage() {
        return this.getAttribute(this.element, ATT_BG_IMAGE);
    }
}

