/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.common.usermodel.fonts.FontFacet;
import org.apache.poi.common.usermodel.fonts.FontHeader;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;

public class FontEmbeddedData
extends RecordAtom
implements FontFacet {
    private static final int MAX_RECORD_LENGTH = 1000000;
    private byte[] _header = new byte[8];
    private byte[] _data;

    FontEmbeddedData() {
        this._data = new byte[4];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    FontEmbeddedData(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = IOUtils.safelyAllocate(len - 8, 1000000);
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
        if (this._data.length < 4) {
            throw new IllegalArgumentException("The length of the data for a ExObjListAtom must be at least 4 bytes, but was only " + this._data.length);
        }
    }

    @Override
    public long getRecordType() {
        return RecordTypes.FontEmbeddedData.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }

    public void setFontData(byte[] fontData) {
        this._data = (byte[])fontData.clone();
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    public FontHeader getFontHeader() {
        FontHeader h = new FontHeader();
        h.init(this._data, 0, this._data.length);
        return h;
    }

    @Override
    public int getWeight() {
        return this.getFontHeader().getWeight();
    }

    @Override
    public boolean isItalic() {
        return this.getFontHeader().isItalic();
    }

    public String getTypeface() {
        return this.getFontHeader().getFamilyName();
    }

    @Override
    public Object getFontData() {
        return this;
    }
}

