/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.viewer.IUndecoratingLabelProvider;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ViewerPane
implements IPropertyListener,
Listener {
    protected IWorkbenchPage page;
    protected IWorkbenchPart part;
    protected Collection<Object> buddies = new ArrayList<Object>();
    protected Viewer viewer;
    protected Composite container;
    boolean isActive;
    Font normalTitleFont;
    Font activeTitleFont;
    protected CLabel titleLabel;
    protected ToolBar actionBar;
    protected ToolBarManager toolBarManager;
    protected MenuManager menuManager;
    protected Image pullDownImage;
    protected ToolBar systemBar;
    protected ViewForm control;
    protected MouseListener mouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            ViewerPane.this.requestActivation();
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (e.getSource() == ViewerPane.this.titleLabel) {
                ViewerPane.this.doMaximize();
            }
        }
    };
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
            if (p == ViewerPane.this.part) {
                ViewerPane.this.showFocus(false);
            }
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    private static final Map<Font, Font> FONTS = new HashMap<Font, Font>();

    public ViewerPane(IWorkbenchPage page, IWorkbenchPart part) {
        this.page = page;
        this.part = part;
        page.addPartListener(this.partListener);
    }

    public abstract Viewer createViewer(Composite var1);

    public Collection<Object> getBudies() {
        return this.buddies;
    }

    public void createControl(Composite parent) {
        if (this.getControl() == null) {
            this.container = parent;
            this.control = new ViewForm(parent, 0);
            this.control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ViewerPane.this.dispose();
                }
            });
            this.control.marginWidth = 0;
            this.control.marginHeight = 0;
            this.createTitleBar();
            this.viewer = this.createViewer((Composite)this.control);
            this.control.setContent(this.viewer.getControl());
            this.control.setTabList(new Control[]{this.viewer.getControl()});
            this.control.addListener(26, (Listener)this);
            this.hookFocus((Control)this.control);
            this.hookFocus(this.viewer.getControl());
        }
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public Control getControl() {
        return this.control;
    }

    protected ViewForm getViewForm() {
        return this.control;
    }

    public void handleEvent(Event event) {
        if (event.type == 26) {
            this.requestActivation();
        }
    }

    public void hookFocus(Control ctrl) {
        ctrl.addMouseListener(this.mouseListener);
    }

    protected void requestActivation() {
        this.control.getContent().setFocus();
        this.showFocus(true);
    }

    public void setFocus() {
        this.requestActivation();
        this.control.getContent().setFocus();
    }

    private void createMenuManager() {
        this.menuManager = new MenuManager("Pane Menu");
        if (this.systemBar != null) {
            this.createPulldownMenu();
        }
    }

    private void createPulldownMenu() {
        if (this.systemBar != null) {
            ToolItem ti = new ToolItem(this.systemBar, 8, 0);
            try {
                this.pullDownImage = ImageDescriptor.createFromURL((URL)new URL(CommonUIPlugin.INSTANCE.getImage("full/ctool16/ViewPullDown").toString())).createImage();
                ti.setImage(this.pullDownImage);
                ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ViewerPane.this.showViewMenu();
                    }
                });
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    protected void createTitleBar() {
        if (this.titleLabel == null) {
            this.titleLabel = new CLabel((Composite)this.control, 32);
            this.normalTitleFont = this.titleLabel.getFont();
            this.activeTitleFont = ViewerPane.getActiveFont(this.normalTitleFont);
            this.hookFocus((Control)this.titleLabel);
            this.titleLabel.setAlignment(16384);
            this.titleLabel.setBackground(null, null);
            this.titleLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (e.button == 3) {
                        ViewerPane.this.showTitleLabelMenu(e);
                    }
                }
            });
            this.updateTitles();
            this.control.setTopLeft((Control)this.titleLabel);
            this.actionBar = new ToolBar((Composite)this.control, 0x800040);
            this.hookFocus((Control)this.actionBar);
            this.control.setTopCenter((Control)this.actionBar);
            this.systemBar = new ToolBar((Composite)this.control, 0x800040);
            this.hookFocus((Control)this.systemBar);
            if (this.menuManager != null && !this.menuManager.isEmpty()) {
                this.createPulldownMenu();
            }
            this.control.setTopRight((Control)this.systemBar);
        }
    }

    protected void doMaximize() {
        ViewForm child = this.control;
        Composite parent = this.control.getParent();
        while (parent instanceof SashForm || parent instanceof CTabFolder) {
            if (parent instanceof CTabFolder) {
                CTabFolder cTabFolder;
                cTabFolder.setMaximized(!(cTabFolder = (CTabFolder)parent).getMaximized());
            } else if (parent instanceof SashForm) {
                SashForm sashForm = (SashForm)parent;
                if (sashForm.getMaximizedControl() == null) {
                    sashForm.setMaximizedControl((Control)child);
                } else {
                    sashForm.setMaximizedControl(null);
                }
            }
            child = parent;
            parent = parent.getParent();
        }
    }

    public void dispose() {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.removeListener(26, (Listener)this);
            this.control = null;
            this.page.removePartListener(this.partListener);
        }
        if (this.pullDownImage != null) {
            this.pullDownImage.dispose();
            this.pullDownImage = null;
        }
    }

    public MenuManager getMenuManager() {
        if (this.menuManager == null) {
            this.createMenuManager();
        }
        return this.menuManager;
    }

    public ToolBarManager getToolBarManager() {
        if (this.toolBarManager == null) {
            this.toolBarManager = new PaneToolBarManager(this.actionBar);
        }
        return this.toolBarManager;
    }

    public void propertyChanged(Object source, int propID) {
        if (propID == 1) {
            this.updateTitles();
        }
    }

    public void showFocus(boolean inFocus) {
        if (inFocus != this.isActive) {
            this.isActive = inFocus;
            if (this.titleLabel != null) {
                this.titleLabel.setFont(inFocus ? this.activeTitleFont : this.normalTitleFont);
                this.titleLabel.update();
                this.titleLabel.redraw();
            }
        }
    }

    private void showViewMenu() {
        Menu aMenu = this.menuManager.createContextMenu(this.getControl());
        Point topLeft = new Point(0, 0);
        topLeft.y += this.systemBar.getBounds().height;
        topLeft = this.systemBar.toDisplay(topLeft);
        aMenu.setLocation(topLeft.x, topLeft.y);
        aMenu.setVisible(true);
    }

    public String toString() {
        String label = "disposed";
        if (this.titleLabel != null && !this.titleLabel.isDisposed()) {
            label = this.titleLabel.getText();
        }
        return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode()) + "(" + label + ")";
    }

    public void updateActionBars() {
        if (this.menuManager != null) {
            this.menuManager.updateAll(false);
        }
        if (this.toolBarManager != null) {
            this.getToolBarManager().update(false);
        }
    }

    public void updateTitles() {
        this.titleLabel.update();
    }

    public void setTitle(Object object) {
        IBaseLabelProvider labelProvider;
        if (this.viewer != null && this.viewer instanceof ContentViewer && (labelProvider = ((ContentViewer)this.viewer).getLabelProvider()) instanceof ILabelProvider) {
            if (object == null) {
                this.titleLabel.setImage(null);
                this.titleLabel.setText("");
            } else if (labelProvider instanceof IUndecoratingLabelProvider) {
                this.titleLabel.setImage(((IUndecoratingLabelProvider)labelProvider).getUndecoratedImage(object));
                this.titleLabel.setText(((IUndecoratingLabelProvider)labelProvider).getUndecoratedText(object));
            } else {
                this.titleLabel.setImage(((ILabelProvider)labelProvider).getImage(object));
                this.titleLabel.setText(((ILabelProvider)labelProvider).getText(object));
            }
        }
    }

    public void setTitle(String title, Image image) {
        if (this.titleLabel != null) {
            this.titleLabel.setImage(image);
            this.titleLabel.setText(title);
        }
    }

    private void showTitleLabelMenu(MouseEvent e) {
        Menu menu = new Menu((Control)this.titleLabel);
        boolean isMaximized = this.control.getParent() instanceof SashForm ? ((SashForm)this.control.getParent()).getMaximizedControl() != null : this.control.getParent() instanceof CTabFolder && ((CTabFolder)this.control.getParent()).getMaximized();
        MenuItem restoreItem = new MenuItem(menu, 0);
        restoreItem.setText(CommonUIPlugin.INSTANCE.getString("_UI_Restore_menu_item"));
        restoreItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewerPane.this.doMaximize();
            }
        });
        restoreItem.setEnabled(isMaximized);
        MenuItem maximizeItem = new MenuItem(menu, 0);
        maximizeItem.setText(CommonUIPlugin.INSTANCE.getString("_UI_Maximize_menu_item"));
        maximizeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewerPane.this.doMaximize();
            }
        });
        maximizeItem.setEnabled(!isMaximized);
        Point point = new Point(e.x, e.y);
        point = this.titleLabel.toDisplay(point);
        menu.setLocation(point.x, point.y);
        menu.setVisible(true);
    }

    private static Font getActiveFont(Font font) {
        Font result = FONTS.get(font);
        if (result == null) {
            Device device = font.getDevice();
            FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)font);
            result = fontDescriptor.setStyle(2).createFont(device);
            FONTS.put(font, result);
        }
        return result;
    }

    class PaneToolBarManager
    extends ToolBarManager {
        public PaneToolBarManager(ToolBar paneToolBar) {
            super(paneToolBar);
        }

        protected void relayout(ToolBar toolBar, int oldCount, int newCount) {
            if (newCount < 1) {
                if (ViewerPane.this.control.getTopCenter() != null) {
                    ViewerPane.this.control.setTopCenter(null);
                }
            } else {
                toolBar.layout();
                if (ViewerPane.this.control.getTopCenter() == null) {
                    ViewerPane.this.control.setTopCenter((Control)toolBar);
                }
            }
            Composite parent = toolBar.getParent();
            parent.layout();
            if (parent.getParent() != null) {
                parent.getParent().layout();
            }
        }
    }
}

