/*
 * Copyright (c) 2021 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.mutable.primitive;

import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.factory.map.primitive.MutableShortShortMapFactory;
import org.eclipse.collections.impl.factory.primitive.ShortShortMaps;
import org.eclipse.collections.api.map.primitive.MutableShortShortMap;
import org.eclipse.collections.api.map.primitive.ShortShortMap;
import org.eclipse.collections.impl.utility.Iterate;

/**
 * MutableShortShortMapFactoryImpl is a factory implementation which creates instances of type {@link MutableShortShortMap}.
 * This file was automatically generated from template file mutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 6.0.
 */
public enum MutableShortShortMapFactoryImpl implements MutableShortShortMapFactory
{
    INSTANCE;

    @Override
    public MutableShortShortMap empty()
    {
        return new ShortShortHashMap(0);
    }

    @Override
    public MutableShortShortMap of()
    {
        return this.empty();
    }

    @Override
    public MutableShortShortMap with()
    {
        return this.empty();
    }

    @Override
    public MutableShortShortMap ofInitialCapacity(int capacity)
    {
        return this.withInitialCapacity(capacity);
    }

    @Override
    public MutableShortShortMap withInitialCapacity(int capacity)
    {
        return new ShortShortHashMap(capacity);
    }

    @Override
    public MutableShortShortMap ofAll(ShortShortMap map)
    {
        return this.withAll(map);
    }

    @Override
    public MutableShortShortMap withAll(ShortShortMap map)
    {
        if (map.isEmpty())
        {
            return this.empty();
        }
        return new ShortShortHashMap(map);
    }

    @Override
    public <T> MutableShortShortMap from(Iterable<T> iterable, ShortFunction<? super T> keyFunction, ShortFunction<? super T> valueFunction)
    {
        MutableShortShortMap map = ShortShortMaps.mutable.empty();
        Iterate.forEach(iterable, each -> map.put(keyFunction.shortValueOf(each), valueFunction.shortValueOf(each)));
        return map;
    }
}
