/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api;

import java.util.Collection;
import java.util.Comparator;
import java.util.LongSummaryStatistics;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.PrimitiveIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.comparator.primitive.LongComparator;
import org.eclipse.collections.api.block.function.primitive.LongLongToLongFunction;
import org.eclipse.collections.api.block.function.primitive.LongToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.LongToByteFunction;
import org.eclipse.collections.api.block.function.primitive.LongToCharFunction;
import org.eclipse.collections.api.block.function.primitive.LongToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.LongToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.LongToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.LongToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;

public interface LongIterable
extends PrimitiveIterable {
    public LongIterator longIterator();

    public long[] toArray();

    default public long[] toArray(long[] target) {
        return this.toList().toArray(target);
    }

    public boolean contains(long var1);

    default public boolean containsAll(long ... source) {
        if (this.size() <= 32 || source.length < 4) {
            for (long item : source) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }
        LongSet set = this instanceof LongSet ? (LongSet)this : this.toSet();
        for (long item : source) {
            if (set.contains(item)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAll(LongIterable source) {
        if (this.size() <= 32 || source.size() < 4) {
            return source.allSatisfy(this::contains);
        }
        LongSet set = this instanceof LongSet ? (LongSet)this : this.toSet();
        return source.allSatisfy(set::contains);
    }

    default public boolean containsAny(long ... source) {
        LongIterable inside = this;
        if (this.size() > 32 && source.length > 32 && !(this instanceof LongSet)) {
            inside = this.toSet();
        }
        for (int i = 0; i < source.length; ++i) {
            if (!inside.contains(source[i])) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAny(LongIterable source) {
        LongIterable outside = this;
        LongIterable inside = source;
        if (this.size() < source.size()) {
            outside = source;
            inside = this;
        }
        if (outside instanceof LongSet) {
            LongIterable temp = outside;
            outside = inside;
            inside = temp;
        } else if (inside.size() > 32 && !(inside instanceof LongSet)) {
            inside = inside.toSet();
        }
        return outside.anySatisfy(inside::contains);
    }

    default public boolean containsNone(long ... source) {
        LongIterable inside = this;
        if (this.size() > 32 && source.length > 32 && !(this instanceof LongSet)) {
            inside = this.toSet();
        }
        for (int i = 0; i < source.length; ++i) {
            if (!inside.contains(source[i])) continue;
            return false;
        }
        return true;
    }

    default public boolean containsNone(LongIterable source) {
        LongIterable outside = this;
        LongIterable inside = source;
        if (this.size() < source.size()) {
            outside = source;
            inside = this;
        }
        if (outside instanceof LongSet) {
            LongIterable temp = outside;
            outside = inside;
            inside = temp;
        } else if (inside.size() > 32 && !(inside instanceof LongSet)) {
            inside = inside.toSet();
        }
        return outside.noneSatisfy(inside::contains);
    }

    public void forEach(LongProcedure var1);

    public void each(LongProcedure var1);

    default public LongIterable tap(LongProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public LongIterable select(LongPredicate var1);

    public LongIterable reject(LongPredicate var1);

    default public <R extends MutableLongCollection> R select(LongPredicate predicate, R target) {
        this.each(each -> {
            if (predicate.accept(each)) {
                target.add(each);
            }
        });
        return target;
    }

    default public <R extends MutableLongCollection> R reject(LongPredicate predicate, R target) {
        this.each(each -> {
            if (!predicate.accept(each)) {
                target.add(each);
            }
        });
        return target;
    }

    public <V> RichIterable<V> collect(LongToObjectFunction<? extends V> var1);

    default public <V, R extends Collection<V>> R collect(LongToObjectFunction<? extends V> function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <V, R extends Collection<V>> R flatCollect(LongToObjectFunction<? extends Iterable<V>> function, R target) {
        this.each(each -> {
            Iterable iterable = (Iterable)function.valueOf(each);
            if (iterable instanceof Collection) {
                target.addAll((Collection)iterable);
            } else {
                iterable.forEach(target::add);
            }
        });
        return target;
    }

    default public <R extends MutableBooleanCollection> R collectBoolean(LongToBooleanFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableByteCollection> R collectByte(LongToByteFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableCharCollection> R collectChar(LongToCharFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableShortCollection> R collectShort(LongToShortFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableIntCollection> R collectInt(LongToIntFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableFloatCollection> R collectFloat(LongToFloatFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableLongCollection> R collectLong(LongToLongFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableDoubleCollection> R collectDouble(LongToDoubleFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    public long detectIfNone(LongPredicate var1, long var2);

    public int count(LongPredicate var1);

    public boolean anySatisfy(LongPredicate var1);

    public boolean allSatisfy(LongPredicate var1);

    public boolean noneSatisfy(LongPredicate var1);

    public MutableLongList toList();

    public MutableLongSet toSet();

    public MutableLongBag toBag();

    public LazyLongIterable asLazy();

    public <T> T injectInto(T var1, ObjectLongToObjectFunction<? super T, ? extends T> var2);

    default public long reduceIfEmpty(LongLongToLongFunction accumulator, long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.reduce(accumulator);
    }

    default public long reduce(LongLongToLongFunction accumulator) {
        boolean[] seenOne = new boolean[1];
        long[] result = new long[1];
        this.each(each -> {
            if (seenOne[0]) {
                result[0] = accumulator.valueOf(result[0], each);
            } else {
                seenOne[0] = true;
                result[0] = each;
            }
        });
        if (!seenOne[0]) {
            throw new NoSuchElementException();
        }
        return result[0];
    }

    default public RichIterable<LongIterable> chunk(int size) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    public long sum();

    default public LongSummaryStatistics summaryStatistics() {
        LongSummaryStatistics stats = new LongSummaryStatistics();
        this.forEach(stats::accept);
        return stats;
    }

    public long max();

    public long maxIfEmpty(long var1);

    public long min();

    public long minIfEmpty(long var1);

    public double average();

    default public double averageIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.average();
    }

    public double median();

    default public double medianIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.median();
    }

    public long[] toSortedArray();

    public MutableLongList toSortedList();

    default public MutableLongList toSortedList(LongComparator comparator) {
        return this.toList().sortThis(comparator);
    }

    default public <T> MutableLongList toSortedListBy(LongToObjectFunction<T> function) {
        return this.toList().sortThisBy(function);
    }

    default public <T> MutableLongList toSortedListBy(LongToObjectFunction<T> function, Comparator<? super T> comparator) {
        return this.toList().sortThisBy(function, comparator);
    }
}

