/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.PatternImage;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.PatternImageUtil;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class PatternImageEditorDialog
extends TrayDialog {
    private final Context context;
    private FillChooserComposite fccFore;
    private FillChooserComposite fccBack;

    protected PatternImageEditorDialog(Shell shell, Fill fill) {
        super(shell);
        this.setHelpAvailable(false);
        this.context = new Context(fill);
    }

    public PatternImage getPatternImage() {
        return this.context.getPatternImage();
    }

    protected Control createContents(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.Chart_Pattern_Editor_ID");
        this.getShell().setText(Messages.getString("PatternImageEditorDialog.Title.PatternFillEditor"));
        Control control = super.createContents(parent);
        this.getShell().setDefaultButton(null);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = (Composite)super.createDialogArea(parent);
        this.createPatternGroup(control);
        this.createColorGroup(control);
        return control;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(Messages.getString("PatternImageEditorDialog.Button.OK"));
        this.getButton(1).setText(Messages.getString("PatternImageEditorDialog.Button.Cancel"));
    }

    private void createPatternGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("PatternImageEditorDialog.Group.Pattern"));
        group.setLayout((Layout)new GridLayout());
        new BitmapGallery((Composite)group, this.context);
    }

    private void createColorGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("PatternImageEditorDialog.Group.Color"));
        GridLayout gl = new GridLayout(4, false);
        group.setLayout((Layout)gl);
        int iFillOption = 128;
        PatternImage patternImage = this.context.getPatternImage();
        new Label((Composite)group, 0).setText(Messages.getString("PatternImageEditorDialog.Label.Foreground"));
        this.fccFore = new FillChooserComposite((Composite)group, 12, iFillOption, null, (Fill)patternImage.getForeColor());
        this.fccFore.addListener(new ColorEventListener(patternImage.getForeColor(), this.context));
        new Label((Composite)group, 0).setText(Messages.getString("PatternImageEditorDialog.Label.Background"));
        this.fccBack = new FillChooserComposite((Composite)group, 12, iFillOption, null, (Fill)patternImage.getBackColor());
        this.fccBack.addListener(new ColorEventListener(patternImage.getBackColor(), this.context));
    }

    private static class BitmapGallery
    extends Composite
    implements PaintListener,
    Listener {
        static final int VIEW_WIDTH = 32;
        static final int VIEW_HEIGHT = 24;
        static final int BUTTON_WIDTH = 14;
        static final int MARGIN = 1;
        private final Context context;
        private int columns = 6;
        private int itemWidth;
        private int itemHeight;
        private int margin;
        private ItemFrame itemFrame;
        private PatternBitmapEditComposite pbEditor;

        public BitmapGallery(Composite parent, Context context) {
            super(parent, 0x20000000);
            this.context = context;
            this.itemFrame = new ItemFrame(this, context);
            this.itemFrame.pack();
            Point sz = this.itemFrame.getSize();
            this.itemWidth = sz.x;
            this.itemHeight = sz.y;
            this.margin = (this.itemHeight - 24) / 2;
            int count = context.getBitmaps().size();
            this.setLayoutData(new GridData(this.itemWidth * this.columns, this.itemHeight * (count / this.columns + 1)));
            this.select(context.getIndex());
            this.addListener(3, this);
            this.addPaintListener(this);
            context.addListener(this);
            this.pbEditor = new PatternBitmapEditComposite(context);
            this.pbEditor.attachToHost(this.itemFrame);
        }

        private static GridLayout createGridLayout() {
            GridLayout gl = new GridLayout(2, false);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            gl.horizontalSpacing = 0;
            gl.verticalSpacing = 0;
            return gl;
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 3: {
                    int index = this.computeIndex(event.x, event.y);
                    this.select(index);
                    break;
                }
                case 24: {
                    this.redraw();
                    this.itemFrame.doRedraw();
                }
            }
        }

        private void select(int index) {
            if (this.context.verifyIndex(index)) {
                this.context.setIndex(index);
                this.itemFrame.setLocation(this.computePos(index));
                this.context.notifyListeners();
            }
        }

        private int computeIndex(int x, int y) {
            int iCol = x / this.itemWidth;
            int iRow = y / this.itemHeight;
            return iRow * this.columns + iCol;
        }

        private Point computePos(int index) {
            int iCol = index % this.columns;
            int iRow = index / this.columns;
            return new Point(iCol * this.itemWidth, iRow * this.itemHeight);
        }

        private static Image createImageFromPattern(PatternImage patternImage) {
            Display device = Display.getCurrent();
            PaletteData paletteData = new PaletteData(65280, 0xFF0000, -16777216);
            byte[] data = PatternImageUtil.createImageData((PatternImage)patternImage, (PatternImageUtil.ByteColorModel)PatternImageUtil.ByteColorModel.BGRA);
            ImageData imageData = new ImageData(8, 8, 32, paletteData, 4, data);
            return new Image((Device)device, imageData);
        }

        private Point getItemPos(int index) {
            int y = index / this.columns * this.itemHeight;
            int x = index % this.columns * this.itemWidth;
            return new Point(x, y);
        }

        private void drawItem(GC gc, int index) {
            Point pt = this.getItemPos(index);
            BitmapGallery.drawItem(gc, this.context.getPatternImage(index), pt.x + this.margin, pt.y + this.margin);
        }

        private static void drawItem(GC gc, PatternImage patternImage, int x, int y) {
            int width = 32;
            int height = 24;
            Device device = gc.getDevice();
            Image image = BitmapGallery.createImageFromPattern(patternImage);
            Pattern pattern = new Pattern(device, image);
            gc.setBackgroundPattern(pattern);
            gc.fillRectangle(x, y, width, height);
            pattern.dispose();
            image.dispose();
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            int count = this.context.getBitmaps().size();
            int i = 0;
            while (i < count) {
                this.drawItem(gc, i);
                ++i;
            }
        }

        private class ItemFrame
        extends Composite
        implements PaintListener,
        Listener {
            private final Context context;
            private Composite view;
            private Button btnDropDown;

            public ItemFrame(Composite parent, Context context) {
                super(parent, 2048);
                this.context = context;
                GridLayout gl = BitmapGallery.createGridLayout();
                gl.marginTop = 1;
                gl.marginBottom = 1;
                gl.marginLeft = 1;
                gl.marginRight = 1;
                this.setLayout((Layout)gl);
                this.view = new Composite((Composite)this, 262144);
                this.view.setLayoutData((Object)new GridData(32, 24));
                this.view.addPaintListener((PaintListener)this);
                this.view.addListener(3, (Listener)this);
                this.view.addListener(1, (Listener)this);
                this.view.addListener(31, (Listener)this);
                this.view.addListener(15, (Listener)this);
                this.view.addListener(16, (Listener)this);
                this.btnDropDown = new Button((Composite)this, 1028);
                this.btnDropDown.setLayoutData((Object)new GridData(14, 24));
                this.btnDropDown.addListener(13, (Listener)this);
            }

            public void paintControl(PaintEvent e) {
                BitmapGallery.drawItem(e.gc, this.context.getPatternImage(), 0, 0);
                if (this.view.isFocusControl()) {
                    GC gc = e.gc;
                    Color cOld = gc.getForeground();
                    int lineStyleOld = gc.getLineStyle();
                    gc.setLineStyle(3);
                    gc.setForeground(gc.getDevice().getSystemColor(2));
                    gc.drawRectangle(1, 1, 30, 22);
                    gc.setForeground(gc.getDevice().getSystemColor(1));
                    gc.drawRectangle(2, 2, 28, 20);
                    gc.setForeground(cOld);
                    gc.setLineStyle(lineStyleOld);
                }
            }

            public void doRedraw() {
                this.view.redraw();
            }

            private void doToggleDropDown() {
                Event event = new Event();
                event.type = 128;
                event.widget = this;
                this.notifyListeners(128, event);
            }

            private void processKeyDown(int keyCode) {
                switch (keyCode) {
                    case 27: {
                        break;
                    }
                    case 13: 
                    case 0x1000050: {
                        this.doToggleDropDown();
                        break;
                    }
                    case 0x1000007: {
                        BitmapGallery.this.select(0);
                        break;
                    }
                    case 0x1000008: {
                        BitmapGallery.this.select(this.context.getBitmaps().size() - 1);
                        break;
                    }
                    case 0x1000003: {
                        BitmapGallery.this.select(this.context.getIndex() - 1);
                        break;
                    }
                    case 0x1000004: {
                        BitmapGallery.this.select(this.context.getIndex() + 1);
                        break;
                    }
                    case 0x1000001: {
                        BitmapGallery.this.select(this.context.getIndex() - BitmapGallery.this.columns);
                        break;
                    }
                    case 0x1000002: {
                        BitmapGallery.this.select(this.context.getIndex() + BitmapGallery.this.columns);
                    }
                }
            }

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: 
                    case 13: {
                        this.doToggleDropDown();
                        break;
                    }
                    case 1: {
                        this.processKeyDown(event.keyCode);
                        break;
                    }
                    case 31: {
                        if (event.detail != 16 && event.detail != 8) break;
                        event.doit = true;
                        break;
                    }
                    case 15: {
                        this.view.redraw();
                        break;
                    }
                    case 16: {
                        this.view.redraw();
                    }
                }
            }
        }
    }

    private static class ColorEventListener
    implements Listener {
        private final ColorDefinition colorModel;
        private final Context context;

        ColorEventListener(ColorDefinition color, Context context) {
            this.colorModel = color;
            this.context = context;
        }

        public void handleEvent(Event event) {
            if (event.type == 1 && event.data instanceof ColorDefinition) {
                ColorDefinition color = (ColorDefinition)event.data;
                this.colorModel.set(color.getRed(), color.getGreen(), color.getBlue(), color.getTransparency());
                this.context.notifyListeners();
            }
        }
    }

    private static class Context {
        private final List<Long> bitmaps = new ArrayList<Long>();
        private final PatternImage patternImage;
        private int index;
        private Vector<Listener> listeners = new Vector();

        public Context(Fill fill) {
            this.patternImage = fill instanceof PatternImage ? (PatternImage)fill.copyInstance() : AttributeFactory.eINSTANCE.createPatternImage();
            Collections.addAll(this.bitmaps, Context.getPredefinedBitmaps());
            long bitmap = this.patternImage.getBitmap();
            this.index = this.bitmaps.indexOf(bitmap);
            if (this.index < 0) {
                this.bitmaps.add(bitmap);
                this.index = this.bitmaps.size() - 1;
            }
        }

        public void addListener(Listener listener) {
            this.listeners.add(listener);
        }

        public void notifyListeners() {
            Event event = new Event();
            event.type = 24;
            for (Listener listener : this.listeners) {
                listener.handleEvent(event);
            }
        }

        public boolean verifyIndex(int index) {
            return index >= 0 && index < this.bitmaps.size();
        }

        public PatternImage getPatternImage() {
            return this.getPatternImage(this.index);
        }

        public PatternImage getPatternImage(int index) {
            if (this.verifyIndex(index)) {
                this.patternImage.setBitmap(this.bitmaps.get(index).longValue());
            }
            return this.patternImage;
        }

        private static Long[] getPredefinedBitmaps() {
            Long[] bitmaps = new Long[]{0x8000000L, 0x200000040000L, 0x80000080000L, 0x240000240000L, 0xFF000000L, 0x808080808080808L, -9205322385119247871L, 72624976668147840L, 0x8080808FF080808L, -9132697408451100031L, 0x44FF444444FF4444L, 0xFF000000FF0000L, 0x4444444444444444L, 0xFFFFFF0000L, 0x1C1C1C1C1C1C1C1CL, -1085102596360827121L};
            return bitmaps;
        }

        public void updateBitmap(int index, long bitmap) {
            if (this.verifyIndex(index)) {
                this.bitmaps.set(index, bitmap);
            }
        }

        public void updateBitmap(long bitmap) {
            this.updateBitmap(this.index, bitmap);
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public List<Long> getBitmaps() {
            return this.bitmaps;
        }

        public long getBitmap() {
            return this.bitmaps.get(this.index);
        }
    }

    private static class DropDownControl
    implements Listener {
        public static final int ToggleDropDown = 128;
        protected Composite host;
        protected Composite dropDown;

        private DropDownControl() {
        }

        public void attachToHost(Composite host) {
            this.host = host;
            host.addListener(128, (Listener)this);
        }

        protected Composite createDropDown(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.addListener(16, (Listener)this);
            composite.addListener(1, (Listener)this);
            return composite;
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 16: {
                    this.onDropDonwFocusOut();
                    break;
                }
                case 128: {
                    this.toggleDropDown();
                }
            }
        }

        public void onDropDonwFocusOut() {
            Control currentControl = Display.getCurrent().getCursorControl();
            while (currentControl != null) {
                if (currentControl == this.host) {
                    return;
                }
                currentControl = currentControl.getParent();
            }
            this.dropDown.getShell().close();
        }

        public void toggleDropDown() {
            if (this.dropDown == null || this.dropDown.isDisposed()) {
                Point pt = UIHelper.getScreenLocation((Composite)this.host);
                int x = pt.x;
                int y = pt.y + this.host.getSize().y;
                Shell shell = new Shell(this.host.getShell(), 0);
                shell.setLayout((Layout)new GridLayout());
                shell.setLocation(x, y);
                this.dropDown = this.createDropDown((Composite)shell);
                shell.layout();
                shell.pack();
                shell.open();
            } else {
                this.dropDown.getShell().close();
            }
        }
    }

    private static class PatternBitmapEditComposite
    extends DropDownControl
    implements Listener,
    PaintListener {
        private static final int MARGIN = 2;
        private static final int CELL_WIDTH = 12;
        private static final int CELL_HEIGHT = 12;
        private final Context context;
        private int iRowAct = 0;
        private int iColAct = 0;

        PatternBitmapEditComposite(Context context) {
            this.context = context;
        }

        private void select(int iRow, int iCol) {
            if (this.moveTo(iRow, iCol)) {
                this.toggleCell(iRow, iCol);
            }
        }

        void toggleCell(int iRow, int iCol) {
            long bitmap = this.context.getBitmap();
            bitmap = PatternImageUtil.togglePixel((long)bitmap, (int)iCol, (int)iRow);
            this.context.updateBitmap(bitmap);
            this.context.notifyListeners();
            this.dropDown.redraw();
        }

        private boolean moveTo(int iRow, int iCol) {
            if (iRow >= 0 && iRow < 8 && iCol >= 0 & iCol < 8) {
                this.iRowAct = iRow;
                this.iColAct = iCol;
                return true;
            }
            return false;
        }

        private void processKeyDown(int keyCode) {
            switch (keyCode) {
                case 27: {
                    this.onDropDonwFocusOut();
                    break;
                }
                case 13: 
                case 0x1000050: {
                    this.toggleCell(this.iRowAct, this.iColAct);
                    break;
                }
                case 0x1000007: {
                    this.moveTo(0, 0);
                    this.dropDown.redraw();
                    break;
                }
                case 0x1000008: {
                    this.moveTo(7, 7);
                    this.dropDown.redraw();
                    break;
                }
                case 0x1000003: {
                    this.moveTo(this.iRowAct, this.iColAct - 1);
                    this.dropDown.redraw();
                    break;
                }
                case 0x1000004: {
                    this.moveTo(this.iRowAct, this.iColAct + 1);
                    this.dropDown.redraw();
                    break;
                }
                case 0x1000001: {
                    this.moveTo(this.iRowAct - 1, this.iColAct);
                    this.dropDown.redraw();
                    break;
                }
                case 0x1000002: {
                    this.moveTo(this.iRowAct + 1, this.iColAct);
                    this.dropDown.redraw();
                }
            }
        }

        @Override
        public void handleEvent(Event event) {
            switch (event.type) {
                case 3: {
                    int iRow = (event.y - 2) / 12;
                    int iCol = (event.x - 2) / 12;
                    this.select(iRow, iCol);
                    break;
                }
                case 1: {
                    this.processKeyDown(event.keyCode);
                }
            }
            super.handleEvent(event);
        }

        private Color createColor(ColorDefinition cd) {
            return new Color((Device)Display.getCurrent(), cd.getRed(), cd.getGreen(), cd.getBlue());
        }

        public void paintControl(PaintEvent event) {
            GC gc = event.gc;
            Color colorFore = this.createColor(this.context.getPatternImage().getForeColor());
            Color colorBack = this.createColor(this.context.getPatternImage().getBackColor());
            Color colorAct = gc.getDevice().getSystemColor(3);
            Color colorInact = gc.getDevice().getSystemColor(15);
            gc.setForeground(colorInact);
            long bitmap = this.context.getBitmap();
            int iRow = 0;
            while (iRow < 8) {
                int y = 12 * iRow;
                int iCol = 0;
                while (iCol < 8) {
                    int x = 12 * iCol;
                    gc.setBackground(PatternImageUtil.isPixelSet((long)bitmap, (int)iCol, (int)iRow) ? colorFore : colorBack);
                    gc.fillRectangle(x, y, 12, 12);
                    gc.drawRectangle(x, y, 12, 12);
                    ++iCol;
                }
                ++iRow;
            }
            gc.setForeground(colorAct);
            gc.drawRectangle(12 * this.iColAct, 12 * this.iRowAct, 12, 12);
            colorFore.dispose();
            colorBack.dispose();
        }

        @Override
        protected Composite createDropDown(Composite parent) {
            Composite composite = new Composite(parent, 0x20000800);
            GridData gd = new GridData();
            gd.widthHint = 98;
            gd.heightHint = 98;
            composite.setLayoutData((Object)gd);
            composite.addListener(3, (Listener)this);
            composite.addListener(16, (Listener)this);
            composite.addListener(15, (Listener)this);
            composite.addListener(1, (Listener)this);
            composite.addListener(31, (Listener)this);
            composite.addPaintListener((PaintListener)this);
            return composite;
        }
    }
}

