/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import org.eclipse.birt.chart.ui.swt.composites.IAngleChangeListener;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public final class AngleSelectorComposite
extends Canvas
implements PaintListener,
MouseListener,
MouseMoveListener,
DisposeListener,
ControlListener {
    private final transient Point p = new Point(0, 0);
    private transient int iLastAngle = 0;
    private transient int iRadius = 0;
    private transient boolean bMouseDown = false;
    private transient IAngleChangeListener iacl = null;
    private transient Color clrBG = null;
    private Image imgBuffer = null;
    private GC gcBuffer = null;
    private final transient int[] iaPolygon = new int[6];

    public AngleSelectorComposite(Composite coParent, int iStyle, int iAngle, Color clrBG) {
        super(coParent, iStyle);
        this.iLastAngle = iAngle;
        this.addPaintListener(this);
        this.addMouseListener(this);
        this.addDisposeListener(this);
        this.addControlListener(this);
        this.addMouseMoveListener(this);
        this.initAccessible();
        this.clrBG = clrBG;
        this.setBackground(clrBG);
    }

    public void paintControl(PaintEvent pev) {
        Display d = Display.getCurrent();
        GC gcCanvas = pev.gc;
        Rectangle rCA = this.getClientArea();
        int iWidth = rCA.height / 2 - 8;
        int iHeight = rCA.height - 16;
        if (this.imgBuffer == null) {
            this.imgBuffer = new Image((Device)d, rCA.width, rCA.height);
            this.gcBuffer = new GC((Drawable)this.imgBuffer);
        }
        if (!this.isEnabled()) {
            this.gcBuffer.setBackground(d.getSystemColor(22));
        } else {
            this.gcBuffer.setBackground(this.clrBG);
        }
        this.gcBuffer.setForeground(d.getSystemColor(15));
        this.gcBuffer.fillRectangle(rCA);
        this.p.x = 10;
        this.p.y = iHeight / 2 + 8;
        this.gcBuffer.setForeground(d.getSystemColor(2));
        this.gcBuffer.setBackground(d.getSystemColor(3));
        int i = -90;
        while (i <= 90) {
            double dRadians = Math.toRadians(i);
            int x = (int)((double)this.p.x + (double)iWidth * Math.cos(dRadians));
            int y = (int)((double)this.p.y - (double)iWidth * Math.sin(dRadians));
            if (i % 45 == 0) {
                AngleSelectorComposite.bigPoint(d, this.gcBuffer, x, y, i == this.iLastAngle);
            } else {
                AngleSelectorComposite.smallPoint(d, this.gcBuffer, x, y, i == this.iLastAngle);
            }
            i += 15;
        }
        this.iRadius = iWidth;
        this.drawHand(d, this.gcBuffer, this.p.x, this.p.y, this.iRadius - 10, this.iLastAngle, false);
        gcCanvas.drawImage(this.imgBuffer, 0, 0);
    }

    private static final void bigPoint(Display d, GC gc, int x, int y, boolean bSelected) {
        gc.setForeground(d.getSystemColor(2));
        gc.setBackground(d.getSystemColor(bSelected ? 3 : 2));
        int[] iaXY = new int[]{x, y - 3, x - 3, y, x, y + 3, x + 3, y};
        gc.fillPolygon(iaXY);
        gc.drawPolygon(iaXY);
    }

    private static final void smallPoint(Display d, GC gc, int x, int y, boolean bSelected) {
        gc.setForeground(d.getSystemColor(bSelected ? 3 : 2));
        gc.drawRectangle(x - 1, y - 1, 1, 1);
    }

    private final void drawHand(Display d, GC gc, int x, int y, int r, double dAngleInDegrees, boolean bErase) {
        gc.setForeground(bErase ? this.clrBG : d.getSystemColor(2));
        gc.setBackground(bErase ? this.clrBG : d.getSystemColor(3));
        double dAngleInRadians = Math.toRadians(dAngleInDegrees);
        int rMinus = r - 10;
        double dAngleInRadiansMinus = Math.toRadians(dAngleInDegrees - 3.0);
        double dAngleInRadiansPlus = Math.toRadians(dAngleInDegrees + 3.0);
        int xTip = (int)((double)x + (double)r * Math.cos(dAngleInRadians));
        int yTip = (int)((double)y - (double)r * Math.sin(dAngleInRadians));
        gc.drawLine(x, y, xTip, yTip);
        this.iaPolygon[0] = xTip;
        this.iaPolygon[1] = yTip;
        this.iaPolygon[2] = (int)((double)x + (double)rMinus * Math.cos(dAngleInRadiansMinus));
        this.iaPolygon[3] = (int)((double)y - (double)rMinus * Math.sin(dAngleInRadiansMinus));
        this.iaPolygon[4] = (int)((double)x + (double)rMinus * Math.cos(dAngleInRadiansPlus));
        this.iaPolygon[5] = (int)((double)y - (double)rMinus * Math.sin(dAngleInRadiansPlus));
        gc.fillPolygon(this.iaPolygon);
        gc.drawPolygon(this.iaPolygon);
    }

    public void mouseDoubleClick(MouseEvent arg0) {
    }

    public void mouseDown(MouseEvent mev) {
        this.bMouseDown = true;
        this.updateAngle(mev.x, mev.y);
    }

    public void mouseUp(MouseEvent mev) {
        this.bMouseDown = false;
    }

    public void mouseMove(MouseEvent mev) {
        if (!this.bMouseDown) {
            return;
        }
        this.updateAngle(mev.x, mev.y);
    }

    private final void updateAngle(int mx, int my) {
        int y;
        int x;
        int iAngle = (int)Math.toDegrees(Math.atan2(-(my - this.p.y), mx - this.p.x));
        if (iAngle > 90) {
            iAngle = 90;
        }
        if (iAngle < -90) {
            iAngle = -90;
        }
        if (iAngle == this.iLastAngle) {
            return;
        }
        Display d = Display.getCurrent();
        GC gc = new GC((Drawable)this);
        this.drawHand(d, gc, this.p.x, this.p.y, this.iRadius - 10, this.iLastAngle, true);
        if (this.iLastAngle % 45 == 0) {
            x = (int)((double)this.p.x + (double)this.iRadius * Math.cos(Math.toRadians(this.iLastAngle)));
            y = (int)((double)this.p.y - (double)this.iRadius * Math.sin(Math.toRadians(this.iLastAngle)));
            AngleSelectorComposite.bigPoint(d, gc, x, y, false);
        } else if (this.iLastAngle % 15 == 0) {
            x = (int)((double)this.p.x + (double)this.iRadius * Math.cos(Math.toRadians(this.iLastAngle)));
            y = (int)((double)this.p.y - (double)this.iRadius * Math.sin(Math.toRadians(this.iLastAngle)));
            AngleSelectorComposite.smallPoint(d, gc, x, y, false);
        }
        this.iLastAngle = iAngle;
        this.drawHand(d, gc, this.p.x, this.p.y, this.iRadius - 10, this.iLastAngle, false);
        if (this.iLastAngle % 45 == 0) {
            x = (int)((double)this.p.x + (double)this.iRadius * Math.cos(Math.toRadians(this.iLastAngle)));
            y = (int)((double)this.p.y - (double)this.iRadius * Math.sin(Math.toRadians(this.iLastAngle)));
            AngleSelectorComposite.bigPoint(d, gc, x, y, true);
        } else if (this.iLastAngle % 15 == 0) {
            x = (int)((double)this.p.x + (double)this.iRadius * Math.cos(Math.toRadians(this.iLastAngle)));
            y = (int)((double)this.p.y - (double)this.iRadius * Math.sin(Math.toRadians(this.iLastAngle)));
            AngleSelectorComposite.smallPoint(d, gc, x, y, true);
        }
        gc.dispose();
        if (this.iacl != null) {
            this.iacl.angleChanged(iAngle);
        }
    }

    public final void setAngleChangeListener(IAngleChangeListener iacl) {
        this.iacl = iacl;
    }

    public void setAngle(int iNewAngle) {
        this.iLastAngle = iNewAngle;
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.imgBuffer != null) {
            this.gcBuffer.dispose();
            this.imgBuffer.dispose();
            this.gcBuffer = null;
            this.imgBuffer = null;
        }
    }

    public void controlResized(ControlEvent e) {
        if (this.imgBuffer != null) {
            this.gcBuffer.dispose();
            this.imgBuffer.dispose();
            this.gcBuffer = null;
            this.imgBuffer = null;
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = AngleSelectorComposite.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = AngleSelectorComposite.this.toControl(new Point(e.x, e.y));
                if (AngleSelectorComposite.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = AngleSelectorComposite.this.getBounds();
                Point pt = AngleSelectorComposite.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
    }
}

