/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.quantitation;

import org.eclipse.chemclipse.model.quantitation.AbstractIdentificationWindow;
import org.eclipse.chemclipse.model.quantitation.IRetentionTimeWindow;

public class RetentionTimeWindow
extends AbstractIdentificationWindow
implements IRetentionTimeWindow {
    private static final long serialVersionUID = -8489097558854054118L;
    private int retentionTime;
    private boolean useMilliseconds = true;

    @Override
    public int getRetentionTime() {
        return this.retentionTime;
    }

    @Override
    public void setRetentionTime(int retentionTime) {
        if (retentionTime >= 0) {
            this.retentionTime = retentionTime;
        }
    }

    @Override
    public boolean isUseMilliseconds() {
        return this.useMilliseconds;
    }

    @Override
    public void setUseMilliseconds(boolean useMilliseconds) {
        this.useMilliseconds = useMilliseconds;
    }

    @Override
    public boolean isRetentionTimeInWindow(int retentionTime) {
        int rightBorder;
        int leftBorder;
        if (this.useMilliseconds) {
            leftBorder = (int)((float)this.retentionTime - this.getAllowedNegativeDeviation());
            rightBorder = (int)((float)this.retentionTime + this.getAllowedPositiveDeviation());
        } else {
            leftBorder = (int)((float)this.retentionTime - (float)this.retentionTime * this.getAllowedNegativeDeviation());
            rightBorder = (int)((float)this.retentionTime + (float)this.retentionTime * this.getAllowedPositiveDeviation());
        }
        return retentionTime >= leftBorder && retentionTime <= rightBorder;
    }
}

