/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.INoiseCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.NoiseCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.AbstractChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransitionSettings;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.identifier.chromatogram.IChromatogramTargetMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.DefaultNoiseCalculator;
import org.eclipse.chemclipse.msd.model.implementation.ImmutableZeroIon;
import org.eclipse.chemclipse.msd.model.implementation.IonTransitionSettings;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractChromatogramMSD
extends AbstractChromatogram
implements IChromatogramMSD {
    public static int DEFAULT_SEGMENT_WIDTH = 10;
    private static final Logger logger = Logger.getLogger(AbstractChromatogramMSD.class);
    private List<IChromatogramPeakMSD> peaks = new ArrayList<IChromatogramPeakMSD>();
    private Set<IChromatogramTargetMSD> targets = new HashSet<IChromatogramTargetMSD>();
    private IIonTransitionSettings ionTransitionSettings = new IonTransitionSettings();
    private INoiseCalculator noiseCalculator;
    private ImmutableZeroIon immutableZeroIon;

    public AbstractChromatogramMSD() {
        int segmentWidth = DEFAULT_SEGMENT_WIDTH;
        try {
            this.immutableZeroIon = new ImmutableZeroIon();
        }
        catch (AbundanceLimitExceededException | IonLimitExceededException e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (PreferenceSupplier.isAvailable()) {
            segmentWidth = PreferenceSupplier.getSelectedSegmentWidth();
            String noiseCalculatorId = PreferenceSupplier.getSelectedNoiseCalculatorId();
            this.noiseCalculator = NoiseCalculator.getNoiseCalculator((String)noiseCalculatorId);
            if (this.noiseCalculator == null) {
                this.noiseCalculator = new DefaultNoiseCalculator();
            }
        } else {
            this.noiseCalculator = new DefaultNoiseCalculator();
        }
        this.noiseCalculator.setChromatogram((IChromatogram)this, segmentWidth);
    }

    public void recalculateTheNoiseFactor() {
        if (this.noiseCalculator != null) {
            this.noiseCalculator.recalculate();
        }
    }

    public float getSignalToNoiseRatio(float abundance) {
        if (this.noiseCalculator != null) {
            return this.noiseCalculator.getSignalToNoiseRatio(abundance);
        }
        return 0.0f;
    }

    @Override
    public int getNumberOfScanIons() {
        int amount = 0;
        for (IScan scan : this.getScans()) {
            if (!(scan instanceof IVendorMassSpectrum)) continue;
            IVendorMassSpectrum ms = (IVendorMassSpectrum)scan;
            amount += ms.getNumberOfIons();
        }
        return amount;
    }

    @Override
    public void enforceLoadScanProxies(IProgressMonitor monitor) {
        for (IScan scan : this.getScans()) {
            if (!(scan instanceof IVendorMassSpectrum) || this.isUnloaded()) continue;
            monitor.subTask("Load Scan Proxy " + scan.getScanNumber());
            IVendorMassSpectrum ms = (IVendorMassSpectrum)scan;
            ms.enforceLoadScanProxy();
        }
    }

    public void fireUpdate(IChromatogramSelection chromatogramSelection) {
        if (chromatogramSelection instanceof ChromatogramSelectionMSD) {
            ((ChromatogramSelectionMSD)chromatogramSelection).update(true);
        }
    }

    @Override
    public IScanMSD getScan(int scan, IMarkedIons excludedIons) {
        IVendorMassSpectrum supplierMassSpectrum = this.getSupplierScan(scan);
        if (supplierMassSpectrum == null) {
            return null;
        }
        IScanMSD massSpectrum = supplierMassSpectrum.getMassSpectrum(excludedIons);
        return massSpectrum;
    }

    @Override
    public IVendorMassSpectrum getSupplierScan(int scan) {
        IScan storedScan;
        int position = scan;
        if (position > 0 && position <= this.getScans().size() && (storedScan = (IScan)this.getScans().get(--position)) instanceof IVendorMassSpectrum) {
            return (IVendorMassSpectrum)storedScan;
        }
        return null;
    }

    @Override
    public float getMinIonAbundance() {
        float minAbundance = Float.MAX_VALUE;
        for (IScan scan : this.getScans()) {
            IVendorMassSpectrum ms;
            IIon ion;
            if (!(scan instanceof IVendorMassSpectrum) || this.isZeroImmutableIon(ion = (ms = (IVendorMassSpectrum)scan).getLowestAbundance()) || !(ion.getAbundance() < minAbundance)) continue;
            minAbundance = ion.getAbundance();
        }
        return minAbundance;
    }

    @Override
    public float getMaxIonAbundance() {
        float maxAbundance = Float.MIN_VALUE;
        for (IScan scan : this.getScans()) {
            IVendorMassSpectrum ms;
            IIon ion;
            if (!(scan instanceof IVendorMassSpectrum) || this.isZeroImmutableIon(ion = (ms = (IVendorMassSpectrum)scan).getHighestAbundance()) || !(ion.getAbundance() > maxAbundance)) continue;
            maxAbundance = ion.getAbundance();
        }
        return maxAbundance;
    }

    @Override
    public double getStartIon() {
        if (this.getScans().size() == 0) {
            return 0.0;
        }
        double lowestIon = Double.MAX_VALUE;
        for (IScan scan : this.getScans()) {
            double actualIon;
            IVendorMassSpectrum ms;
            IIon ion;
            if (!(scan instanceof IVendorMassSpectrum) || this.isZeroImmutableIon(ion = (ms = (IVendorMassSpectrum)scan).getLowestIon()) || !((actualIon = ion.getIon()) < lowestIon)) continue;
            lowestIon = actualIon;
        }
        return lowestIon;
    }

    @Override
    public double getStopIon() {
        if (this.getScans().size() == 0) {
            return 0.0;
        }
        double highestIon = Double.MIN_VALUE;
        for (IScan scan : this.getScans()) {
            double actualIon;
            IVendorMassSpectrum ms;
            IIon ion;
            if (!(scan instanceof IVendorMassSpectrum) || this.isZeroImmutableIon(ion = (ms = (IVendorMassSpectrum)scan).getHighestIon()) || !((actualIon = ion.getIon()) > highestIon)) continue;
            highestIon = actualIon;
        }
        return highestIon;
    }

    @Override
    public List<IChromatogramPeakMSD> getPeaks() {
        return this.peaks;
    }

    @Override
    public List<IChromatogramPeakMSD> getPeaks(IChromatogramSelectionMSD chromatogramSelection) {
        ArrayList<IChromatogramPeakMSD> peakList = new ArrayList<IChromatogramPeakMSD>();
        if (chromatogramSelection != null) {
            int startRetentionTime = chromatogramSelection.getStartRetentionTime();
            int stopRetentionTime = chromatogramSelection.getStopRetentionTime();
            for (IChromatogramPeakMSD peak : this.peaks) {
                int peakRetentionTime = peak.getPeakModel().getRetentionTimeAtPeakMaximum();
                if (peakRetentionTime < startRetentionTime || peakRetentionTime > stopRetentionTime) continue;
                peakList.add(peak);
            }
        }
        return peakList;
    }

    @Override
    public void addPeak(IChromatogramPeakMSD peak) {
        if (!this.peaks.contains(peak) && peak.getPeakModel().getWidthByInflectionPoints() > 0) {
            this.peaks.add(peak);
        }
    }

    @Override
    public void removePeak(IChromatogramPeakMSD peak) {
        this.peaks.remove(peak);
    }

    @Override
    public void removePeaks(List<IChromatogramPeakMSD> peaksToDelete) {
        this.peaks.removeAll(peaksToDelete);
    }

    public void removeAllPeaks() {
        this.peaks.clear();
    }

    public int getNumberOfPeaks() {
        return this.peaks.size();
    }

    @Override
    public IChromatogramPeakMSD getPeak(int retentionTime) {
        IChromatogramPeakMSD selectedPeak = null;
        for (IChromatogramPeakMSD peak : this.peaks) {
            int peakStartRetentionTime = peak.getPeakModel().getStartRetentionTime();
            int peakStopRetentionTime = peak.getPeakModel().getStopRetentionTime();
            if (retentionTime < peakStartRetentionTime || retentionTime > peakStopRetentionTime) continue;
            selectedPeak = peak;
            break;
        }
        return selectedPeak;
    }

    public double getPeakIntegratedArea() {
        double integratedArea = 0.0;
        for (IChromatogramPeakMSD peak : this.peaks) {
            integratedArea += peak.getIntegratedArea();
        }
        return integratedArea;
    }

    @Override
    public IIonTransitionSettings getIonTransitionSettings() {
        return this.ionTransitionSettings;
    }

    @Override
    public void addTarget(IChromatogramTargetMSD chromatogramTarget) {
        if (chromatogramTarget != null) {
            this.targets.add(chromatogramTarget);
        }
    }

    @Override
    public void removeTarget(IChromatogramTargetMSD chromatogramTarget) {
        this.targets.remove(chromatogramTarget);
    }

    @Override
    public void removeTargets(List<IChromatogramTargetMSD> targetsToRemove) {
        this.targets.removeAll(targetsToRemove);
    }

    public void removeAllTargets() {
        this.targets.clear();
    }

    @Override
    public List<IChromatogramTargetMSD> getTargets() {
        ArrayList<IChromatogramTargetMSD> targetList = new ArrayList<IChromatogramTargetMSD>(this.targets);
        return targetList;
    }

    private boolean isZeroImmutableIon(IIon ion) {
        return this.immutableZeroIon.equals(ion);
    }
}

