/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.matlab.parafac.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.msd.converter.io.IPeakWriter;
import org.eclipse.chemclipse.msd.converter.processing.peak.IPeakExportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.processing.peak.PeakExportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.chemclipse.support.settings.OperatingSystemUtils;
import org.eclipse.chemclipse.support.text.ValueFormat;

public class MatlabParafacPeakWriter
implements IPeakWriter {
    private String lineSeparator;
    private int peakCounter = 1;
    private DecimalFormat decimalFormat;

    public MatlabParafacPeakWriter() {
        this.setLineSeparator();
        this.decimalFormat = ValueFormat.getDecimalFormatEnglish();
    }

    public IPeakExportConverterProcessingInfo write(File file, IPeakMSD peak, boolean append) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        PeakExportConverterProcessingInfo processingInfo = new PeakExportConverterProcessingInfo();
        FileWriter fileWriter = new FileWriter(file, append);
        this.writePeak(fileWriter, peak, (IProcessingInfo)processingInfo);
        fileWriter.close();
        processingInfo.setFile(file);
        return processingInfo;
    }

    public IPeakExportConverterProcessingInfo write(File file, IPeaks peaks, boolean append) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        PeakExportConverterProcessingInfo processingInfo = new PeakExportConverterProcessingInfo();
        FileWriter fileWriter = new FileWriter(file, append);
        this.writePeaks(fileWriter, peaks, (IProcessingInfo)processingInfo);
        fileWriter.close();
        processingInfo.setFile(file);
        return processingInfo;
    }

    private void writePeaks(FileWriter fileWriter, IPeaks peaks, IProcessingInfo processingInfo) throws IOException {
        int size = peaks.size();
        int i = 1;
        while (i <= size) {
            IPeak peak = peaks.getPeak(i);
            if (peak instanceof IPeakMSD) {
                IPeakMSD peakMSD = (IPeakMSD)peak;
                this.writePeak(fileWriter, peakMSD, processingInfo);
            }
            ++i;
        }
    }

    private void writePeak(FileWriter fileWriter, IPeakMSD peak, IProcessingInfo processingInfo) throws IOException {
        fileWriter.write(this.getPeakHeader());
        fileWriter.write(this.getDescription(peak));
        fileWriter.write(this.getMassSpectrum(peak));
        fileWriter.write(this.getElutionProfile(peak));
        fileWriter.flush();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.INFO, "Export Peak", "The given peak was exported successfully.");
        processingInfo.addMessage((IProcessingMessage)processingMessage);
    }

    private String getPeakHeader() {
        StringBuilder builder = new StringBuilder();
        builder.append("#------------------------------------------");
        builder.append(this.lineSeparator);
        builder.append("#");
        builder.append(this.lineSeparator);
        builder.append("#");
        builder.append(" ");
        builder.append("Peak");
        builder.append(" ");
        builder.append(this.peakCounter++);
        builder.append(this.lineSeparator);
        builder.append("#");
        builder.append(this.lineSeparator);
        return builder.toString();
    }

    private String getDescription(IPeakMSD peak) {
        StringBuilder builder = new StringBuilder();
        builder.append("description");
        builder.append("\t");
        String modelDescription = peak.getModelDescription();
        if (modelDescription == null || modelDescription.equals("")) {
            builder.append("Detector [");
            builder.append(peak.getDetectorDescription());
            builder.append("], RT (Minutes) [");
            double retentionTimeInMinutes = (double)peak.getPeakModel().getRetentionTimeAtPeakMaximum() / 60000.0;
            builder.append(this.decimalFormat.format(retentionTimeInMinutes));
            builder.append("]");
        } else {
            builder.append(modelDescription);
        }
        builder.append(this.lineSeparator);
        return builder.toString();
    }

    private String getMassSpectrum(IPeakMSD peak) {
        IPeakMassSpectrum peakMassSpectrum = peak.getPeakModel().getPeakMassSpectrum();
        IExtractedIonSignal extractedIonSignal = peakMassSpectrum.getExtractedIonSignal();
        int startIon = extractedIonSignal.getStartIon();
        int stopIon = extractedIonSignal.getStopIon();
        StringBuilder builder = new StringBuilder();
        builder.append("# mass spectrum (m/z - intensity)");
        builder.append(this.lineSeparator);
        int ion = startIon;
        while (ion <= stopIon) {
            float abundance = extractedIonSignal.getAbundance(ion);
            if (abundance > 0.0f) {
                builder.append(ion);
                builder.append("\t");
                builder.append(abundance);
                builder.append(this.lineSeparator);
            }
            ++ion;
        }
        return builder.toString();
    }

    private String getElutionProfile(IPeakMSD peak) {
        IPeakModelMSD peakModel = peak.getPeakModel();
        StringBuilder builder = new StringBuilder();
        builder.append("# elution profile (minutes converted to milliseconds - intensity)");
        builder.append(this.lineSeparator);
        for (Integer retentionTime : peakModel.getRetentionTimes()) {
            builder.append(retentionTime);
            builder.append("\t");
            builder.append(peakModel.getPeakAbundance(retentionTime.intValue()));
            builder.append(this.lineSeparator);
        }
        return builder.toString();
    }

    private void setLineSeparator() {
        this.lineSeparator = OperatingSystemUtils.isWindows() ? "\r\n" : (OperatingSystemUtils.isMac() ? "\r" : "\n");
    }
}

