/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.matlab.parafac.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.implementation.Peaks;
import org.eclipse.chemclipse.msd.converter.io.IPeakReader;
import org.eclipse.chemclipse.msd.converter.processing.peak.IPeakImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.processing.peak.PeakImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.supplier.matlab.parafac.internal.converter.ParseStatus;
import org.eclipse.chemclipse.msd.converter.supplier.matlab.parafac.internal.converter.PeakSupport;
import org.eclipse.chemclipse.msd.model.core.IPeakIon;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.PeakIon;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public class MatlabParafacPeakReader
implements IPeakReader {
    private static final Logger logger = Logger.getLogger(MatlabParafacPeakReader.class);
    private ParseStatus parseStatus;

    public IPeakImportConverterProcessingInfo read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        PeakImportConverterProcessingInfo processingInfo = new PeakImportConverterProcessingInfo();
        this.validateContent(file, (IPeakImportConverterProcessingInfo)processingInfo);
        this.readPeaks(file, (IPeakImportConverterProcessingInfo)processingInfo);
        return processingInfo;
    }

    private void validateContent(File file, IPeakImportConverterProcessingInfo processingInfo) throws FileIsNotReadableException, IOException {
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String firstLine = bufferedReader.readLine();
        bufferedReader.close();
        fileReader.close();
        if (!firstLine.equals("#------------------------------------------")) {
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Import Peak", "The given file contains no valid *.mpl peak list: " + file);
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
    }

    private void readPeaks(File file, IPeakImportConverterProcessingInfo processingInfo) throws FileIsNotReadableException, IOException, IllegalArgumentException {
        String line;
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        Peaks peaks = new Peaks();
        PeakSupport peakSupport = null;
        while ((line = bufferedReader.readLine()) != null) {
            if (line.equals("")) continue;
            if (line.equals("#------------------------------------------")) {
                if (peakSupport != null) {
                    this.addPeak((IPeaks)peaks, peakSupport, (IProcessingInfo)processingInfo, file);
                }
                peakSupport = new PeakSupport();
                this.parseStatus = ParseStatus.DESCRIPTION;
            }
            this.parseLine(line, peakSupport, (IProcessingInfo)processingInfo);
        }
        this.addPeak((IPeaks)peaks, peakSupport, (IProcessingInfo)processingInfo, file);
        processingInfo.setPeaks((IPeaks)peaks);
        bufferedReader.close();
        fileReader.close();
    }

    private void addPeak(IPeaks peaks, PeakSupport peakSupport, IProcessingInfo processingInfo, File file) {
        try {
            peaks.addPeak((IPeak)peakSupport.getPeak());
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.INFO, "Import Peak", this.getMessage("Successfully imported the peak", peakSupport.getModelDescription(), file.getAbsolutePath()));
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        catch (PeakException e) {
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.WARN, "Import Peak", this.getMessage("The peak couldn't be created", peakSupport.getModelDescription(), file.getAbsolutePath()));
            processingInfo.addMessage((IProcessingMessage)processingMessage);
            logger.warn((Object)e);
        }
    }

    private String getMessage(String message, String peakDescription, String file) {
        StringBuilder builder = new StringBuilder();
        builder.append(message);
        builder.append(" :'");
        builder.append(peakDescription);
        builder.append("' from file: '");
        builder.append(file);
        builder.append("'");
        return builder.toString();
    }

    private void parseLine(String line, PeakSupport peakSupport, IProcessingInfo processingInfo) {
        if (line.startsWith("#")) {
            if (line.startsWith("# mass spectrum")) {
                this.parseStatus = ParseStatus.MASS_SPECTRUM;
            } else if (line.startsWith("# elution profile")) {
                this.parseStatus = ParseStatus.ELUTION_PROFILE;
            }
        } else {
            String[] values = line.split("\t");
            switch (this.parseStatus) {
                case DESCRIPTION: {
                    if (values[0] == null || !values[0].equals("description")) break;
                    peakSupport.setModelDescription(values[1]);
                    break;
                }
                case MASS_SPECTRUM: {
                    int ion = Integer.parseInt(values[0]);
                    float abundance = Float.parseFloat(values[1]);
                    try {
                        PeakIon peakIon = new PeakIon((double)ion, abundance);
                        peakSupport.getPeakMaximum().addIon((IPeakIon)peakIon);
                    }
                    catch (AbundanceLimitExceededException e) {
                        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.WARN, "Import Peak", "The ion abundance exceeds its limit: " + line);
                        processingInfo.addMessage((IProcessingMessage)processingMessage);
                        logger.warn((Object)e);
                    }
                    catch (IonLimitExceededException e) {
                        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.WARN, "Import Peak", "The ion value exceeds its limit: " + line);
                        processingInfo.addMessage((IProcessingMessage)processingMessage);
                        logger.warn((Object)e);
                    }
                    break;
                }
                case ELUTION_PROFILE: {
                    int retentionTime = Integer.parseInt(values[0]);
                    float relativeIntensity = Float.parseFloat(values[1]);
                    peakSupport.getPeakIntensityValues().addIntensityValue(retentionTime, relativeIntensity);
                }
            }
        }
    }
}

