/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.IBeanListProperty;
import org.eclipse.core.databinding.property.list.DelegatingListProperty;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;
import org.eclipse.core.internal.databinding.beans.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnonymousBeanListProperty<S, E>
extends DelegatingListProperty<S, E> {
    private final String propertyName;
    private Map<Class<? extends S>, IListProperty<S, E>> delegates;

    public AnonymousBeanListProperty(String propertyName, Class<E> elementType) {
        super(elementType);
        this.propertyName = propertyName;
        this.delegates = new HashMap<Class<? extends S>, IListProperty<S, E>>();
    }

    protected IListProperty<S, E> doGetDelegate(S source) {
        IBeanListProperty delegate;
        Class<S> beanClass = Util.getClass(source);
        if (this.delegates.containsKey(beanClass)) {
            return this.delegates.get(beanClass);
        }
        try {
            delegate = BeanProperties.list(beanClass, this.propertyName, this.getElementClass());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            delegate = null;
        }
        this.delegates.put(beanClass, delegate);
        return delegate;
    }

    public String toString() {
        String s = "?." + this.propertyName + "[]";
        Class elementType = this.getElementClass();
        if (elementType != null) {
            s = String.valueOf(s) + "<" + BeanPropertyHelper.shortClassName(elementType) + ">";
        }
        return s;
    }
}

