/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.peak;

import java.text.DecimalFormat;
import java.util.Iterator;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.notifier.IChromatogramSelectionMSDUpdateNotifier;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class PeakValuesListUI
extends Composite
implements IChromatogramSelectionMSDUpdateNotifier {
    private List list;
    private Clipboard clipboard;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();
    private StringBuilder stringBuilder = new StringBuilder();

    public PeakValuesListUI(Composite parent, int style) {
        super(parent, style);
        this.initialize(parent);
    }

    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        IChromatogramPeakMSD peak = chromatogramSelection.getSelectedPeak();
        if (peak != null) {
            this.setPeakValues(peak);
        }
    }

    private void initialize(Composite parent) {
        this.setLayout((Layout)new FillLayout());
        this.clipboard = new Clipboard(Display.getDefault());
        this.list = new List((Composite)this, 2818);
        this.list.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    StringBuilder builder = new StringBuilder();
                    String[] stringArray = PeakValuesListUI.this.list.getSelection();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String selection = stringArray[n2];
                        builder.append(selection);
                        builder.append("\n");
                        ++n2;
                    }
                    if (builder.length() == 0) {
                        builder.append("Please select one or more entries in the list.\n");
                    }
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    Object[] data = new Object[]{builder.toString()};
                    Transfer[] dataTypes = new Transfer[]{textTransfer};
                    PeakValuesListUI.this.clipboard.setContents(data, dataTypes);
                }
            }
        });
    }

    private void setPeakValues(IChromatogramPeakMSD peak) {
        this.list.removeAll();
        IPeakModelMSD peakModel = peak.getPeakModel();
        this.list.add("PeakType: " + peak.getPeakType());
        this.list.add("Purity: " + this.decimalFormat.format(peak.getPurity()));
        LinearEquation equation = peakModel.getIncreasingInflectionPointEquation();
        this.list.add(this.getEquationString("Increasing Inflection Point Equation: ", equation));
        equation = peakModel.getDecreasingInflectionPointEquation();
        this.list.add(this.getEquationString("Decreasing Inflection Point Equation: ", equation));
        equation = peakModel.getPercentageHeightBaselineEquation(0.5f);
        this.list.add(this.getEquationString("Percentage Baseline Equation 50%: ", equation));
        this.list.add("Gradient Angle: " + this.decimalFormat.format(peakModel.getGradientAngle()));
        this.list.add("-------------------------");
        this.addRetentionTimes(peakModel);
    }

    private void addRetentionTimes(IPeakModelMSD peakModel) {
        this.list.add("milliseconds  -  abundance  -  background  -  minutes");
        Iterator iterator = peakModel.getRetentionTimes().iterator();
        while (iterator.hasNext()) {
            int retentionTime = (Integer)iterator.next();
            double minutes = (double)retentionTime / 60000.0;
            float abundance = peakModel.getPeakAbundance(retentionTime);
            float background = peakModel.getBackgroundAbundance(retentionTime);
            this.clearStringBuilder();
            this.stringBuilder.append(this.decimalFormat.format(retentionTime));
            this.stringBuilder.append(" - ");
            this.stringBuilder.append(this.decimalFormat.format(abundance));
            this.stringBuilder.append(" - ");
            this.stringBuilder.append(this.decimalFormat.format(background));
            this.stringBuilder.append(" - ");
            this.stringBuilder.append(this.decimalFormat.format(minutes));
            this.list.add(this.stringBuilder.toString());
        }
    }

    private String getEquationString(String description, LinearEquation equation) {
        this.clearStringBuilder();
        this.stringBuilder.append(description);
        double b = equation.getB();
        this.stringBuilder.append("f(x)=");
        this.stringBuilder.append(this.decimalFormat.format(equation.getA()));
        if (b < 0.0) {
            this.stringBuilder.append("x");
        } else {
            this.stringBuilder.append("x+");
        }
        this.stringBuilder.append(this.decimalFormat.format(equation.getB()));
        return this.stringBuilder.toString();
    }

    private void clearStringBuilder() {
        this.stringBuilder.delete(0, this.stringBuilder.length());
    }
}

