/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.examples;

import java.util.Calendar;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.KeyListener;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.Sample;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.ToolbarArmedXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.ZoomType;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

class XYGraphTest2
extends Figure {
    public Trace trace1;
    public Trace trace2;
    public Trace trace3;
    public IXYGraph xyGraph = new XYGraph();
    public Runnable updater;
    private double updateIndex = 0.0;
    private final CircularBufferDataProvider trace2Provider;
    boolean running = false;
    private long t;
    private final Trace trace4;
    private final ToolbarArmedXYGraph toolbarArmedXYGraph;

    public XYGraphTest2() {
        this.xyGraph.setTitle("XY Graph Test");
        this.xyGraph.setFont(XYGraphMediaFactory.getInstance().getFont(XYGraphMediaFactory.FONT_TAHOMA));
        this.xyGraph.getPrimaryXAxis().setTitle("Time");
        this.xyGraph.getPrimaryYAxis().setTitle("Amplitude");
        this.xyGraph.getPrimaryXAxis().setRange(new Range(0.0, 200.0));
        this.xyGraph.getPrimaryXAxis().setDateEnabled(true);
        this.xyGraph.getPrimaryYAxis().setAutoScale(true);
        this.xyGraph.getPrimaryXAxis().setAutoScale(true);
        this.xyGraph.getPrimaryXAxis().setShowMajorGrid(true);
        this.xyGraph.getPrimaryYAxis().setShowMajorGrid(true);
        this.xyGraph.getPrimaryXAxis().setAutoScaleThreshold(0.0);
        Axis x2Axis = new Axis("X-2", false);
        x2Axis.setTickLableSide(AbstractScale.LabelSide.Secondary);
        this.xyGraph.addAxis(x2Axis);
        Axis y2Axis = new Axis("Log Scale", true);
        y2Axis.setRange(10.0, 1000.0);
        y2Axis.setLogScale(true);
        y2Axis.setForegroundColor(XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_PINK));
        y2Axis.setTickLableSide(AbstractScale.LabelSide.Secondary);
        this.xyGraph.addAxis(y2Axis);
        this.trace2Provider = new CircularBufferDataProvider(true);
        this.trace2Provider.setBufferSize(100);
        this.trace2Provider.setUpdateDelay(100);
        this.trace2 = new Trace("Trace 2", this.xyGraph.getPrimaryXAxis(), this.xyGraph.getPrimaryYAxis(), this.trace2Provider);
        this.trace2.setDataProvider(this.trace2Provider);
        this.trace2.setTraceType(Trace.TraceType.SOLID_LINE);
        this.trace2.setLineWidth(1);
        this.trace2.setPointStyle(Trace.PointStyle.CIRCLE);
        this.trace2.setPointSize(1);
        this.trace2.setBaseLine(Trace.BaseLine.NEGATIVE_INFINITY);
        this.trace2.setAreaAlpha(100);
        this.trace2.setAntiAliasing(true);
        this.trace2.setErrorBarEnabled(true);
        this.trace2.setYErrorBarType(Trace.ErrorBarType.BOTH);
        this.trace2.setXErrorBarType(Trace.ErrorBarType.NONE);
        this.trace2.setErrorBarCapWidth(3);
        this.xyGraph.addTrace(this.trace2);
        final CircularBufferDataProvider trace3Provider = new CircularBufferDataProvider(true);
        this.trace3 = new Trace("Trace3", this.xyGraph.getPrimaryXAxis(), this.xyGraph.getPrimaryYAxis(), trace3Provider);
        this.trace3.setPointStyle(Trace.PointStyle.XCROSS);
        this.trace3.setTraceType(Trace.TraceType.BAR);
        this.trace3.setLineWidth(4);
        trace3Provider.setUpdateDelay(100);
        this.xyGraph.addTrace(this.trace3);
        final CircularBufferDataProvider trace4Provider = new CircularBufferDataProvider(false);
        this.trace4 = new Trace("Trace 4-Lissajous", x2Axis, y2Axis, trace4Provider);
        this.trace4.setPointStyle(Trace.PointStyle.POINT);
        this.trace4.setPointSize(2);
        trace4Provider.setUpdateDelay(100);
        trace4Provider.setBufferSize(100);
        this.xyGraph.addTrace(this.trace4);
        this.toolbarArmedXYGraph = new ToolbarArmedXYGraph(this.xyGraph);
        this.add((IFigure)this.toolbarArmedXYGraph);
        this.toolbarArmedXYGraph.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                XYGraphTest2.this.toolbarArmedXYGraph.requestFocus();
            }
        });
        this.toolbarArmedXYGraph.addKeyListener((KeyListener)new KeyListener.Stub(){

            public void keyPressed(KeyEvent ke) {
                if (ke.getState() == 262144 && ke.keycode == 122) {
                    XYGraphTest2.this.xyGraph.getOperationsManager().undo();
                }
                if (ke.getState() == 262144 && ke.keycode == 121) {
                    XYGraphTest2.this.xyGraph.getOperationsManager().redo();
                }
                if (ke.getState() == 262144 && ke.keycode == 120) {
                    XYGraphTest2.this.xyGraph.performAutoScale();
                }
                if (ke.getState() == 262144 && ke.keycode == 115) {
                    ImageLoader loader = new ImageLoader();
                    loader.data = new ImageData[]{XYGraphTest2.this.xyGraph.getImage().getImageData()};
                    FileDialog dialog = new FileDialog(Display.getDefault().getShells()[0], 8192);
                    dialog.setFilterNames(new String[]{"PNG Files", "All Files (*.*)"});
                    dialog.setFilterExtensions(new String[]{"*.png", "*.*"});
                    String path = dialog.open();
                    if (path != null && !path.equals("")) {
                        loader.save(path, 5);
                    }
                }
                if (ke.getState() == 262144 && ke.keycode + 97 - 97 == 116) {
                    switch (XYGraphTest2.this.xyGraph.getZoomType()) {
                        case RUBBERBAND_ZOOM: {
                            XYGraphTest2.this.xyGraph.setZoomType(ZoomType.HORIZONTAL_ZOOM);
                            break;
                        }
                        case HORIZONTAL_ZOOM: {
                            XYGraphTest2.this.xyGraph.setZoomType(ZoomType.VERTICAL_ZOOM);
                            break;
                        }
                        case VERTICAL_ZOOM: {
                            XYGraphTest2.this.xyGraph.setZoomType(ZoomType.ZOOM_IN);
                            break;
                        }
                        case ZOOM_IN: {
                            XYGraphTest2.this.xyGraph.setZoomType(ZoomType.ZOOM_OUT);
                            break;
                        }
                        case ZOOM_OUT: {
                            XYGraphTest2.this.xyGraph.setZoomType(ZoomType.PANNING);
                            break;
                        }
                        case PANNING: {
                            XYGraphTest2.this.xyGraph.setZoomType(ZoomType.NONE);
                            break;
                        }
                        case NONE: {
                            XYGraphTest2.this.xyGraph.setZoomType(ZoomType.RUBBERBAND_ZOOM);
                            break;
                        }
                    }
                }
            }
        });
        this.updater = new Runnable(){

            @Override
            public void run() {
                XYGraphTest2 xYGraphTest2 = XYGraphTest2.this;
                xYGraphTest2.t = xYGraphTest2.t + 60000L;
                trace3Provider.setCurrentYData(Math.cos(XYGraphTest2.this.updateIndex), XYGraphTest2.this.t);
                if (XYGraphTest2.this.updateIndex >= 10.0 && XYGraphTest2.this.updateIndex <= 10.5 || XYGraphTest2.this.updateIndex >= 20.0 && XYGraphTest2.this.updateIndex <= 20.2) {
                    XYGraphTest2.this.trace2Provider.addSample(new Sample(XYGraphTest2.this.t, Double.NaN));
                    XYGraphTest2.this.running = false;
                } else {
                    Sample sampe = new Sample(XYGraphTest2.this.t, Math.sin(XYGraphTest2.this.updateIndex), 0.1 * Math.random(), 0.1 * Math.random(), (double)XYGraphTest2.this.t * 1.0E-7 * Math.random(), (double)XYGraphTest2.this.t * 1.0E-7 * Math.random(), "sdfsf");
                    XYGraphTest2.this.trace2Provider.addSample(sampe);
                }
                XYGraphTest2.this.trace2Provider.setCurrentYDataTimestamp(XYGraphTest2.this.t);
                trace4Provider.setCurrentXData(Math.sin(XYGraphTest2.this.updateIndex + 10.0) * 20.0 + 50.0);
                trace4Provider.setCurrentYData(Math.cos(XYGraphTest2.this.updateIndex) * 30.0 + 50.0);
                XYGraphTest2 xYGraphTest22 = XYGraphTest2.this;
                xYGraphTest22.updateIndex = xYGraphTest22.updateIndex + 0.1;
                if (XYGraphTest2.this.running) {
                    Display.getCurrent().timerExec(1, (Runnable)this);
                }
            }
        };
        Display.getCurrent().timerExec(1000, this.updater);
        this.running = true;
        this.t = Calendar.getInstance().getTimeInMillis();
    }

    protected void layout() {
        this.toolbarArmedXYGraph.setBounds(this.bounds.getCopy().shrink(5, 5));
        super.layout();
    }
}

