/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.processing.IPeakFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.processing.PeakFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.result.IPeakFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.PeakFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IPeakFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.peak.AbstractPeakFilter;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.settings.IIonRemoverPeakFilterSettings;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakFilter
extends AbstractPeakFilter {
    private static final String DESCRIPTION = "Ion Remover Peak Filter";

    public IPeakFilterProcessingInfo applyFilter(List<IPeakMSD> peaks, IPeakFilterSettings peakFilterSettings, IProgressMonitor monitor) {
        PeakFilterProcessingInfo processingInfo = new PeakFilterProcessingInfo();
        processingInfo.addMessages(this.validate(peaks, peakFilterSettings));
        if (processingInfo.hasErrorMessages()) {
            return processingInfo;
        }
        if (peakFilterSettings instanceof IIonRemoverPeakFilterSettings) {
            IIonRemoverPeakFilterSettings ionRemoverPeakFilterSettings = (IIonRemoverPeakFilterSettings)peakFilterSettings;
            IMarkedIons ionsToRemove = ionRemoverPeakFilterSettings.getIonsToRemove();
            for (IPeakMSD peak : peaks) {
                peak.getTargets().clear();
                IPeakMassSpectrum peakMassSpectrum = peak.getPeakModel().getPeakMassSpectrum();
                peakMassSpectrum.removeIons(ionsToRemove);
            }
            processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, DESCRIPTION, "The mass spectrum has been optimized successfully."));
        } else {
            processingInfo.addErrorMessage(DESCRIPTION, "The filter settings instance is not a type of: " + IIonRemoverPeakFilterSettings.class);
        }
        PeakFilterResult peakFilterResult = new PeakFilterResult(ResultStatus.OK, "The ion remover filter has been applied successfully.");
        processingInfo.setPeakFilterResult((IPeakFilterResult)peakFilterResult);
        return processingInfo;
    }

    public IPeakFilterProcessingInfo applyFilter(IPeakMSD peak, IPeakFilterSettings peakFilterSettings, IProgressMonitor monitor) {
        ArrayList<IPeakMSD> peaks = new ArrayList<IPeakMSD>();
        peaks.add(peak);
        return this.applyFilter(peaks, peakFilterSettings, monitor);
    }

    public IPeakFilterProcessingInfo applyFilter(IPeakMSD peak, IProgressMonitor monitor) {
        ArrayList<IPeakMSD> peaks = new ArrayList<IPeakMSD>();
        peaks.add(peak);
        IPeakFilterSettings peakFilterSettings = PreferenceSupplier.getPeakFilterSettings();
        return this.applyFilter(peaks, peakFilterSettings, monitor);
    }

    public IPeakFilterProcessingInfo applyFilter(List<IPeakMSD> peaks, IProgressMonitor monitor) {
        IPeakFilterSettings peakFilterSettings = PreferenceSupplier.getPeakFilterSettings();
        return this.applyFilter(peaks, peakFilterSettings, monitor);
    }

    public IPeakFilterProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IPeakFilterSettings peakFilterSettings, IProgressMonitor monitor) {
        PeakFilterProcessingInfo processingInfo = new PeakFilterProcessingInfo();
        processingInfo.addMessages(this.validate(chromatogramSelection, peakFilterSettings));
        if (processingInfo.hasErrorMessages()) {
            return processingInfo;
        }
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        List peakList = chromatogram.getPeaks(chromatogramSelection);
        ArrayList<IPeakMSD> peaks = new ArrayList<IPeakMSD>();
        for (IChromatogramPeakMSD peak : peakList) {
            peaks.add((IPeakMSD)peak);
        }
        return this.applyFilter(peaks, peakFilterSettings, monitor);
    }

    public IPeakFilterProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IProgressMonitor monitor) {
        IPeakFilterSettings peakFilterSettings = PreferenceSupplier.getPeakFilterSettings();
        return this.applyFilter(chromatogramSelection, peakFilterSettings, monitor);
    }
}

