/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.ui.views;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.ui.modifier.FilterModifierShift;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.ui.preferences.PreferencePage;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.swt.ui.components.chromatogram.MultipleChromatogramOffsetUI;
import org.eclipse.chemclipse.swt.ui.preferences.SWTPreferencePage;
import org.eclipse.chemclipse.swt.ui.support.AxisTitlesIntensityScale;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.chemclipse.ux.extension.xxd.ui.views.AbstractChromatogramOverlayView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ChromatogramShiftView
extends AbstractChromatogramOverlayView {
    private static final Logger logger = Logger.getLogger(ChromatogramShiftView.class);
    @Inject
    private Composite composite;
    private MultipleChromatogramOffsetUI chromatogramOverlayUI;
    private Button buttonShiftLeft;
    private Button buttonShiftLeftFast;
    private Button buttonShiftRight;
    private Button buttonShiftRightFast;
    private Label labelStatusDataDisplay;

    @Inject
    public ChromatogramShiftView(EPartService partService, MPart part, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
    }

    @PostConstruct
    private void createControl() {
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.createButtonBar(this.composite);
        this.createOverlayChart(this.composite);
    }

    private void createButtonBar(Composite composite) {
        Composite compositeLeft = new Composite(composite, 0);
        compositeLeft.setLayoutData((Object)new GridData(768));
        compositeLeft.setLayout((Layout)new GridLayout(1, false));
        Composite compositeRight = new Composite(composite, 0);
        GridData gridDataCompositeRight = new GridData(768);
        gridDataCompositeRight.horizontalAlignment = 0x1000008;
        compositeRight.setLayoutData((Object)gridDataCompositeRight);
        compositeRight.setLayout((Layout)new GridLayout(5, false));
        this.createHeaderLeft(compositeLeft);
        this.createHeaderRight(compositeRight);
        this.setWidgetStatus();
    }

    private void createHeaderLeft(Composite composite) {
        this.labelStatusDataDisplay = new Label(composite, 0);
        this.labelStatusDataDisplay.setText("DATA EDIT MODUS");
        this.labelStatusDataDisplay.setBackground(Colors.YELLOW);
        this.labelStatusDataDisplay.setLayoutData((Object)new GridData(768));
    }

    private void createHeaderRight(Composite composite) {
        this.createButtonSettings(composite);
        this.createButtonOffsetLeft(composite);
        this.createButtonOffsetLeftFast(composite);
        this.createButtonOffsetRight(composite);
        this.createButtonOffsetRightFast(composite);
    }

    private void createButtonSettings(Composite composite) {
        Button buttonSettings = new Button(composite, 8);
        buttonSettings.setText("");
        buttonSettings.setToolTipText("Open Settings");
        buttonSettings.setImage(ApplicationImageFactory.getInstance().getImage("configure.gif", "16x16"));
        buttonSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTPreferencePage preferencePage = new SWTPreferencePage();
                preferencePage.setTitle("Display Settings");
                PreferencePage preferencePageOverlay = new PreferencePage();
                preferencePageOverlay.setTitle("RT Shifter/Offset settings");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePage));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)preferencePageOverlay));
                PreferenceDialog preferenceDialog = new PreferenceDialog(Display.getCurrent().getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Overlay/Shifter Settings");
                if (preferenceDialog.open() == 0) {
                    ChromatogramShiftView.this.update(ChromatogramShiftView.this.getChromatogramSelection(), false);
                }
            }
        });
    }

    private void createButtonOffsetLeft(Composite composite) {
        this.buttonShiftLeft = new Button(composite, 8);
        this.buttonShiftLeft.setText("");
        this.buttonShiftLeft.setToolTipText("Shift left");
        this.buttonShiftLeft.setImage(ApplicationImageFactory.getInstance().getImage("offsetLeft.gif", "16x16"));
        this.buttonShiftLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramShiftView.this.shiftChromatogram(PreferenceSupplier.getMillisecondsToShiftBackward());
            }
        });
    }

    private void createButtonOffsetLeftFast(Composite composite) {
        this.buttonShiftLeftFast = new Button(composite, 8);
        this.buttonShiftLeftFast.setText("");
        this.buttonShiftLeftFast.setToolTipText("Shift left fast");
        this.buttonShiftLeftFast.setImage(ApplicationImageFactory.getInstance().getImage("offsetLeftFast.gif", "16x16"));
        this.buttonShiftLeftFast.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramShiftView.this.shiftChromatogram(PreferenceSupplier.getMillisecondsToShiftFastBackward());
            }
        });
    }

    private void createButtonOffsetRight(Composite composite) {
        this.buttonShiftRight = new Button(composite, 8);
        this.buttonShiftRight.setText("");
        this.buttonShiftRight.setToolTipText("Shift right");
        this.buttonShiftRight.setImage(ApplicationImageFactory.getInstance().getImage("offsetRight.gif", "16x16"));
        this.buttonShiftRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramShiftView.this.shiftChromatogram(PreferenceSupplier.getMillisecondsToShiftForward());
            }
        });
    }

    private void createButtonOffsetRightFast(Composite composite) {
        this.buttonShiftRightFast = new Button(composite, 8);
        this.buttonShiftRightFast.setText("");
        this.buttonShiftRightFast.setToolTipText("Shift right fast");
        this.buttonShiftRightFast.setImage(ApplicationImageFactory.getInstance().getImage("offsetRightFast.gif", "16x16"));
        this.buttonShiftRightFast.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramShiftView.this.shiftChromatogram(PreferenceSupplier.getMillisecondsToShiftFastForward());
            }
        });
    }

    private void createOverlayChart(Composite composite) {
        this.chromatogramOverlayUI = new MultipleChromatogramOffsetUI(composite, 0, (IAxisTitles)new AxisTitlesIntensityScale());
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.chromatogramOverlayUI.setLayoutData((Object)gridData);
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.chromatogramOverlayUI.setFocus();
        this.update(this.getChromatogramSelection(), false);
    }

    public void update(IChromatogramSelection chromatogramSelection, boolean forceReload) {
        if (this.doUpdate(chromatogramSelection)) {
            this.setWidgetStatus();
            List chromatogramSelections = this.getChromatogramSelections(chromatogramSelection, false);
            this.chromatogramOverlayUI.updateSelection(chromatogramSelections, forceReload);
        }
    }

    private void setWidgetStatus() {
        this.buttonShiftLeft.setEnabled(true);
        this.buttonShiftLeftFast.setEnabled(true);
        this.buttonShiftRight.setEnabled(true);
        this.buttonShiftRightFast.setEnabled(true);
    }

    private void resetOffsets() {
        PreferenceSupplier.resetOffset();
        List chromatogramSelections = this.getChromatogramSelections(this.getChromatogramSelection(), false);
        for (IChromatogramSelection chromatogramSelection : chromatogramSelections) {
            chromatogramSelection.resetOffset();
        }
    }

    private void shiftChromatogram(int millisecondsToShift) {
        this.resetOffsets();
        this.runShiftChromatogram(this.getChromatogramSelection(), millisecondsToShift);
    }

    private void runShiftChromatogram(IChromatogramSelection chromatogramSelection, int millisecondsToShift) {
        StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Start RTShifter Filter");
        Display display = Display.getCurrent();
        FilterModifierShift runnable = new FilterModifierShift(chromatogramSelection, millisecondsToShift);
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(display.getActiveShell());
        try {
            monitor.run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"RTShifter Filter finished");
    }
}

