/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.handlers;

import java.util.List;
import javax.inject.Named;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DeleteAllIdentificationsHandler
implements EventHandler {
    private static IChromatogramSelectionMSD chromatogramSelection;

    @Execute
    public void execute(UISynchronize uiSynchronize, @Named(value="activeShell") Shell shell) {
        IChromatogramMSD chromatogram;
        if (chromatogramSelection != null && (chromatogram = chromatogramSelection.getChromatogramMSD()) != null) {
            MessageBox messageBox = new MessageBox(shell, 456);
            messageBox.setText("Delete All Identifications");
            messageBox.setMessage("Do you really want to delete all identifications?");
            int decision = messageBox.open();
            if (64 == decision) {
                chromatogram.removeAllTargets();
                List peaks = chromatogram.getPeaks();
                for (IChromatogramPeakMSD peak : peaks) {
                    peak.removeAllTargets();
                }
                if (chromatogramSelection instanceof ChromatogramSelectionMSD) {
                    ((ChromatogramSelectionMSD)chromatogramSelection).update(true);
                }
            }
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("chromatogram/msd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
        }
    }
}

