/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.csd.ui.views;

import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.ux.extension.csd.ui.views.IChromatogramAndPeakSelectionView;
import org.eclipse.chemclipse.ux.extension.ui.definitions.ChromatogramType;
import org.eclipse.chemclipse.ux.extension.ui.definitions.PeakType;
import org.eclipse.chemclipse.ux.extension.ui.explorer.AbstractSelectionView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractChromatogramAndPeakSelectionView
extends AbstractSelectionView
implements IChromatogramAndPeakSelectionView {
    private IChromatogramSelectionCSD chromatogramSelection;
    private IChromatogramPeakCSD chromatogramPeak;
    private IEventBroker eventBroker;
    private EventHandler eventHandler;

    public AbstractChromatogramAndPeakSelectionView(MPart part, EPartService partService, IEventBroker eventBroker) {
        super(part, partService);
        this.eventBroker = eventBroker;
        this.subscribe();
    }

    @Override
    public IChromatogramSelectionCSD getChromatogramSelection() {
        if (this.chromatogramSelection == null) {
            this.chromatogramSelection = ChromatogramType.getChromatogramSelectionCSD();
        }
        return this.chromatogramSelection;
    }

    @Override
    public void setChromatogramSelection(IChromatogramSelectionCSD chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    @Override
    public IChromatogramPeakCSD getChromatogramPeak() {
        IPeakCSD peakCSD;
        if (this.chromatogramPeak == null && (peakCSD = PeakType.getSelectedPeakCSD()) instanceof IChromatogramPeakCSD) {
            this.chromatogramPeak = (IChromatogramPeakCSD)peakCSD;
        }
        return this.chromatogramPeak;
    }

    @Override
    public void setChromatogramPeak(IChromatogramPeakCSD chromatogramPeak) {
        this.chromatogramPeak = chromatogramPeak;
    }

    @Override
    public boolean doUpdate(IChromatogramSelectionCSD chromatogramSelection, IChromatogramPeakCSD chromatogramPeak) {
        return this.isPartVisible() && chromatogramSelection != null && chromatogramPeak != null;
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    AbstractChromatogramAndPeakSelectionView.this.chromatogramSelection = (IChromatogramSelectionCSD)event.getProperty("ChromatogramSelection");
                    AbstractChromatogramAndPeakSelectionView.this.chromatogramPeak = (IChromatogramPeakCSD)event.getProperty("ChromatogramPeakCSD");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    AbstractChromatogramAndPeakSelectionView.this.update(AbstractChromatogramAndPeakSelectionView.this.chromatogramSelection, AbstractChromatogramAndPeakSelectionView.this.chromatogramPeak, forceReload);
                }
            };
            this.eventBroker.subscribe("chromatogram/csd/update/chromatogramandpeakselection", this.eventHandler);
        }
    }

    public void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }
}

