/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection.event;

import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.RowVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.ISelectionEvent;

public class RowSelectionEvent
extends RowVisualChangeEvent
implements ISelectionEvent {
    private final SelectionLayer selectionLayer;
    private int rowPositionToMoveIntoViewport;

    public RowSelectionEvent(SelectionLayer selectionLayer, Collection<Integer> rowPositions, int rowPositionToMoveIntoViewport) {
        super((ILayer)selectionLayer, PositionUtil.getRanges(rowPositions));
        this.selectionLayer = selectionLayer;
        this.rowPositionToMoveIntoViewport = rowPositionToMoveIntoViewport;
    }

    protected RowSelectionEvent(RowSelectionEvent event) {
        super(event);
        this.selectionLayer = event.selectionLayer;
        this.rowPositionToMoveIntoViewport = event.rowPositionToMoveIntoViewport;
    }

    @Override
    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public int getRowPositionToMoveIntoViewport() {
        return this.rowPositionToMoveIntoViewport;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        this.rowPositionToMoveIntoViewport = localLayer.underlyingToLocalRowPosition(this.getLayer(), this.rowPositionToMoveIntoViewport);
        return super.convertToLocal(localLayer);
    }

    @Override
    public RowSelectionEvent cloneEvent() {
        return new RowSelectionEvent(this);
    }
}

