/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.group.RowGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.RowGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.model.IRowGroupModel;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionUtils;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRowGroupsCommand;
import org.eclipse.nebula.widgets.nattable.selection.event.RowSelectionEvent;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.swt.graphics.Rectangle;

public class SelectRowGroupCommandHandler<T>
extends AbstractLayerCommandHandler<SelectRowGroupsCommand> {
    private final IRowGroupModel<T> model;
    private final RowGroupHeaderLayer<T> rowGroupHeaderLayer;
    private final SelectionLayer selectionLayer;

    public SelectRowGroupCommandHandler(IRowGroupModel<T> model, SelectionLayer selectionLayer, RowGroupHeaderLayer<T> rowGroupHeaderLayer) {
        this.model = model;
        this.selectionLayer = selectionLayer;
        this.rowGroupHeaderLayer = rowGroupHeaderLayer;
    }

    @Override
    public Class<SelectRowGroupsCommand> getCommandClass() {
        return SelectRowGroupsCommand.class;
    }

    @Override
    protected boolean doCommand(SelectRowGroupsCommand command) {
        List<Integer> rowIndexes = RowGroupUtils.getRowIndexesInGroup(this.model, this.rowGroupHeaderLayer.getRowIndexByPosition(command.getRowPosition()));
        List<Integer> rowPositions = RowGroupUtils.getRowPositionsInGroup(this.selectionLayer, rowIndexes);
        this.selectRows(command.getColumnPosition(), rowPositions, command.isWithShiftMask(), command.isWithControlMask(), command.getRowPositionToMoveIntoViewport(), command.isMoveAnchorToTopOfGroup());
        return true;
    }

    protected void selectRows(int columnPosition, List<Integer> rowPositions, boolean withShiftMask, boolean withControlMask, int rowPositionToMoveIntoViewport, boolean moveAnchorToTopOfGroup) {
        HashSet<Range> changedRowRanges = new HashSet<Range>();
        if (rowPositions.size() > 0) {
            changedRowRanges.addAll(this.internalSelectRow(columnPosition, rowPositions.get(0), rowPositions.size(), withShiftMask, withControlMask, moveAnchorToTopOfGroup));
        }
        HashSet<Integer> changedRows = new HashSet<Integer>();
        for (Range range : changedRowRanges) {
            int i = range.start;
            while (i < range.end) {
                changedRows.add(i);
                ++i;
            }
        }
        this.selectionLayer.fireLayerEvent(new RowSelectionEvent(this.selectionLayer, changedRows, rowPositionToMoveIntoViewport));
    }

    private Set<Range> internalSelectRow(int columnPosition, int rowPosition, int rowCount, boolean withShiftMask, boolean withControlMask, boolean moveAnchorToTopOfGroup) {
        HashSet<Range> changedRowRanges = new HashSet<Range>();
        if (SelectionUtils.noShiftOrControl(withShiftMask, withControlMask)) {
            changedRowRanges.addAll(this.selectionLayer.getSelectedRowPositions());
            this.selectionLayer.clear(false);
            this.selectionLayer.selectCell(0, rowPosition, withShiftMask, withControlMask);
            this.selectionLayer.selectRegion(0, rowPosition, this.selectionLayer.getColumnCount(), rowCount);
            changedRowRanges.add(new Range(rowPosition, rowPosition + rowCount));
        } else if (SelectionUtils.isControlOnly(withShiftMask, withControlMask)) {
            changedRowRanges.add(this.selectRowWithCtrlKey(columnPosition, rowPosition, rowCount));
        } else if (SelectionUtils.isShiftOnly(withShiftMask, withControlMask)) {
            changedRowRanges.add(this.selectRowWithShiftKey(columnPosition, rowPosition, rowCount));
        }
        if (moveAnchorToTopOfGroup) {
            this.selectionLayer.moveSelectionAnchor(columnPosition, rowPosition);
        }
        this.selectionLayer.getLastSelectedCellPosition().columnPosition = this.selectionLayer.getColumnCount() - 1;
        this.selectionLayer.getLastSelectedCellPosition().rowPosition = rowPosition;
        return changedRowRanges;
    }

    private Range selectRowWithCtrlKey(int columnPosition, int rowPosition, int rowCount) {
        Rectangle selectedRowRectangle = new Rectangle(0, rowPosition, this.selectionLayer.getColumnCount(), rowCount);
        if (this.selectionLayer.isRowPositionFullySelected(rowPosition)) {
            this.selectionLayer.clearSelection(selectedRowRectangle);
            if (this.selectionLayer.getLastSelectedRegion() != null && this.selectionLayer.getLastSelectedRegion().equals((Object)selectedRowRectangle)) {
                this.selectionLayer.setLastSelectedRegion(null);
            }
        } else {
            if (this.selectionLayer.getLastSelectedRegion() != null) {
                this.selectionLayer.selectionModel.addSelection(new Rectangle(this.selectionLayer.getLastSelectedRegion().x, this.selectionLayer.getLastSelectedRegion().y, this.selectionLayer.getLastSelectedRegion().width, this.selectionLayer.getLastSelectedRegion().height));
            }
            this.selectionLayer.selectRegion(0, rowPosition, this.selectionLayer.getColumnCount(), rowCount);
        }
        return new Range(rowPosition, rowPosition + 1);
    }

    private Range selectRowWithShiftKey(int columnPosition, int rowPosition, int rowCount) {
        if (this.selectionLayer.getLastSelectedRegion() != null) {
            int start = Math.min(this.selectionLayer.getLastSelectedRegion().y, rowPosition);
            int end = Math.max(this.selectionLayer.getLastSelectedRegion().y, rowPosition);
            int i = start;
            while (i <= end) {
                int index = this.selectionLayer.getRowIndexByPosition(i);
                if (RowGroupUtils.isPartOfAGroup(this.model, index) && !this.selectionLayer.isRowPositionFullySelected(i)) {
                    ArrayList<Integer> rowPositions = new ArrayList<Integer>(RowGroupUtils.getRowPositionsInGroup(this.selectionLayer, RowGroupUtils.getRowIndexesInGroup(this.model, index)));
                    Collections.sort(rowPositions);
                    this.selectionLayer.selectRegion(0, (Integer)rowPositions.get(0), this.selectionLayer.getColumnCount(), rowPositions.size());
                    i = ObjectUtils.getLastElement(rowPositions);
                }
                ++i;
            }
        }
        return new Range(rowPosition, rowPosition + 1);
    }
}

