/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.quantitation.IInternalStandard;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class InternalStandardListLabelProvider
extends AbstractChemClipseLabelProvider {
    public InternalStandardListLabelProvider() {
        super("0.0##");
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IInternalStandard) {
            IInternalStandard internalStandard = (IInternalStandard)element;
            switch (columnIndex) {
                case 0: {
                    text = internalStandard.getName();
                    break;
                }
                case 1: {
                    text = decimalFormat.format(internalStandard.getConcentration());
                    break;
                }
                case 2: {
                    text = internalStandard.getConcentrationUnit();
                    break;
                }
                case 3: {
                    text = decimalFormat.format(internalStandard.getResponseFactor());
                    break;
                }
                case 4: {
                    text = internalStandard.getChemicalClass();
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("peak.gif", "16x16");
    }
}

