/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.components.peaks;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.quantitation.IInternalStandard;
import org.eclipse.chemclipse.model.quantitation.InternalStandard;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.components.peaks.InternalStandardsListUI;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PeakInternalStandardsEditListUI
extends Composite {
    private static final Logger logger = Logger.getLogger(PeakInternalStandardsEditListUI.class);
    private static final String ACTION_INITIALIZE = "ACTION_INITIALIZE";
    private static final String ACTION_CANCEL = "ACTION_CANCEL";
    private static final String ACTION_ADD = "ACTION_ADD";
    private static final String ACTION_DELETE = "ACTION_DELETE";
    private static final String ACTION_SELECT = "ACTION_SELECT";
    private InternalStandardsListUI peakInternalStandardsListUI;
    private Button buttonCancel;
    private Button buttonDelete;
    private Button buttonAdd;
    private Label labelPeakInfo;
    private Text textName;
    private Text textConcentration;
    private Text textConcentrationUnit;
    private Text textResponseFactor;
    private Text textChemicalClass;
    private Button buttonInternalStandardAdd;
    private IPeak peak;
    private DecimalFormat decimalFormat;

    public PeakInternalStandardsEditListUI(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.decimalFormat = ValueFormat.getDecimalFormatEnglish();
    }

    public void update(IPeak peak, boolean forceReload) {
        this.peak = peak;
        this.setPeakLabel(peak);
        if (peak != null) {
            this.peakInternalStandardsListUI.setInput(peak.getInternalStandards());
        } else {
            this.peakInternalStandardsListUI.setInput(null);
        }
    }

    private void initialize() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createLabelAndActionField(composite);
        this.createInputField(composite);
        this.createButtonField(composite);
        this.createTableField(composite);
        this.enableButtonFields(ACTION_INITIALIZE);
    }

    private void createLabelAndActionField(Composite composite) {
        Composite compositeLeft = new Composite(composite, 0);
        compositeLeft.setLayoutData((Object)new GridData(768));
        compositeLeft.setLayout((Layout)new GridLayout(1, false));
        Composite compositeRight = new Composite(composite, 0);
        GridData gridDataCompositeRight = new GridData(768);
        gridDataCompositeRight.horizontalAlignment = 0x1000008;
        compositeRight.setLayoutData((Object)gridDataCompositeRight);
        compositeRight.setLayout((Layout)new GridLayout(3, false));
        this.createHeaderLeft(compositeLeft);
        this.createHeaderRight(compositeRight);
    }

    private void createHeaderLeft(Composite composite) {
        this.labelPeakInfo = new Label(composite, 0);
        this.labelPeakInfo.setText("");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 9;
        this.labelPeakInfo.setLayoutData((Object)gridData);
    }

    private void createHeaderRight(Composite composite) {
        this.buttonCancel = new Button(composite, 8);
        this.buttonCancel.setImage(ApplicationImageFactory.getInstance().getImage("cancel.gif", "16x16"));
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeakInternalStandardsEditListUI.this.enableButtonFields(PeakInternalStandardsEditListUI.ACTION_CANCEL);
            }
        });
        this.buttonDelete = new Button(composite, 8);
        this.buttonDelete.setEnabled(false);
        this.buttonDelete.setImage(ApplicationImageFactory.getInstance().getImage("delete.gif", "16x16"));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Table table;
                int index;
                if (PeakInternalStandardsEditListUI.this.peak != null && (index = (table = PeakInternalStandardsEditListUI.this.peakInternalStandardsListUI.getTable()).getSelectionIndex()) >= 0) {
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 296);
                    messageBox.setText("Delete ion(s)?");
                    messageBox.setMessage("Would you like to delete the ISTD(s)?");
                    if (messageBox.open() == 32) {
                        TableItem[] tableItems;
                        PeakInternalStandardsEditListUI.this.enableButtonFields(PeakInternalStandardsEditListUI.ACTION_DELETE);
                        TableItem[] tableItemArray = tableItems = table.getSelection();
                        int n = tableItems.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem tableItem = tableItemArray[n2];
                            Object object = tableItem.getData();
                            if (object instanceof IInternalStandard) {
                                IInternalStandard internalStandard = (IInternalStandard)object;
                                PeakInternalStandardsEditListUI.this.peak.removeInternalStandard(internalStandard);
                            }
                            ++n2;
                        }
                        PeakInternalStandardsEditListUI.this.peakInternalStandardsListUI.update(PeakInternalStandardsEditListUI.this.peak.getInternalStandards(), true);
                    }
                }
            }
        });
        this.buttonAdd = new Button(composite, 8);
        this.buttonAdd.setImage(ApplicationImageFactory.getInstance().getImage("add.gif", "16x16"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeakInternalStandardsEditListUI.this.enableButtonFields(PeakInternalStandardsEditListUI.ACTION_ADD);
            }
        });
    }

    private void createInputField(Composite composite) {
        Composite compositeInput = new Composite(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        compositeInput.setLayoutData((Object)gridData);
        compositeInput.setLayout((Layout)new GridLayout(10, false));
        Label labelName = new Label(compositeInput, 0);
        labelName.setText("Name");
        this.textName = new Text(compositeInput, 2048);
        this.textName.setText("");
        this.textName.setLayoutData((Object)new GridData(768));
        Label labelContent = new Label(compositeInput, 0);
        labelContent.setText("Conc.");
        this.textConcentration = new Text(compositeInput, 2048);
        this.textConcentration.setText("");
        this.textConcentration.setLayoutData((Object)new GridData(768));
        Label labelConcentrationUnit = new Label(compositeInput, 0);
        labelConcentrationUnit.setText("Unit");
        this.textConcentrationUnit = new Text(compositeInput, 2048);
        this.textConcentrationUnit.setText("");
        this.textConcentrationUnit.setLayoutData((Object)new GridData(768));
        Label labelResponseFactor = new Label(compositeInput, 0);
        labelResponseFactor.setText("RF");
        this.textResponseFactor = new Text(compositeInput, 2048);
        this.textResponseFactor.setText("1.0");
        this.textResponseFactor.setLayoutData((Object)new GridData(768));
        Label labelChemicalClass = new Label(compositeInput, 0);
        labelChemicalClass.setText("Class");
        this.textChemicalClass = new Text(compositeInput, 2048);
        this.textChemicalClass.setText("");
        this.textChemicalClass.setLayoutData((Object)new GridData(768));
    }

    private void createButtonField(Composite composite) {
        this.buttonInternalStandardAdd = new Button(composite, 8);
        this.buttonInternalStandardAdd.setText("Add");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.buttonInternalStandardAdd.setLayoutData((Object)gridData);
        this.buttonInternalStandardAdd.setImage(ApplicationImageFactory.getInstance().getImage("execute.gif", "16x16"));
        this.buttonInternalStandardAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                if (PeakInternalStandardsEditListUI.this.peak == null) {
                    MessageBox messageBox = new MessageBox(shell, 40);
                    messageBox.setText("Add ISTD");
                    messageBox.setMessage("No peak has been selected.");
                    messageBox.open();
                } else {
                    try {
                        String name = PeakInternalStandardsEditListUI.this.textName.getText().trim();
                        double concentration = Double.parseDouble(PeakInternalStandardsEditListUI.this.textConcentration.getText().trim());
                        String concentrationUnit = PeakInternalStandardsEditListUI.this.textConcentrationUnit.getText().trim();
                        double responseFactor = Double.parseDouble(PeakInternalStandardsEditListUI.this.textResponseFactor.getText().trim());
                        String chemicalClass = PeakInternalStandardsEditListUI.this.textChemicalClass.getText().trim();
                        InternalStandard internalStandard = new InternalStandard(name, concentration, concentrationUnit, responseFactor);
                        internalStandard.setChemicalClass(chemicalClass);
                        if (PeakInternalStandardsEditListUI.this.peak.getInternalStandards().contains(internalStandard)) {
                            MessageBox messageBox = new MessageBox(shell, 296);
                            messageBox.setText("Add ISTD");
                            messageBox.setMessage("The ISTD exists already.");
                            messageBox.open();
                        } else {
                            PeakInternalStandardsEditListUI.this.peak.addInternalStandard((IInternalStandard)internalStandard);
                            PeakInternalStandardsEditListUI.this.textName.setText("");
                            PeakInternalStandardsEditListUI.this.textConcentration.setText("");
                            PeakInternalStandardsEditListUI.this.textConcentrationUnit.setText("");
                            PeakInternalStandardsEditListUI.this.textResponseFactor.setText("1.0");
                            PeakInternalStandardsEditListUI.this.textChemicalClass.setText("");
                            PeakInternalStandardsEditListUI.this.enableButtonFields(PeakInternalStandardsEditListUI.ACTION_INITIALIZE);
                            PeakInternalStandardsEditListUI.this.peakInternalStandardsListUI.update(PeakInternalStandardsEditListUI.this.peak.getInternalStandards(), true);
                        }
                    }
                    catch (Exception e1) {
                        logger.warn((Object)e1);
                        MessageBox messageBox = new MessageBox(shell, 40);
                        messageBox.setText("Add ISTD");
                        messageBox.setMessage("Please check the content, response factor and unit values.");
                        messageBox.open();
                    }
                }
            }
        });
    }

    private void createTableField(Composite composite) {
        Composite compositeTable = new Composite(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        compositeTable.setLayoutData((Object)gridData);
        compositeTable.setLayout((Layout)new FillLayout());
        this.peakInternalStandardsListUI = new InternalStandardsListUI(compositeTable, 68354);
        this.peakInternalStandardsListUI.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeakInternalStandardsEditListUI.this.enableButtonFields(PeakInternalStandardsEditListUI.ACTION_SELECT);
            }
        });
    }

    private void enableButtonFields(String action) {
        this.enableFields(false);
        switch (action) {
            case "ACTION_INITIALIZE": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_CANCEL": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_ADD": {
                this.buttonCancel.setEnabled(true);
                this.textName.setEnabled(true);
                this.textConcentration.setEnabled(true);
                this.textConcentrationUnit.setEnabled(true);
                this.textResponseFactor.setEnabled(true);
                this.textChemicalClass.setEnabled(true);
                this.buttonInternalStandardAdd.setEnabled(true);
                break;
            }
            case "ACTION_DELETE": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_SELECT": {
                this.buttonAdd.setEnabled(true);
                if (this.peakInternalStandardsListUI.getTable().getSelectionIndex() >= 0) {
                    this.buttonDelete.setEnabled(true);
                    break;
                }
                this.buttonDelete.setEnabled(false);
            }
        }
    }

    private void enableFields(boolean enabled) {
        this.buttonCancel.setEnabled(enabled);
        this.buttonDelete.setEnabled(enabled);
        this.buttonAdd.setEnabled(enabled);
        this.textName.setEnabled(enabled);
        this.textConcentration.setEnabled(enabled);
        this.textConcentrationUnit.setEnabled(enabled);
        this.textResponseFactor.setEnabled(enabled);
        this.textChemicalClass.setEnabled(enabled);
        this.buttonInternalStandardAdd.setEnabled(enabled);
    }

    private void setPeakLabel(IPeak peak) {
        if (peak != null) {
            IPeakModel peakModel = peak.getPeakModel();
            StringBuilder builder = new StringBuilder();
            builder.append("RT: ");
            builder.append(this.decimalFormat.format((double)peakModel.getRetentionTimeAtPeakMaximum() / 60000.0));
            builder.append(" | ");
            builder.append("Tailing: ");
            builder.append(this.decimalFormat.format(peakModel.getTailing()));
            builder.append(" | ");
            builder.append("Area: ");
            builder.append(Integer.valueOf((int)peak.getIntegratedArea()).toString());
            this.labelPeakInfo.setText(builder.toString());
        } else {
            this.labelPeakInfo.setText("No peak has been selected yet.");
        }
    }
}

