/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow;

import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.DefaultGlazedListsStaticFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;

public class ComboBoxGlazedListsFilterStrategy<T>
extends DefaultGlazedListsStaticFilterStrategy<T> {
    private FilterRowComboBoxDataProvider<T> comboBoxDataProvider;
    private MatcherEditor<T> matchNone = new AbstractMatcherEditor<T>(){
        {
            this.fireMatchNone();
        }
    };

    public ComboBoxGlazedListsFilterStrategy(FilterRowComboBoxDataProvider<T> comboBoxDataProvider, FilterList<T> filterList, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry) {
        super(filterList, columnAccessor, configRegistry);
        this.comboBoxDataProvider = comboBoxDataProvider;
    }

    public ComboBoxGlazedListsFilterStrategy(FilterRowComboBoxDataProvider<T> comboBoxDataProvider, FilterList<T> filterList, CompositeMatcherEditor<T> matcherEditor, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry) {
        super(filterList, matcherEditor, columnAccessor, configRegistry);
        this.comboBoxDataProvider = comboBoxDataProvider;
    }

    @Override
    public void applyFilter(Map<Integer, Object> filterIndexToObjectMap) {
        if (filterIndexToObjectMap.isEmpty()) {
            this.getMatcherEditor().getMatcherEditors().add(this.matchNone);
            return;
        }
        HashMap<Integer, Object> newIndexToObjectMap = new HashMap<Integer, Object>();
        newIndexToObjectMap.putAll(filterIndexToObjectMap);
        for (Integer index : this.comboBoxDataProvider.getCachedColumnIndexes()) {
            Collection filterCollection;
            List dataProviderList = this.comboBoxDataProvider.getValues(index.intValue(), 0);
            Object filterObject = newIndexToObjectMap.get(index);
            Collection collection = filterCollection = filterObject != null && filterObject instanceof Collection ? (Collection)filterObject : null;
            if (filterCollection == null || filterCollection.isEmpty()) {
                this.getMatcherEditor().getMatcherEditors().add(this.matchNone);
                return;
            }
            if (!this.filterCollectionsEqual(filterCollection, dataProviderList)) continue;
            newIndexToObjectMap.remove(index);
        }
        super.applyFilter(newIndexToObjectMap);
    }

    @Override
    protected String getStringFromColumnObject(int columnIndex, Object object) {
        IDisplayConverter displayConverter = (IDisplayConverter)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, "NORMAL", new String[]{"FILTER_COLUMN_" + columnIndex});
        if (object instanceof Collection) {
            String result = "";
            Collection valueCollection = (Collection)object;
            for (Object value : valueCollection) {
                String convertedValue;
                if (result.length() > 0) {
                    result = String.valueOf(result) + "|";
                }
                result = (convertedValue = displayConverter.canonicalToDisplayValue(value).toString()).isEmpty() ? String.valueOf(result) + "^$" : String.valueOf(result) + Pattern.quote(convertedValue);
            }
            return "(" + result + ")";
        }
        return displayConverter.canonicalToDisplayValue(object).toString();
    }

    protected boolean filterCollectionsEqual(Collection filter1, Collection filter2) {
        if (filter1 != null && filter2 != null && filter1.size() == filter2.size()) {
            if (!filter1.equals(filter2)) {
                for (Object f1 : filter1) {
                    if (filter2.contains(f1)) continue;
                    return false;
                }
                for (Object f2 : filter2) {
                    if (filter1.contains(f2)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

