/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.support;

import org.eclipse.chemclipse.converter.core.ISupplier;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.converter.model.IChromatogramOutputEntry;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;
import org.eclipse.chemclipse.logging.core.Logger;

public class ConverterTypeSupportCSD {
    private static final Logger logger = Logger.getLogger(ConverterTypeSupportCSD.class);
    public static final String NOT_AVAILABLE = "n.a.";

    public String getConverterName(IChromatogramOutputEntry entry) {
        String converterName = NOT_AVAILABLE;
        try {
            ISupplier converterSupplier = ChromatogramConverterCSD.getChromatogramConverterSupport().getSupplier(entry.getConverterId());
            converterName = converterSupplier.getFilterName();
        }
        catch (NoConverterAvailableException e) {
            logger.warn((Object)e);
        }
        return converterName;
    }
}

