/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.xy.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.csd.converter.io.AbstractChromatogramCSDWriter;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramWriter
extends AbstractChromatogramCSDWriter {
    public void writeChromatogram(File file, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        PrintWriter printWriter = new PrintWriter(file);
        for (IScan scan : chromatogram.getScans()) {
            double retentionTimeInMinutes = (double)scan.getRetentionTime() / 60000.0;
            printWriter.println(String.valueOf(retentionTimeInMinutes) + "\t" + scan.getTotalSignal());
        }
        printWriter.flush();
        printWriter.close();
    }
}

