/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.DataInputEntry;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IDataInputEntry;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IPcaResult;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IPcaResults;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.ISample;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors.PcaEditor;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.TimeRangeWizard;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PeakListIntensityTablePage {
    private PcaEditor pcaEditor;
    private int currentNumberOfPeaks;
    private Label tableHeader;
    private Table peakListIntensityTable;
    private NumberFormat numberFormat = ValueFormat.getNumberFormatEnglish();

    public PeakListIntensityTablePage(PcaEditor pcaEditor, TabFolder tabFolder, FormToolkit formToolkit) {
        this.pcaEditor = pcaEditor;
        this.initialize(tabFolder, formToolkit);
    }

    public void update() {
        if (this.peakListIntensityTable != null) {
            IPcaResults pcaResults = this.pcaEditor.getPcaResults();
            this.peakListIntensityTable.setRedraw(false);
            this.peakListIntensityTable.removeAll();
            while (this.peakListIntensityTable.getColumnCount() > 0) {
                this.peakListIntensityTable.getColumns()[0].dispose();
            }
            this.peakListIntensityTable.setRedraw(true);
            ArrayList<String> titleList = new ArrayList<String>();
            titleList.add("Times");
            Iterator iterator = pcaResults.getExtractedRetentionTimes().iterator();
            while (iterator.hasNext()) {
                int retentionTime = (Integer)iterator.next();
                titleList.add(this.numberFormat.format((double)retentionTime / 60000.0));
            }
            String[] titles = titleList.toArray(new String[titleList.size()]);
            this.currentNumberOfPeaks = titles.length - 1;
            TableColumn filenameColumn = new TableColumn(this.peakListIntensityTable, 0);
            filenameColumn.setText(titles[0]);
            filenameColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TimeRangeWizard tableWizard = new TimeRangeWizard();
                    WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)tableWizard);
                    int returnCode = wizardDialog.open();
                    String range = tableWizard.getTextOne();
                    if (returnCode == 0) {
                        System.out.println("Ok pressed");
                        int split = range.indexOf("-");
                        double startRange = Double.parseDouble(range.substring(0, split));
                        double endRange = Double.parseDouble(range.substring(split + 1));
                        if (endRange < startRange) {
                            return;
                        }
                        TableColumn[] columns = PeakListIntensityTablePage.this.peakListIntensityTable.getColumns();
                        boolean startRowSet = false;
                        int startRow = 0;
                        int endRow = 0;
                        double currentTitle = 0.0;
                        int i = 1;
                        while (i <= columns.length) {
                            currentTitle = Double.parseDouble(columns[i].getText());
                            if (currentTitle > startRange && !startRowSet) {
                                startRowSet = true;
                                startRow = i;
                            } else if (currentTitle > endRange) {
                                if (i == 0) break;
                                endRow = i - 1;
                                break;
                            }
                            ++i;
                        }
                        int j = 1;
                        while (j < startRow) {
                            columns[j].dispose();
                            PeakListIntensityTablePage peakListIntensityTablePage = PeakListIntensityTablePage.this;
                            peakListIntensityTablePage.currentNumberOfPeaks = peakListIntensityTablePage.currentNumberOfPeaks - 1;
                            ++j;
                        }
                        int k = endRow;
                        while (k < columns.length) {
                            columns[k].dispose();
                            PeakListIntensityTablePage peakListIntensityTablePage = PeakListIntensityTablePage.this;
                            peakListIntensityTablePage.currentNumberOfPeaks = peakListIntensityTablePage.currentNumberOfPeaks - 1;
                            ++k;
                        }
                        PeakListIntensityTablePage.this.redrawTableHeader(PeakListIntensityTablePage.this.currentNumberOfPeaks, columns[startRow].getText(), columns[endRow - 1].getText());
                    } else {
                        System.out.println("Cancel pressed");
                    }
                }
            });
            int i = 1;
            while (i < titles.length) {
                final TableColumn column = new TableColumn(this.peakListIntensityTable, 0);
                column.setText(titles[i]);
                column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        column.dispose();
                        PeakListIntensityTablePage peakListIntensityTablePage = PeakListIntensityTablePage.this;
                        peakListIntensityTablePage.currentNumberOfPeaks = peakListIntensityTablePage.currentNumberOfPeaks - 1;
                        TableColumn[] newColumns = PeakListIntensityTablePage.this.peakListIntensityTable.getColumns();
                        PeakListIntensityTablePage.this.redrawTableHeader(PeakListIntensityTablePage.this.currentNumberOfPeaks, newColumns[1].getText(), newColumns[newColumns.length - 1].getText());
                    }
                });
                ++i;
            }
            for (Map.Entry entry : pcaResults.getPcaResultMap().entrySet()) {
                double[] sampleData;
                int index = 0;
                TableItem item = new TableItem(this.peakListIntensityTable, 0);
                if (((ISample)entry.getKey()).isSelected()) {
                    item.setChecked(true);
                }
                item.setText(index++, ((ISample)entry.getKey()).getName());
                IPcaResult pcaResult = (IPcaResult)entry.getValue();
                double[] dArray = sampleData = pcaResult.getSampleData();
                int n = sampleData.length;
                int n2 = 0;
                while (n2 < n) {
                    double data = dArray[n2];
                    item.setText(index++, this.numberFormat.format(data));
                    ++n2;
                }
            }
            i = 0;
            while (i < titles.length) {
                this.peakListIntensityTable.getColumn(i).pack();
                ++i;
            }
            String peakStartPoint = titles[1];
            String peakEndPoint = titles[titles.length - 1];
            this.redrawTableHeader(this.currentNumberOfPeaks, peakStartPoint, peakEndPoint);
        }
    }

    private void initialize(TabFolder tabFolder, FormToolkit formToolkit) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Data Table");
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        formToolkit = new FormToolkit(composite.getDisplay());
        ScrolledForm scrolledForm = formToolkit.createScrolledForm(composite);
        Composite scrolledFormComposite = scrolledForm.getBody();
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Peak Intensity Table Editor");
        this.createPeakListIntensityTableSection(scrolledFormComposite, formToolkit);
        tabItem.setControl((Control)composite);
    }

    private void createPeakListIntensityTableSection(Composite parent, FormToolkit formToolkit) {
        Section section = formToolkit.createSection(parent, 384);
        section.setText("Peak Intensity Table");
        section.setDescription("Click on the Times box to specify a certain timerange to display\nClick on any time column header to delete the corresponding column\n\nClick on any filename(not the checkboxes) to exclude/include that specific file in table\nThe checkboxes currently show what files are included\n\nClick on the Re-Evaluate Button to recalcuate score plot and error chart\n");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        this.createButtonForPeakListTable(client, formToolkit);
        this.createPeakIntensityTableLabels(client, formToolkit);
        this.peakListIntensityTable = formToolkit.createTable(client, 0x10000022);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 300;
        gridData.widthHint = 100;
        gridData.verticalSpan = 3;
        this.peakListIntensityTable.setLayoutData((Object)gridData);
        this.peakListIntensityTable.setHeaderVisible(true);
        this.peakListIntensityTable.setLinesVisible(true);
        this.peakListIntensityTable.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selection = PeakListIntensityTablePage.this.peakListIntensityTable.getSelection();
                int i = 0;
                while (i < selection.length) {
                    selection[i].dispose();
                    ++i;
                }
            }
        });
        this.peakListIntensityTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IPcaResults pcaResults = PeakListIntensityTablePage.this.pcaEditor.getPcaResults();
                List dataInputEntries = pcaResults.getDataInputEntries();
                TableItem item = (TableItem)event.item;
                String filename = item.getText();
                Map resultMap = pcaResults.getPcaResultMap();
                for (ISample key : resultMap.keySet()) {
                    if (!key.getName().equals(filename)) continue;
                    if (key.isSelected()) {
                        key.setSelected(false);
                        item.setChecked(false);
                        for (IDataInputEntry entry : dataInputEntries) {
                            if (!entry.getName().equals(String.valueOf(key.getName()) + ".ocb")) continue;
                            dataInputEntries.remove(entry);
                        }
                        return;
                    }
                    key.setSelected(true);
                    item.setChecked(true);
                    DataInputEntry inputEntry = new DataInputEntry(String.valueOf(key.getName()) + ".ocb");
                    dataInputEntries.add(inputEntry);
                    return;
                }
            }
        });
        section.setClient((Control)client);
        formToolkit.paintBordersFor(client);
    }

    private void createButtonForPeakListTable(Composite client, FormToolkit formToolkit) {
        GridData gridData = new GridData(2);
        this.createReevaluateButton(client, gridData, formToolkit);
    }

    private void createPeakIntensityTableLabels(Composite client, FormToolkit formToolkit) {
        this.tableHeader = formToolkit.createLabel(client, "Peaks:  \t\tStart Peak:  \t End Peak: ", 0);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.tableHeader.setLayoutData((Object)gridData);
    }

    private void redrawTableHeader(int numPeaks, String startPoint, String endPoint) {
        IPcaResults pcaResults = this.pcaEditor.getPcaResults();
        if (pcaResults != null) {
            int inputEntriesSize = pcaResults.getDataInputEntries().size();
            if (pcaResults.getExtractionType() == 0) {
                this.tableHeader.setText(String.valueOf(Integer.toString(inputEntriesSize)) + "\t\tPeaks: " + numPeaks + " \t\tStart Peak: " + startPoint + "\t\tEnd Peak: " + endPoint);
            } else {
                this.tableHeader.setText(String.valueOf(Integer.toString(inputEntriesSize)) + "\t\tScans: " + numPeaks + " \t\tStart Scan: " + startPoint + "\t\tEnd Scan: " + endPoint);
            }
        } else {
            this.tableHeader.setText("No data available.");
        }
    }

    private void createReevaluateButton(Composite client, GridData gridData, FormToolkit formToolkit) {
        Button reevaluate = formToolkit.createButton(client, "Re-Evaluate", 8);
        reevaluate.setLayoutData((Object)gridData);
        reevaluate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                PeakListIntensityTablePage.this.pcaEditor.reEvaluatePcaCalculation();
            }
        });
    }
}

