/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.map.SimpleMapProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;
import org.eclipse.core.internal.databinding.beans.BeanPropertyListener;

public class BeanMapProperty
extends SimpleMapProperty {
    private final PropertyDescriptor propertyDescriptor;
    private final Class keyType;
    private final Class valueType;

    public BeanMapProperty(PropertyDescriptor propertyDescriptor, Class keyType, Class valueType) {
        this.propertyDescriptor = propertyDescriptor;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public Object getKeyType() {
        return this.keyType;
    }

    public Object getValueType() {
        return this.valueType;
    }

    protected Map doGetMap(Object source) {
        return this.asMap(BeanPropertyHelper.readProperty(source, this.propertyDescriptor));
    }

    private Map asMap(Object propertyValue) {
        if (propertyValue == null) {
            return Collections.EMPTY_MAP;
        }
        return (Map)propertyValue;
    }

    protected void doSetMap(Object source, Map map, MapDiff diff) {
        this.doSetMap(source, map);
    }

    protected void doSetMap(Object source, Map map) {
        BeanPropertyHelper.writeProperty(source, this.propertyDescriptor, map);
    }

    public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
        return new BeanPropertyListener((IProperty)this, this.propertyDescriptor, listener){

            @Override
            protected IDiff computeDiff(Object oldValue, Object newValue) {
                return Diffs.computeMapDiff((Map)BeanMapProperty.this.asMap(oldValue), (Map)BeanMapProperty.this.asMap(newValue));
            }
        };
    }

    public String toString() {
        String s = String.valueOf(BeanPropertyHelper.propertyName(this.propertyDescriptor)) + "{:}";
        if (this.keyType != null || this.valueType != null) {
            s = String.valueOf(s) + "<" + BeanPropertyHelper.shortClassName(this.keyType) + ", " + BeanPropertyHelper.shortClassName(this.valueType) + ">";
        }
        return s;
    }
}

