/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.standalone.ui.internal.startcommand;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryProjectUtil;
import org.eclipse.cft.server.core.internal.StringUtils;
import org.eclipse.cft.server.standalone.core.internal.startcommand.StartCommand;
import org.eclipse.cft.server.standalone.core.internal.startcommand.StartCommandType;
import org.eclipse.cft.server.standalone.ui.internal.startcommand.JavaStartCommandPart;
import org.eclipse.cft.server.standalone.ui.internal.startcommand.StartCommandPart;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class StartCommandPartFactory {
    private final StartCommand startCommand;
    private final IProject project;

    public StartCommandPartFactory(StartCommand startCommand, IProject project) {
        this.startCommand = startCommand;
        this.project = project;
    }

    public StartCommandPart createStartCommandTypePart(StartCommandType type, Composite parent) {
        StartCommandPart commandTypePart = null;
        switch (type) {
            case Java: {
                commandTypePart = this.getJavaStartArea(parent);
                break;
            }
            case Other: {
                commandTypePart = this.getOtherStartArea(parent);
            }
        }
        if (commandTypePart != null) {
            commandTypePart.getComposite();
        }
        return commandTypePart;
    }

    protected StartCommandPart getDefaultStartCommandUIPart(Composite parent) {
        return new StartCommandPart(parent){
            private Text standaloneStartText;

            public Control createPart(Composite parent) {
                Composite composite = new Composite(parent, 0);
                GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).margins(new Point(0, 7)).applyTo(composite);
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
                this.standaloneStartText = StartCommandPartFactory.this.createdEditableText(composite);
                this.standaloneStartText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        this.updateStartCommand();
                    }
                });
                return composite;
            }

            @Override
            public void updateStartCommand() {
                String value = this.standaloneStartText.getText();
                boolean isInvalid = StringUtils.isEmpty((String)value);
                this.notifyStatusChange(StartCommandPartFactory.this.startCommand.toString(), isInvalid ? CloudFoundryPlugin.getErrorStatus((String)"Invalid start command.") : Status.OK_STATUS);
            }
        };
    }

    protected StartCommandPart getOtherStartArea(Composite parent) {
        return this.getDefaultStartCommandUIPart(parent);
    }

    protected Label createdLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)label);
        if (text != null) {
            label.setText(text);
        }
        return label;
    }

    protected Text createdEditableText(Composite parent) {
        Text text = new Text(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)text);
        text.setEditable(true);
        return text;
    }

    protected Composite create2ColumnComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(new Point(0, 0)).spacing(5, 2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        return composite;
    }

    protected StartCommandPart getJavaStartArea(Composite parent) {
        IJavaProject javaProject = this.project != null ? CloudFoundryProjectUtil.getJavaProject((IProject)this.project) : null;
        return new JavaStartCommandPart(javaProject, this, this.startCommand, parent);
    }
}

