/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client.diego;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.BaseClientRequest;
import org.eclipse.cft.server.core.internal.client.BehaviourRequest;
import org.eclipse.cft.server.core.internal.client.ClientRequestFactory;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.diego.CloudInfoSsh;
import org.eclipse.cft.server.core.internal.ssh.SshClientSupport;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class DiegoRequestFactory
extends ClientRequestFactory {
    public DiegoRequestFactory(CloudFoundryServerBehaviour behaviour) {
        super(behaviour);
    }

    @Override
    public BaseClientRequest<CloudApplication> getCloudApplication(final String appName) throws CoreException {
        return new BehaviourRequest<CloudApplication>(NLS.bind((String)Messages.CloudFoundryServerBehaviour_GET_APPLICATION, (Object)appName), this.behaviour){

            @Override
            protected CloudApplication doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                try {
                    return client.getApplication(appName);
                }
                catch (Exception e) {
                    if (CloudErrorUtil.is503Error(e)) {
                        return this.behaviour.getAdditionalV1ClientOperations((IProgressMonitor)progress).getBasicApplication(appName);
                    }
                    throw e;
                }
            }
        };
    }

    @Override
    public BaseClientRequest<List<CloudApplication>> getApplications() throws CoreException {
        String serverId = this.behaviour.getCloudFoundryServer().getServer().getId();
        String label = NLS.bind((String)Messages.CloudFoundryServerBehaviour_GET_ALL_APPS, (Object)serverId);
        return new BehaviourRequest<List<CloudApplication>>(label, this.behaviour){

            @Override
            protected List<CloudApplication> doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                try {
                    return client.getApplications();
                }
                catch (Exception e) {
                    if (CloudErrorUtil.is503Error(e)) {
                        return this.behaviour.getAdditionalV1ClientOperations((IProgressMonitor)progress).getBasicApplications();
                    }
                    throw e;
                }
            }
        };
    }

    @Override
    public BaseClientRequest<?> stopApplication(String message, final CloudFoundryApplicationModule cloudModule) {
        return new BehaviourRequest<Void>(message, this.behaviour){

            @Override
            protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                try {
                    client.stopApplication(cloudModule.getDeployedApplicationName());
                }
                catch (Exception e) {
                    if (CloudErrorUtil.is503Error(e)) {
                        this.behaviour.getAdditionalV1ClientOperations((IProgressMonitor)progress).stopApplication(cloudModule.getDeployedApplicationName());
                    }
                    throw e;
                }
                return null;
            }
        };
    }

    @Override
    public BaseClientRequest<String> getFile(final CloudApplication app, final int instanceIndex, final String path, final boolean isDir) throws CoreException {
        final CloudFoundryServer cloudServer = this.behaviour.getCloudFoundryServer();
        if (!this.supportsSsh()) {
            return super.getFile(app, instanceIndex, path, isDir);
        }
        String label = NLS.bind((String)Messages.CloudFoundryServerBehaviour_FETCHING_FILE, (Object)path, (Object)app.getName());
        return new BehaviourRequest<String>(label, this.behaviour){

            @Override
            protected String doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                if (path == null) {
                    return null;
                }
                SshClientSupport ssh = SshClientSupport.create(client, DiegoRequestFactory.this.getCloudInfo(), cloudServer.getProxyConfiguration(), cloudServer, cloudServer.isSelfSigned());
                Session session = ssh.connect(app, cloudServer, instanceIndex);
                String command = isDir ? "ls -p " + path : "cat " + path;
                try {
                    Channel channel = session.openChannel("exec");
                    ((ChannelExec)channel).setCommand(command);
                    String string = DiegoRequestFactory.this.getContent(channel);
                    return string;
                }
                catch (JSchException e) {
                    throw CloudErrorUtil.toCoreException(e);
                }
                finally {
                    session.disconnect();
                }
            }
        };
    }

    @Override
    public CloudInfoSsh getCloudInfo() throws CoreException {
        if (this.cachedInfo == null) {
            CloudFoundryServer cloudServer = this.behaviour.getCloudFoundryServer();
            this.cachedInfo = new CloudInfoSsh(new CloudCredentials(cloudServer.getUsername(), cloudServer.getPassword()), cloudServer.getUrl(), cloudServer.getProxyConfiguration(), cloudServer.isSelfSigned());
        }
        return (CloudInfoSsh)this.cachedInfo;
    }

    @Override
    public boolean supportsSsh() {
        try {
            CloudInfoSsh infoDiego = this.getCloudInfo();
            return infoDiego != null && infoDiego.getSshClientId() != null && infoDiego.getSshHost() != null && infoDiego.getSshHost().getHost() != null && infoDiego.getSshHost().getFingerPrint() != null;
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
            return false;
        }
    }

    protected String getContent(Channel channel) throws CoreException {
        InputStream in = null;
        OutputStream outStream = null;
        try {
            in = channel.getInputStream();
            channel.connect();
            if (in != null) {
                ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                outStream = new BufferedOutputStream(byteArrayOut);
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                while ((bytesRead = in.read(buffer)) != -1) {
                    outStream.write(buffer, 0, bytesRead);
                }
                outStream.flush();
                byteArrayOut.flush();
                String string = byteArrayOut.toString();
                return string;
            }
        }
        catch (IOException e) {
            throw CloudErrorUtil.toCoreException(e);
        }
        catch (JSchException e) {
            throw CloudErrorUtil.toCoreException(e);
        }
        finally {
            channel.disconnect();
            try {
                if (in != null) {
                    in.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                CloudFoundryPlugin.logError(e);
            }
        }
        return null;
    }
}

