/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.editor;

import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.core.internal.CloudFoundryConstants;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerEvent;
import org.eclipse.cft.server.core.internal.CloudServerListener;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.ui.internal.CFUiUtil;
import org.eclipse.cft.server.ui.internal.CloudFoundryURLNavigation;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.actions.UpdatePasswordOperation;
import org.eclipse.cft.server.ui.internal.wizards.OrgsAndSpacesWizard;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class CloudFoundryAccountSection
extends ServerEditorSection
implements CloudServerListener {
    private CloudFoundryServer cfServer;
    private Text emailText;
    private Text passwordText;
    private String sectionTitle;
    private Text urlText;
    private Text orgText;
    private Text spaceText;
    private Text validateLabel;

    public void update() {
        if (this.cfServer.getUsername() != null && this.emailText != null && !this.cfServer.getUsername().equals(this.emailText.getText())) {
            this.emailText.setText(this.cfServer.getUsername());
        }
        if (this.cfServer.getPassword() != null && this.passwordText != null && !this.cfServer.getPassword().equals(this.passwordText.getText())) {
            this.passwordText.setText(this.cfServer.getPassword());
        }
        if (this.cfServer.getUrl() != null && this.urlText != null && !CFUiUtil.getDisplayTextFromUrl(this.cfServer.getUrl(), this.cfServer.getServer().getServerType().getId()).equals(this.urlText.getText())) {
            this.urlText.setText(CFUiUtil.getDisplayTextFromUrl(this.cfServer.getUrl(), this.cfServer.getServer().getServerType().getId()));
        }
        if (this.cfServer.hasCloudSpace()) {
            if (this.cfServer.getCloudFoundrySpace() != null && this.cfServer.getCloudFoundrySpace().getOrgName() != null && this.orgText != null && !this.cfServer.getCloudFoundrySpace().getOrgName().equals(this.orgText.getText())) {
                this.orgText.setText(this.cfServer.getCloudFoundrySpace().getOrgName());
            }
            if (this.cfServer.getCloudFoundrySpace() != null && this.cfServer.getCloudFoundrySpace().getSpaceName() != null && this.spaceText != null && !this.cfServer.getCloudFoundrySpace().getSpaceName().equals(this.spaceText.getText())) {
                this.spaceText.setText(this.cfServer.getCloudFoundrySpace().getSpaceName());
            }
        }
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 258);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        section.setText(this.sectionTitle);
        Composite composite = toolkit.createComposite((Composite)section);
        section.setClient((Control)composite);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite topComposite = new Composite(composite, 0);
        topComposite.setLayout((Layout)new GridLayout(2, false));
        topComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        if (!this.cfServer.isSso()) {
            Label emailLabel = toolkit.createLabel(topComposite, Messages.CloudFoundryAccountSection_LABEL_EMAIL, 0);
            emailLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            emailLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.emailText = toolkit.createText(topComposite, "");
            this.emailText.setLayoutData((Object)new GridData(4, 4, true, false));
            this.emailText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            if (this.cfServer.getUsername() != null) {
                this.emailText.setText(this.cfServer.getUsername());
            }
            this.emailText.setEditable(false);
            Label passwordLabel = toolkit.createLabel(topComposite, Messages.CloudFoundryAccountSection_LABEL_PASSWORD, 0);
            passwordLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            passwordLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.passwordText = toolkit.createText(topComposite, "", 0x400000);
            this.passwordText.setLayoutData((Object)new GridData(4, 4, true, false));
            this.passwordText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            if (this.cfServer.getPassword() != null) {
                this.passwordText.setText(this.cfServer.getPassword());
            }
            this.passwordText.setEditable(false);
        }
        Label label = toolkit.createLabel(topComposite, Messages.CloudFoundryAccountSection_LABEL_URL);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.urlText = toolkit.createText(topComposite, "", 0);
        this.urlText.setEditable(false);
        this.urlText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.urlText.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        if (this.cfServer.getUrl() != null) {
            this.urlText.setText(CFUiUtil.getDisplayTextFromUrl(this.cfServer.getUrl(), this.cfServer.getServer().getServerType().getId()));
        }
        Label orgLabel = toolkit.createLabel(topComposite, Messages.CloudFoundryAccountSection_LABEL_ORG, 0);
        orgLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        orgLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.orgText = toolkit.createText(topComposite, "", 0);
        this.orgText.setEditable(false);
        this.orgText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.orgText.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        if (this.cfServer.getCloudFoundrySpace() != null && this.cfServer.getCloudFoundrySpace().getOrgName() != null) {
            this.orgText.setText(this.cfServer.getCloudFoundrySpace().getOrgName());
        }
        Label spaceLabel = toolkit.createLabel(topComposite, Messages.CloudFoundryAccountSection_LABEL_SPACE, 0);
        spaceLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        spaceLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.spaceText = toolkit.createText(topComposite, "", 0);
        this.spaceText.setEditable(false);
        this.spaceText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.spaceText.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        if (this.cfServer.getCloudFoundrySpace() != null && this.cfServer.getCloudFoundrySpace().getSpaceName() != null) {
            this.spaceText.setText(this.cfServer.getCloudFoundrySpace().getSpaceName());
        }
        final Composite buttonComposite = toolkit.createComposite(composite);
        buttonComposite.setLayout((Layout)new GridLayout(4, false));
        GridDataFactory.fillDefaults().align(0x1000008, 4).grab(true, false).applyTo((Control)buttonComposite);
        final Composite validateComposite = toolkit.createComposite(composite);
        validateComposite.setLayout((Layout)new GridLayout(1, false));
        validateComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        int borderStyleBackup = toolkit.getBorderStyle();
        try {
            toolkit.setBorderStyle(0);
            this.validateLabel = toolkit.createText(validateComposite, "", 8);
        }
        finally {
            toolkit.setBorderStyle(borderStyleBackup);
        }
        this.validateLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.validateLabel.setVisible(false);
        this.createCloneServerArea(buttonComposite, toolkit);
        Button changePasswordButton = toolkit.createButton(buttonComposite, Messages.CloudFoundryAccountSection_BUTTON_CHANGE_PW, 8);
        changePasswordButton.setEnabled(!this.cfServer.isSso());
        changePasswordButton.setLayoutData((Object)new GridData(4, 4, false, false));
        changePasswordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean confirm;
                if (CloudFoundryAccountSection.this.server.isDirty() && !(confirm = MessageDialog.openQuestion((Shell)CloudFoundryAccountSection.this.getShell(), (String)Messages.CloudFoundryAccountSection_DIALOG_UNSAVE_TITLE, (String)Messages.CloudFoundryAccountSection_DIALOG_UNSAVE_BODY))) {
                    return;
                }
                Job job = new Job(Messages.UpdatePasswordCommand_TEXT_PW_UPDATE){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            new UpdatePasswordOperation(CloudFoundryAccountSection.this.cfServer).run(monitor);
                        }
                        catch (CoreException e) {
                            CloudFoundryPlugin.logError((Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        });
        final Button validateButton = toolkit.createButton(buttonComposite, Messages.CloudFoundryAccountSection_BUTTON_VALIDATE_ACCOUNT, 8);
        validateButton.setLayoutData((Object)new GridData(4, 4, false, false));
        validateButton.setEnabled(!this.cfServer.isSso());
        validateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String url = CloudFoundryAccountSection.this.cfServer.getUrl();
                String userName = CloudFoundryAccountSection.this.emailText.getText();
                String password = CloudFoundryAccountSection.this.passwordText.getText();
                String org = CloudFoundryAccountSection.this.orgText.getText();
                String space = CloudFoundryAccountSection.this.spaceText.getText();
                try {
                    CFUiUtil.validateCredentials(CloudFoundryAccountSection.this.cfServer, userName, password, url, false, CloudFoundryAccountSection.this.cfServer.isSelfSigned(), null);
                    if (org != null && space != null) {
                        CloudFoundryAccountSection.this.validateLabel.setForeground(CloudFoundryAccountSection.this.validateLabel.getDisplay().getSystemColor(9));
                        CloudFoundryAccountSection.this.validateLabel.setText(Messages.VALID_ACCOUNT);
                    } else {
                        String errorMsg = null;
                        if (org == null) {
                            errorMsg = Messages.ERROR_INVALID_ORG;
                        } else if (space == null) {
                            errorMsg = Messages.ERROR_INVALID_SPACE;
                        }
                        if (errorMsg != null) {
                            CloudFoundryAccountSection.this.validateLabel.setForeground(CloudFoundryAccountSection.this.validateLabel.getDisplay().getSystemColor(3));
                            CloudFoundryAccountSection.this.validateLabel.setText(errorMsg);
                        } else {
                            CloudFoundryAccountSection.this.validateLabel.setForeground(CloudFoundryAccountSection.this.validateLabel.getDisplay().getSystemColor(2));
                            CloudFoundryAccountSection.this.validateLabel.setText("");
                        }
                    }
                }
                catch (CoreException e) {
                    CloudFoundryAccountSection.this.validateLabel.setForeground(CloudFoundryAccountSection.this.validateLabel.getDisplay().getSystemColor(3));
                    CloudFoundryAccountSection.this.validateLabel.setText(e.getMessage());
                }
                CloudFoundryAccountSection.this.validateLabel.setVisible(CloudFoundryAccountSection.this.validateLabel.getText().length() > 0);
                buttonComposite.layout(new Control[]{validateButton});
                validateComposite.layout(new Control[]{CloudFoundryAccountSection.this.validateLabel});
            }
        });
        if (CloudFoundryURLNavigation.canEnableCloudFoundryNavigation(this.cfServer)) {
            Button cfSignup = toolkit.createButton(buttonComposite, CloudFoundryConstants.PUBLIC_CF_SERVER_SIGNUP_LABEL, 8);
            cfSignup.setLayoutData((Object)new GridData(4, 4, false, false));
            cfSignup.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String signupURL;
                    IServer iServer = CloudFoundryAccountSection.this.cfServer.getServer();
                    if (iServer != null && (signupURL = CloudFoundryBrandingExtensionPoint.getSignupURL((String)CloudFoundryAccountSection.this.cfServer.getServerId(), (String)CloudFoundryAccountSection.this.cfServer.getUrl())) != null) {
                        CloudFoundryURLNavigation nav = new CloudFoundryURLNavigation(signupURL);
                        nav.navigate();
                    }
                }
            });
        }
        toolkit.paintBordersFor(topComposite);
        section.setExpanded(true);
        ServerEventHandler.getDefault().addServerListener((CloudServerListener)this);
    }

    protected void createCloneServerArea(Composite parent, FormToolkit toolkit) {
        Button changeSpaceButton = toolkit.createButton(parent, Messages.CloudFoundryAccountSection_BUTTON_CLONE_SERVER, 8);
        changeSpaceButton.setEnabled(true);
        changeSpaceButton.setLayoutData((Object)new GridData(4, 4, false, false));
        changeSpaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrgsAndSpacesWizard wizard = new OrgsAndSpacesWizard(CloudFoundryAccountSection.this.cfServer);
                WizardDialog dialog = new WizardDialog(CloudFoundryAccountSection.this.getShell(), (IWizard)wizard);
                dialog.open();
            }
        });
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (this.server != null) {
            this.cfServer = (CloudFoundryServer)this.server.loadAdapter(CloudFoundryServer.class, null);
            this.update();
        }
        this.sectionTitle = Messages.COMMONTXT_ACCOUNT_INFO;
    }

    public void serverChanged(CloudServerEvent event) {
        if (event.getType() == 300 && event.getServer() != null && this.cfServer != null && this.cfServer.getServerId().equals(event.getServer().getServerId())) {
            final CloudServerEvent serverEvent = event;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String errorMessage;
                    CloudFoundryServer eventServer = serverEvent.getServer();
                    if (CloudFoundryAccountSection.this.passwordText == null || CloudFoundryAccountSection.this.passwordText.isDisposed() || CloudFoundryAccountSection.this.validateLabel == null || CloudFoundryAccountSection.this.validateLabel.isDisposed()) {
                        return;
                    }
                    String password = eventServer.getPassword();
                    if (password != null && !CloudFoundryAccountSection.this.passwordText.getText().equals(password)) {
                        CloudFoundryAccountSection.this.passwordText.setText(password);
                    }
                    String string = errorMessage = serverEvent.getStatus() != null && serverEvent.getStatus().getSeverity() == 4 ? serverEvent.getStatus().getMessage() : null;
                    if (errorMessage != null) {
                        CloudFoundryAccountSection.this.validateLabel.setForeground(CloudFoundryAccountSection.this.validateLabel.getDisplay().getSystemColor(3));
                        CloudFoundryAccountSection.this.validateLabel.setText(errorMessage);
                    } else {
                        CloudFoundryAccountSection.this.validateLabel.setForeground(CloudFoundryAccountSection.this.validateLabel.getDisplay().getSystemColor(9));
                        CloudFoundryAccountSection.this.validateLabel.setText(Messages.CloudFoundryAccountSection_LABEL_PW_CHANGED);
                    }
                    CloudFoundryAccountSection.this.validateLabel.getParent().layout(new Control[]{CloudFoundryAccountSection.this.validateLabel});
                }
            });
        }
    }

    public void dispose() {
        ServerEventHandler.getDefault().removeServerListener((CloudServerListener)this);
    }

    protected class DataChangeListener
    implements ModifyListener {
        private final DataType type;

        private DataChangeListener(DataType type) {
            this.type = type;
        }

        protected void update(String value) {
            switch (this.type) {
                case EMAIL: {
                    this.updateTextField(value, CloudFoundryAccountSection.this.emailText);
                    break;
                }
                case PASSWORD: {
                    this.updateTextField(value, CloudFoundryAccountSection.this.passwordText);
                }
            }
        }

        private void updateTextField(String input, Text text) {
            if (text != null && !text.isDisposed() && !text.getText().equals(input)) {
                text.setText(input == null ? "" : input);
            }
        }

        public void modifyText(ModifyEvent e) {
        }
    }

    private static enum DataType {
        EMAIL,
        PASSWORD;

    }
}

