/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class DeleteServicesWizardPage
extends WizardPage {
    private final List<String> services;
    private CheckboxTableViewer viewer;
    private Object[] checkedElements;

    public DeleteServicesWizardPage(CloudFoundryServer cloudServer, List<String> services) {
        super(Messages.DeleteServicesWizardPage_TEXT_SERVICE);
        this.services = services;
        this.setTitle(Messages.DeleteServicesWizardPage_TITLE_DELETE_SERVICE);
        this.setDescription(Messages.DeleteServicesWizardPage_TEXT_SELECT_SERVICE);
        ImageDescriptor banner = CloudFoundryImages.getWizardBanner(cloudServer.getServer().getServerType().getId());
        if (banner != null) {
            this.setImageDescriptor(banner);
        }
    }

    public boolean isPageComplete() {
        return true;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Table table = new Table(container, 2080);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                DeleteServicesWizardPage.this.checkedElements = DeleteServicesWizardPage.this.viewer.getCheckedElements();
                DeleteServicesWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        LabelProvider labelProvider = new LabelProvider();
        ITreeContentProvider contentProvider = new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return DeleteServicesWizardPage.this.services.toArray();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }
        };
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setInput(this.services);
        this.setControl((Control)container);
        this.getWizard().getContainer().updateButtons();
    }

    public List<String> getSelectedServices() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.checkedElements != null) {
            Object[] objectArray = this.checkedElements;
            int n = this.checkedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object checkedElement = objectArray[n2];
                result.add((String)checkedElement);
                ++n2;
            }
        }
        return result;
    }
}

