/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.common.java;

import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.common.helper.JavaHelper;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.pattern.engine.AssemblyContentProvider;
import org.eclipse.egf.pattern.engine.AssemblyHelper;

public abstract class BaseJavaAssemblyHelper
extends AssemblyHelper {
    public BaseJavaAssemblyHelper(Pattern pattern, AssemblyContentProvider contentProvider) {
        super(pattern, contentProvider);
    }

    @Override
    protected void addHeader() throws PatternException {
        String read = this.contentHelper.getMethodContent(this.pattern.getHeaderMethod());
        if (read != null) {
            read = read.replaceAll("CLASS", BaseJavaAssemblyHelper.getClassName(this.pattern));
            read = read.replaceAll("PACKAGE", BaseJavaAssemblyHelper.getPackageName(this.pattern.getContainer()));
            this.content.append(read).append(EGFCommonConstants.LINE_SEPARATOR);
        }
    }

    public static String getFullClassName(Pattern pattern) {
        if (pattern == null) {
            return null;
        }
        return String.valueOf(BaseJavaAssemblyHelper.getPackageName(pattern.getContainer())) + "." + BaseJavaAssemblyHelper.getClassName(pattern);
    }

    public static String getClassName(Pattern pattern) {
        if (pattern == null) {
            return null;
        }
        return BaseJavaAssemblyHelper.getClassName(pattern.getName());
    }

    public static String getClassName(String name) {
        return JavaHelper.dropNonWordCharacter((String)name);
    }

    public static String getPackageName(PatternLibrary library) {
        if (library == null) {
            return null;
        }
        return BaseJavaAssemblyHelper.getPackageName(library.getName());
    }

    public static String getPackageName(String name) {
        return JavaHelper.dropNonWordCharacterExcept((String)name, (String)".");
    }
}

