/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.conditions.eobjects;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.query.conditions.Condition;
import org.eclipse.emf.query.handlers.PruneHandler;

public abstract class EObjectCondition
extends Condition {
    public static final EObjectCondition E_TRUE = new EObjectCondition(){

        public boolean isSatisfied(EObject object) {
            return true;
        }
    };
    public static final EObjectCondition E_FALSE = new EObjectCondition(PruneHandler.ALWAYS){

        public boolean isSatisfied(EObject object) {
            return false;
        }
    };
    private PruneHandler pruneHandler;

    public EObjectCondition() {
        this(PruneHandler.NEVER);
    }

    public EObjectCondition(PruneHandler pruneHandler) {
        this.pruneHandler = pruneHandler;
    }

    public final PruneHandler getPruneHandler() {
        return this.pruneHandler;
    }

    public boolean shouldPrune(EObject eObject) {
        return this.pruneHandler.shouldPrune(eObject);
    }

    public boolean isSatisfied(Object object) {
        if (object instanceof EObject) {
            return this.isSatisfied((EObject)object);
        }
        return false;
    }

    public abstract boolean isSatisfied(EObject var1);

    public EObjectCondition AND(EObjectCondition condition) {
        return new And(condition);
    }

    public EObjectCondition OR(EObjectCondition condition) {
        return new Or(condition);
    }

    public EObjectCondition XOR(EObjectCondition condition) {
        return new XOr(condition);
    }

    public EObjectCondition IMPLIES(EObjectCondition condition) {
        return new Implies(condition);
    }

    public EObjectCondition EQUIVALENT(EObjectCondition condition) {
        return new Equivalent(condition);
    }

    private class And
    extends CompoundEObjectCondition {
        And(EObjectCondition condition) {
            super(condition);
        }

        public boolean isSatisfied(EObject eObject) {
            return EObjectCondition.this.isSatisfied(eObject) && this.condition.isSatisfied(eObject);
        }

        public boolean shouldPrune(EObject eObject) {
            return EObjectCondition.this.shouldPrune(eObject) || this.condition.shouldPrune(eObject);
        }
    }

    private static abstract class CompoundEObjectCondition
    extends EObjectCondition {
        EObjectCondition condition;

        CompoundEObjectCondition(EObjectCondition condition) {
            this.condition = condition;
        }
    }

    private class Equivalent
    extends CompoundEObjectCondition {
        Equivalent(EObjectCondition condition) {
            super(condition);
        }

        public boolean isSatisfied(EObject eObject) {
            return EObjectCondition.this.isSatisfied(eObject) == this.condition.isSatisfied(eObject);
        }

        public boolean shouldPrune(EObject eObject) {
            return false;
        }
    }

    private class Implies
    extends CompoundEObjectCondition {
        Implies(EObjectCondition condition) {
            super(condition);
        }

        public boolean isSatisfied(EObject eObject) {
            return !EObjectCondition.this.isSatisfied(eObject) || this.condition.isSatisfied(eObject);
        }

        public boolean shouldPrune(EObject eObject) {
            return false;
        }
    }

    private class Or
    extends CompoundEObjectCondition {
        Or(EObjectCondition condition) {
            super(condition);
        }

        public boolean isSatisfied(EObject eObject) {
            return EObjectCondition.this.isSatisfied(eObject) || this.condition.isSatisfied(eObject);
        }

        public boolean shouldPrune(EObject eObject) {
            return EObjectCondition.this.shouldPrune(eObject) && this.condition.shouldPrune(eObject);
        }
    }

    private class XOr
    extends CompoundEObjectCondition {
        XOr(EObjectCondition condition) {
            super(condition);
        }

        public boolean isSatisfied(EObject eObject) {
            return EObjectCondition.this.isSatisfied(eObject) ^ this.condition.isSatisfied(eObject);
        }

        public boolean shouldPrune(EObject eObject) {
            return EObjectCondition.this.shouldPrune(eObject) && this.condition.shouldPrune(eObject);
        }
    }
}

