/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.registry;

import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.context.ActivityProductionContextProducer;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.osgi.util.NLS;

public class ActivityProductionContextProducerProxy {
    private IConfigurationElement _element;
    private String _uniqueIdentifier;
    private int _handleId = -1;
    private String _activity;
    private String _class;
    private Object _executable;

    public static ActivityProductionContextProducerProxy createProxy(IConfigurationElement element) {
        String activity;
        if (element == null || !element.isValid()) {
            return null;
        }
        IExtension declaringExtension = element.getDeclaringExtension();
        String uniqueIdentifier = declaringExtension.getUniqueIdentifier();
        int handleId = -1;
        if (declaringExtension instanceof Handle) {
            handleId = ((Handle)declaringExtension).getId();
        }
        if ((activity = element.getAttribute("activity")) == null || activity.trim().length() == 0) {
            return null;
        }
        String clazz = element.getAttribute("class");
        if (clazz == null || clazz.trim().length() == 0) {
            return null;
        }
        return new ActivityProductionContextProducerProxy(element, activity, clazz, uniqueIdentifier, handleId);
    }

    public ActivityProductionContextProducerProxy(IConfigurationElement element, String activity, String clazz, String uniqueIdentifier, int handleId) {
        this._element = element;
        this._activity = activity.trim();
        this._class = clazz.trim();
        if (uniqueIdentifier != null && uniqueIdentifier.trim().length() != 0) {
            this._uniqueIdentifier = uniqueIdentifier.trim();
        }
        this._handleId = handleId;
    }

    public String getUniqueIdentifier() {
        return this._uniqueIdentifier;
    }

    public int getHandleId() {
        return this._handleId;
    }

    public <P extends Activity> ActivityProductionContextProducer<P> getActivityProductionContextProducer(P activity) throws CoreException {
        if (this._executable == null && this._element.isValid()) {
            Object object = this._element.createExecutableExtension("class");
            if (object == null) {
                return null;
            }
            if (!(object instanceof ActivityProductionContextProducer)) {
                EGFProducerPlugin.getDefault().logError(NLS.bind((String)EGFCommonMessages.Wrong_Class_Message, (Object)object.getClass().getName()));
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Wrong_Class_Sub_Type_Message, (Object)ActivityProductionContextProducer.class.getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Bundle_Message, (Object)this._element.getContributor().getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Extension_Point_Message, (Object)this._element.getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Attribute_Message, (Object)this._class), 1);
                return null;
            }
            if (((ActivityProductionContextProducer)object).getActivity() == null) {
                EGFProducerPlugin.getDefault().logError(NLS.bind((String)EGFCommonMessages.Wrong_Class_Message, (Object)object.getClass().getName()));
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Missing_Element_Message, (Object)Activity.class.getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Bundle_Message, (Object)this._element.getContributor().getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Extension_Point_Message, (Object)this._element.getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Attribute_Message, (Object)this._class), 1);
                return null;
            }
            if (((ActivityProductionContextProducer)object).getActivity() != EMFHelper.solveAgainstStaticPackage((EClassifier)activity.eClass())) {
                EGFProducerPlugin.getDefault().logError(NLS.bind((String)EGFCommonMessages.Wrong_Class_Message, (Object)object.getClass().getName()));
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Type_mismatch_Message, (Object)activity.getClass().getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Bundle_Message, (Object)this._element.getContributor().getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Extension_Point_Message, (Object)this._element.getName()), 1);
                EGFProducerPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Attribute_Message, (Object)this._class), 1);
                return null;
            }
            this._executable = object;
        }
        return (ActivityProductionContextProducer)this._executable;
    }

    public String getActivity() {
        return this._activity;
    }

    public boolean originatesFrom(IExtension extension) {
        String id = extension.getUniqueIdentifier();
        if (id != null) {
            return id.equals(this._uniqueIdentifier);
        }
        if (!(extension instanceof Handle)) {
            return false;
        }
        return this._handleId == ((Handle)extension).getId();
    }
}

