/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.importer.extension;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.vp.requirements.importer.extension.AttributeSet;
import org.polarsys.capella.vp.requirements.importer.preferences.RequirementsPreferencesPlugin;

public class ReqImporterPreferencesUtil {
    public static String getPreferenceKey(AttributeSet attribute) {
        AttributeSet category = attribute.getParent();
        Assert.isNotNull((Object)category);
        String key = String.valueOf(category.getName()) + "." + attribute.getName();
        return key;
    }

    public static String serializePropertyFilesPreference(Collection<URI> propertyFilesURIs) {
        StringBuilder value = new StringBuilder();
        for (URI uri : propertyFilesURIs) {
            value.append(String.valueOf(uri.toString()) + ";");
        }
        return value.toString();
    }

    public static List<URI> deserializePropertyFilesPreference(String propertyFilesString) {
        if (propertyFilesString == null || propertyFilesString.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        String[] stringArray = propertyFilesString.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (value != null && !value.isEmpty()) {
                uris.add(URI.createURI((String)value));
            }
            ++n2;
        }
        return uris;
    }

    public static List<AttributeSet> loadPropertiesFileAttributes(List<URI> propertiesFiles) {
        ArrayList<AttributeSet> result = new ArrayList<AttributeSet>();
        IPreferenceStore store = RequirementsPreferencesPlugin.getDefault().getPreferenceStore();
        for (URI propertiesFile : propertiesFiles) {
            String absoluteFilePath = null;
            if (propertiesFile.isPlatformResource()) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile workspaceFile = root.getFile((IPath)new Path(propertiesFile.toPlatformString(true)));
                IPath workspaceFilePath = workspaceFile.getLocation();
                if (workspaceFilePath != null) {
                    absoluteFilePath = workspaceFilePath.toString();
                }
            } else if (propertiesFile.isFile()) {
                absoluteFilePath = propertiesFile.toFileString();
            }
            if (absoluteFilePath != null) {
                File file = new File(absoluteFilePath);
                if (file.exists()) {
                    try {
                        FileInputStream stream = new FileInputStream(file);
                        Properties properties = new Properties();
                        properties.load(stream);
                        String fileName = file.getName();
                        AttributeSet attrSet = new AttributeSet(fileName);
                        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                            String key = (String)entry.getKey();
                            String value = (String)entry.getValue();
                            AttributeSet childAttr = new AttributeSet(key);
                            attrSet.addChild(childAttr);
                            Boolean defaultValue = Boolean.valueOf(value);
                            childAttr.setDefaultValue(defaultValue);
                            String akey = ReqImporterPreferencesUtil.getPreferenceKey(childAttr);
                            boolean selected = store.contains(akey) ? store.getBoolean(akey) : defaultValue.booleanValue();
                            childAttr.setSelected(selected);
                        }
                        result.add(attrSet);
                        stream.close();
                    }
                    catch (FileNotFoundException ex) {
                        System.err.println(ex.getMessage());
                    }
                    catch (IOException ex) {
                        System.err.println(ex.getMessage());
                    }
                    continue;
                }
                System.out.println("Invalid file path: " + absoluteFilePath);
                continue;
            }
            System.out.println("Invalid file path");
        }
        return result;
    }

    public static List<URI> getPropertyFilesFromPreferences() {
        IPreferenceStore store = RequirementsPreferencesPlugin.getDefault().getPreferenceStore();
        String values = store.getString("requirement.properties.files");
        return ReqImporterPreferencesUtil.deserializePropertyFilesPreference(values);
    }

    public static List<AttributeSet> loadContributedCategories() {
        IConfigurationElement[] attributesProvider;
        ArrayList<AttributeSet> contributedAttributes = new ArrayList<AttributeSet>();
        IPreferenceStore store = RequirementsPreferencesPlugin.getDefault().getPreferenceStore();
        IConfigurationElement[] iConfigurationElementArray = attributesProvider = ExtensionPointHelper.getConfigurationElements((String)"org.polarsys.capella.vp.requirements.importer.extension", (String)"attributesProvider");
        int n = attributesProvider.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement provider = iConfigurationElementArray[n2];
            AttributeSet attributeSet = new AttributeSet(provider.getAttribute("category"));
            attributeSet.setDescription(provider.getAttribute("description"));
            attributeSet.setMandatory(Boolean.valueOf(provider.getAttribute("mandatory")));
            IConfigurationElement[] iConfigurationElementArray2 = provider.getChildren("attribute");
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement attribute = iConfigurationElementArray2[n4];
                String name = attribute.getAttribute("name");
                AttributeSet attributeSetChild = new AttributeSet(name);
                attributeSet.addChild(attributeSetChild);
                boolean defaultValue = Boolean.valueOf(attribute.getAttribute("defaultValue"));
                attributeSetChild.setDefaultValue(defaultValue);
                String akey = ReqImporterPreferencesUtil.getPreferenceKey(attributeSetChild);
                boolean selected = store.contains(akey) ? store.getBoolean(akey) : defaultValue;
                attributeSetChild.setSelected(selected);
                attributeSetChild.setMandatory(attributeSet.isMandatory());
                ++n4;
            }
            contributedAttributes.add(attributeSet);
            ++n2;
        }
        return contributedAttributes;
    }
}

