/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.polarsys.capella.common.mdsofa.common.helper.FileHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.test.migration.ju.helpers.MigrationHelper;

public class TraceMigrationTestCase
extends BasicTestCase {
    private static final String TEST_MODEL = "migration-model";
    private static final String LEGACY_TRACE_FILE = "migration-model.melodymodeller.bridgetraces";
    private static final String MIGRATED_TRACE_FILE = "migration-model.capella.bridgetraces";

    public void test() throws Exception {
        IProject project = IResourceHelpers.getEclipseProjectInWorkspace((String)TEST_MODEL);
        IFile legacyTraceFile = project.getFile(LEGACY_TRACE_FILE);
        String legacyTracePath = legacyTraceFile.getFullPath().toOSString();
        String legacyTraceContent = FileHelper.readFile((String)legacyTracePath);
        MigrationHelper.migrateProject((IProject)project);
        IFile migratedTraceFile = project.getFile(MIGRATED_TRACE_FILE);
        String migratedTracePath = migratedTraceFile.getFullPath().toOSString();
        String migratedTraceContent = FileHelper.readFile((String)migratedTracePath);
        TraceMigrationTestCase.assertEquals((String)legacyTraceContent, (String)migratedTraceContent);
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList(TEST_MODEL);
    }
}

