/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.importer.transposer.bridge;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeExecution;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IMappingBridge;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IMappingExecution;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQueryHolder;
import org.eclipse.emf.diffmerge.bridge.mapping.impl.MappingExecution;
import org.eclipse.emf.diffmerge.bridge.mapping.impl.emf.EMFMappingBridge;
import org.eclipse.emf.diffmerge.bridge.mapping.operations.MappingBridgeOperation;
import org.eclipse.emf.diffmerge.bridge.util.structures.ITuple;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionBoolean;
import org.eclipse.rmf.reqif10.AttributeDefinitionDate;
import org.eclipse.rmf.reqif10.AttributeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.AttributeDefinitionInteger;
import org.eclipse.rmf.reqif10.AttributeDefinitionReal;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeDefinitionXHTML;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueBoolean;
import org.eclipse.rmf.reqif10.AttributeValueDate;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.AttributeValueInteger;
import org.eclipse.rmf.reqif10.AttributeValueReal;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.DatatypeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.common.util.ReqIF10XhtmlUtil;
import org.polarsys.capella.vp.requirements.importer.extension.AttributesProvider;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.ReqIFTextParser;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.ReqIfMappingBridgeOperation;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.RequirementEMFSYmbolFunction;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.RequirementsVPBridge;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.TupleNP;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.query.FolderQuery;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.query.ModuleQuery;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.query.RelationQuery;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.query.RequirementQuery;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.query.TypeDefinitionQuery;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.query.TypeQuery;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.rules.FolderRule;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.rules.ModuleRule;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.rules.RelationRule;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.rules.RequirementRule;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.rules.TypeDefinitionRule;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.rules.TypeRule;
import org.polarsys.capella.vp.requirements.model.helpers.TypeHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.vp.requirements.Requirements.Attribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.AttributeOwner;
import org.polarsys.kitalpha.vp.requirements.Requirements.BooleanValueAttribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.DataTypeDefinition;
import org.polarsys.kitalpha.vp.requirements.Requirements.DateValueAttribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.EnumerationValueAttribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.IntegerValueAttribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.RealValueAttribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.RequirementsFactory;
import org.polarsys.kitalpha.vp.requirements.Requirements.RequirementsPackage;
import org.polarsys.kitalpha.vp.requirements.Requirements.StringValueAttribute;
import org.polarsys.kitalpha.vp.requirements.model.helpers.LabelHelper;

public class ReqIFMapping
extends EMFMappingBridge<IEditableModelScope, IEditableModelScope> {
    IContext context;
    Collection<String> reqTypes;
    ReqIFTextParser textParser;

    public ReqIFMapping(IContext context) {
        this.context = context;
        this.textParser = new ReqIFTextParser(context);
        ModuleQuery modules = new ModuleQuery((IQueryHolder<? extends IEditableModelScope>)this);
        FolderQuery folders = new FolderQuery((IQueryHolder<? extends IEditableModelScope>)this);
        RequirementQuery requirements = new RequirementQuery((IQueryHolder<? extends IEditableModelScope>)this);
        RelationQuery relations = new RelationQuery((IQueryHolder<? extends IEditableModelScope>)this);
        TypeQuery types = new TypeQuery((IQueryHolder<? extends IEditableModelScope>)this);
        TypeDefinitionQuery typeDefinitions = new TypeDefinitionQuery((IQueryHolder<? extends IEditableModelScope>)this);
        new ModuleRule(this, modules);
        new FolderRule(this, folders);
        new RequirementRule(this, requirements);
        new RelationRule(this, relations);
        new TypeRule(this, types);
        new TypeDefinitionRule(this, typeDefinitions);
        this.reqTypes = AttributesProvider.getInstance().getSelectedAttributeTypes();
    }

    public IContext getContext() {
        return this.context;
    }

    public void setTextParser(ReqIFTextParser textParser) {
        this.textParser = textParser;
    }

    protected MappingBridgeOperation createMappingOperation(IEditableModelScope sourceDataSet, IEditableModelScope targetDataSet, MappingExecution execution) {
        ReqIfMappingBridgeOperation operation = new ReqIfMappingBridgeOperation(sourceDataSet, targetDataSet, (IMappingBridge<?, ?>)this, (IBridgeExecution)execution);
        return operation;
    }

    public void synchronizeAttributeDefinitions(IMappingExecution ruleEnv, SpecType spectype) {
        for (AttributeDefinition attribute : spectype.getSpecAttributes()) {
            Object tuple;
            Object def;
            Object attr;
            DatatypeDefinitionEnumeration datatype = null;
            AttributeDefinitionEnumeration valueDef = null;
            try {
                AttributeValueEnumeration defaultValue;
                if (attribute instanceof AttributeDefinitionEnumeration) {
                    datatype = ((AttributeDefinitionEnumeration)attribute).getType();
                    defaultValue = ((AttributeDefinitionEnumeration)attribute).getDefaultValue();
                    if (defaultValue != null) {
                        valueDef = defaultValue.getDefinition();
                    }
                } else if (attribute instanceof AttributeDefinitionBoolean) {
                    datatype = ((AttributeDefinitionBoolean)attribute).getType();
                    defaultValue = ((AttributeDefinitionBoolean)attribute).getDefaultValue();
                    if (defaultValue != null) {
                        valueDef = defaultValue.getDefinition();
                    }
                } else if (attribute instanceof AttributeDefinitionDate) {
                    datatype = ((AttributeDefinitionDate)attribute).getType();
                    defaultValue = ((AttributeDefinitionDate)attribute).getDefaultValue();
                    if (defaultValue != null) {
                        valueDef = defaultValue.getDefinition();
                    }
                } else if (attribute instanceof AttributeDefinitionInteger) {
                    datatype = ((AttributeDefinitionInteger)attribute).getType();
                    defaultValue = ((AttributeDefinitionInteger)attribute).getDefaultValue();
                    if (defaultValue != null) {
                        valueDef = defaultValue.getDefinition();
                    }
                } else if (attribute instanceof AttributeDefinitionReal) {
                    datatype = ((AttributeDefinitionReal)attribute).getType();
                    defaultValue = ((AttributeDefinitionReal)attribute).getDefaultValue();
                    if (defaultValue != null) {
                        valueDef = defaultValue.getDefinition();
                    }
                } else if (attribute instanceof AttributeDefinitionString) {
                    datatype = ((AttributeDefinitionString)attribute).getType();
                    defaultValue = ((AttributeDefinitionString)attribute).getDefaultValue();
                    if (defaultValue != null) {
                        valueDef = defaultValue.getDefinition();
                    }
                } else if (attribute instanceof AttributeDefinitionXHTML) {
                    datatype = ((AttributeDefinitionXHTML)attribute).getType();
                    defaultValue = ((AttributeDefinitionXHTML)attribute).getDefaultValue();
                    if (defaultValue != null) {
                        valueDef = defaultValue.getDefinition();
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Can't read type of attribute: " + attribute.getLongName());
            }
            if ((attr = ruleEnv.getOne((Object)attribute.eContainer(), ITuple.class)) instanceof TupleNP) {
                attr = ((TupleNP)((Object)attr)).get(attribute.getIdentifier());
            }
            if ((def = ruleEnv.getOne((Object)datatype, ITuple.class)) instanceof TupleNP) {
                def = ((TupleNP)((Object)def)).get(datatype.getIdentifier());
            }
            if (attr instanceof org.polarsys.kitalpha.vp.requirements.Requirements.AttributeDefinition && def instanceof DataTypeDefinition) {
                ((org.polarsys.kitalpha.vp.requirements.Requirements.AttributeDefinition)attr).setDefinitionType((DataTypeDefinition)def);
            }
            if (valueDef == null) continue;
            Object searchedDefinition = null;
            Object specTypeTuple = ruleEnv.getOne((Object)valueDef.eContainer(), ITuple.class);
            if (specTypeTuple instanceof TupleNP) {
                searchedDefinition = ((TupleNP)((Object)specTypeTuple)).get(valueDef.getIdentifier());
            }
            if (attr instanceof org.polarsys.kitalpha.vp.requirements.Requirements.AttributeDefinition && searchedDefinition instanceof org.polarsys.kitalpha.vp.requirements.Requirements.AttributeDefinition) {
                ((org.polarsys.kitalpha.vp.requirements.Requirements.AttributeDefinition)attr).getDefaultValue().setDefinition((org.polarsys.kitalpha.vp.requirements.Requirements.AttributeDefinition)searchedDefinition);
            }
            if (!(attribute instanceof AttributeDefinitionEnumeration) || !((tuple = ruleEnv.getOne((Object)((AttributeDefinitionEnumeration)attribute).getType(), ITuple.class)) instanceof TupleNP)) continue;
            AttributeValueEnumeration defaultValue = ((AttributeDefinitionEnumeration)attribute).getDefaultValue();
            EList values = defaultValue.getValues();
            for (EnumValue value : values) {
                Object x = ((TupleNP)((Object)tuple)).get(value.getIdentifier());
                if (!(x instanceof org.polarsys.kitalpha.vp.requirements.Requirements.EnumValue)) continue;
                ((EnumerationValueAttribute)((org.polarsys.kitalpha.vp.requirements.Requirements.AttributeDefinition)attr).getDefaultValue()).getValues().add((Object)((org.polarsys.kitalpha.vp.requirements.Requirements.EnumValue)x));
            }
        }
    }

    public void synchronizeAttributes(IMappingExecution ruleEnv, SpecHierarchy hierarchy, SpecElementWithAttributes element) {
        for (AttributeValue attribute : element.getValues()) {
            Object def;
            Object attr;
            AttributeDefinition definition = this.getReqIFDefinition(attribute);
            ArrayList<EnumValue> enumValueList = new ArrayList<EnumValue>();
            if (attribute instanceof AttributeValueEnumeration) {
                for (EnumValue enumValue : ((AttributeValueEnumeration)attribute).getValues()) {
                    enumValueList.add(enumValue);
                }
            }
            if ((attr = ruleEnv.getOne(hierarchy != null ? hierarchy : element, ITuple.class)) instanceof TupleNP) {
                attr = ((TupleNP)((Object)attr)).get(RequirementEMFSYmbolFunction.getInstance().getEObjectSymbol((EObject)attribute));
            }
            if ((def = ruleEnv.getOne((Object)definition.eContainer(), ITuple.class)) instanceof TupleNP) {
                def = ((TupleNP)((Object)def)).get(definition.getIdentifier());
            }
            if (attr instanceof Attribute && def instanceof org.polarsys.kitalpha.vp.requirements.Requirements.AttributeDefinition) {
                ((Attribute)attr).setDefinition((org.polarsys.kitalpha.vp.requirements.Requirements.AttributeDefinition)def);
                ((Attribute)attr).setDefinitionProxy(((org.polarsys.kitalpha.vp.requirements.Requirements.AttributeDefinition)def).getReqIFIdentifier());
            }
            if (!(attr instanceof EnumerationValueAttribute)) continue;
            for (EnumValue enumValue : enumValueList) {
                Object value = ruleEnv.getOne((Object)enumValue.eContainer(), ITuple.class);
                if (value instanceof TupleNP) {
                    value = ((TupleNP)((Object)value)).get(enumValue.getIdentifier());
                }
                if (!(value instanceof org.polarsys.kitalpha.vp.requirements.Requirements.EnumValue)) continue;
                ((EnumerationValueAttribute)attr).getValues().add((Object)((org.polarsys.kitalpha.vp.requirements.Requirements.EnumValue)value));
            }
        }
    }

    private EClass getAttributeType(AttributeValue value) {
        if (value instanceof AttributeValueXHTML) {
            return RequirementsPackage.Literals.STRING_VALUE_ATTRIBUTE;
        }
        if (value instanceof AttributeValueString) {
            return RequirementsPackage.Literals.STRING_VALUE_ATTRIBUTE;
        }
        if (value instanceof AttributeValueInteger) {
            return RequirementsPackage.Literals.INTEGER_VALUE_ATTRIBUTE;
        }
        if (value instanceof AttributeValueBoolean) {
            return RequirementsPackage.Literals.BOOLEAN_VALUE_ATTRIBUTE;
        }
        if (value instanceof AttributeValueDate) {
            return RequirementsPackage.Literals.DATE_VALUE_ATTRIBUTE;
        }
        if (value instanceof AttributeValueReal) {
            return RequirementsPackage.Literals.REAL_VALUE_ATTRIBUTE;
        }
        if (value instanceof AttributeValueEnumeration) {
            return RequirementsPackage.Literals.ENUMERATION_VALUE_ATTRIBUTE;
        }
        return null;
    }

    public void setAttribute(EObject target, EStructuralFeature feature, Object value) {
        if (value != null) {
            EClassifier type = feature.getEType();
            try {
                if (type == EcorePackage.Literals.EBIG_INTEGER && !(value instanceof BigInteger)) {
                    value = value instanceof Integer ? BigInteger.valueOf(((Integer)value).longValue()) : new BigInteger(value.toString());
                } else if (type == EcorePackage.Literals.EBOOLEAN && !(value instanceof Boolean)) {
                    value = Boolean.valueOf(value.toString());
                } else if (type == EcorePackage.Literals.EINT && !(value instanceof Integer)) {
                    value = Integer.valueOf(value.toString());
                } else if (type == EcorePackage.Literals.EDOUBLE && !(value instanceof Double)) {
                    value = Double.valueOf(value.toString());
                } else if (type == EcorePackage.Literals.ESTRING && !(value instanceof String)) {
                    value = value.toString();
                }
            }
            catch (NumberFormatException e) {
                System.out.println("Can't import value: " + value);
            }
        }
        target.eSet(feature, value);
    }

    public Attribute createAttributeValue(AttributeOwner container, EClass attributeType, Object value) {
        Attribute attribute = (Attribute)RequirementsFactory.eINSTANCE.create(attributeType);
        container.getOwnedAttributes().add((Object)attribute);
        if (attribute instanceof BooleanValueAttribute) {
            this.setAttribute((EObject)attribute, (EStructuralFeature)RequirementsPackage.Literals.BOOLEAN_VALUE_ATTRIBUTE__VALUE, value);
        } else if (attribute instanceof DateValueAttribute) {
            this.setAttribute((EObject)attribute, (EStructuralFeature)RequirementsPackage.Literals.DATE_VALUE_ATTRIBUTE__VALUE, value);
        } else if (!(attribute instanceof EnumerationValueAttribute)) {
            if (attribute instanceof IntegerValueAttribute) {
                this.setAttribute((EObject)attribute, (EStructuralFeature)RequirementsPackage.Literals.INTEGER_VALUE_ATTRIBUTE__VALUE, value);
            } else if (attribute instanceof RealValueAttribute) {
                this.setAttribute((EObject)attribute, (EStructuralFeature)RequirementsPackage.Literals.REAL_VALUE_ATTRIBUTE__VALUE, value);
            } else if (attribute instanceof StringValueAttribute) {
                this.setAttribute((EObject)attribute, (EStructuralFeature)RequirementsPackage.Literals.STRING_VALUE_ATTRIBUTE__VALUE, value);
            }
        }
        return attribute;
    }

    protected AttributeDefinition getReqIFDefinition(AttributeValue value) {
        if (value instanceof AttributeValueXHTML) {
            return ((AttributeValueXHTML)value).getDefinition();
        }
        if (value instanceof AttributeValueString) {
            return ((AttributeValueString)value).getDefinition();
        }
        if (value instanceof AttributeValueInteger) {
            return ((AttributeValueInteger)value).getDefinition();
        }
        if (value instanceof AttributeValueBoolean) {
            return ((AttributeValueBoolean)value).getDefinition();
        }
        if (value instanceof AttributeValueDate) {
            return ((AttributeValueDate)value).getDefinition();
        }
        if (value instanceof AttributeValueReal) {
            return ((AttributeValueReal)value).getDefinition();
        }
        if (value instanceof AttributeValueEnumeration) {
            return ((AttributeValueEnumeration)value).getDefinition();
        }
        return null;
    }

    private Object getAttributeValue(AttributeValue value, AttributeOwner owner) {
        if (value instanceof AttributeValueXHTML) {
            return this.getContent((AttributeValueXHTML)value, owner);
        }
        if (value instanceof AttributeValueInteger) {
            return ((AttributeValueInteger)value).getTheValue();
        }
        if (value instanceof AttributeValueString) {
            return ((AttributeValueString)value).getTheValue();
        }
        if (value instanceof AttributeValueBoolean) {
            return ((AttributeValueBoolean)value).isTheValue();
        }
        if (value instanceof AttributeValueDate) {
            AttributeValueDate attribute = (AttributeValueDate)value;
            if (attribute.getTheValue() != null) {
                return ((AttributeValueDate)value).getTheValue().getTime();
            }
        } else {
            if (value instanceof AttributeValueReal) {
                return ((AttributeValueReal)value).getTheValue();
            }
            if (value instanceof AttributeValueEnumeration) {
                return ((AttributeValueEnumeration)value).getValues();
            }
        }
        return null;
    }

    public Map<String, Object> parseStandardReqIFAttributes(AttributeValue value, AttributeOwner target) {
        HashMap<String, Object> createdObjects = new HashMap<String, Object>();
        AttributeDefinition definition = this.getReqIFDefinition(value);
        if (definition != null) {
            String type = definition.getLongName();
            if (!this.reqTypes.contains(type)) {
                System.out.println("[" + value.eClass().getName() + "] Not imported: " + type);
            } else {
                EStructuralFeature feature = TypeHelper.getDirectFeature((String)type, (AttributeOwner)target);
                Object attributeValue = this.getAttributeValue(value, target);
                if (feature != null) {
                    this.setAttribute((EObject)target, feature, attributeValue);
                } else {
                    Attribute result = this.createAttributeValue(target, this.getAttributeType(value), attributeValue);
                    if (result != null) {
                        createdObjects.put(RequirementEMFSYmbolFunction.getInstance().getEObjectSymbol((EObject)value), result);
                    }
                }
            }
        }
        return createdObjects;
    }

    protected String getContent(AttributeValueXHTML value, AttributeOwner owner) {
        String content = "";
        try {
            content = ReqIF10XhtmlUtil.getXhtmlString((XhtmlContent)value.getTheValue());
            content = value.getDefinition().getLongName().equals("ReqIF.Text") ? this.textParser.transformToHTML(content, owner) : this.transformToText(content);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return content;
    }

    protected String transformToText(String content) {
        return LabelHelper.transformHTMLToText((String)content);
    }

    public IEditableModelScope getTemporaryScope() {
        return RequirementsVPBridge.temporaryScope;
    }
}

