/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.vp.requirements.Requirements.provider;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.CompoundInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.vp.requirements.importer.preferences.RequirementsPreferencesPlugin;
import org.polarsys.kitalpha.vp.requirements.Requirements.Requirement;
import org.polarsys.kitalpha.vp.requirements.model.edit.decorators.ItemProviderAdapterDecorator;
import org.polarsys.kitalpha.vp.requirements.model.helpers.LabelHelper;

public class RequirementItemProviderDecorator
extends ItemProviderAdapterDecorator
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public RequirementItemProviderDecorator(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected Session getRelatedSession(EObject element) {
        Session session = SessionManager.INSTANCE.getSession(element);
        if (session == null) {
            TransactionalEditingDomain domain = TransactionHelper.getEditingDomain((EObject)element);
            for (Session activeSession : SessionManager.INSTANCE.getSessions()) {
                if (!activeSession.getTransactionalEditingDomain().equals(domain)) continue;
                return activeSession;
            }
        }
        return session;
    }

    public String getText(Object object) {
        Requirement requirement = (Requirement)object;
        try {
            Session session = this.getRelatedSession((EObject)requirement);
            Object interpreter = null;
            interpreter = session != null ? session.getInterpreter() : CompoundInterpreter.INSTANCE;
            if (interpreter != null) {
                String expression = RequirementsPreferencesPlugin.getDefault().getPreferenceStore().getString("requirement.label.expression");
                Object value = interpreter.evaluate((EObject)requirement, expression);
                String result = "";
                if (value instanceof List) {
                    for (Object item : (List)value) {
                        result = String.valueOf(result) + item;
                    }
                } else {
                    result = String.valueOf(result) + value;
                }
                result = LabelHelper.unescape((String)LabelHelper.transformHTMLToText((String)result));
                return this.reduceReqNameLen(result, RequirementsPreferencesPlugin.getDefault().getPreferenceStore().getString("requirement.label.max.len"));
            }
        }
        catch (EvaluationException ex) {
            return "[Error in label expression] " + super.getText(object);
        }
        return super.getText(object);
    }

    protected String reduceReqNameLen(String reqName, String strMaxLen) {
        if (strMaxLen.length() == 0) {
            return reqName;
        }
        int maxLen = Integer.parseInt(strMaxLen);
        if (reqName.length() > maxLen) {
            return reqName.substring(0, maxLen).concat("...");
        }
        return reqName;
    }
}

