/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.xhtml.XhtmlDivType;
import org.eclipse.rmf.reqif10.xhtml.XhtmlFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReqIF10XHtmlContentAdapter
extends EContentAdapter {
    String xmlString = null;
    XMLResource resource = null;
    static final String UTF8 = "UTF-8";
    XhtmlContent xhtmlContent = null;

    public String getXhtmlString() {
        if (this.xmlString == null) {
            this.updateXhtmlString();
        }
        return this.xmlString;
    }

    public void setXhtmlString(String xhtmlString) throws IOException {
        this.updateXhtmlObjects(xhtmlString);
    }

    public void setXhtmlPlainTextString(String plainText) {
        XhtmlDivType xhtmlDivType = XhtmlFactory.eINSTANCE.createXhtmlDivType();
        xhtmlDivType.getMixed().add((Object)FeatureMapUtil.createTextEntry((String)plainText));
        this.xhtmlContent.setXhtml((EObject)xhtmlDivType);
    }

    public EList<Resource.Diagnostic> getErrors() {
        return this.resource.getErrors();
    }

    public EList<Resource.Diagnostic> getWarnings() {
        return this.resource.getWarnings();
    }

    public boolean isAdapterForType(Object type) {
        return ReqIF10XHtmlContentAdapter.class == type;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object notifier = notification.getNotifier();
        if (notifier instanceof XhtmlContent) {
            this.updateXhtmlString();
        }
    }

    private void updateXhtmlString() {
        block4: {
            assert (this.xhtmlContent != null);
            EObject xmlRoot = this.xhtmlContent.getXhtml();
            if (xmlRoot != null) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    XMLResource resource = this.getResource();
                    HashMap<String, List<EObject>> options = new HashMap<String, List<EObject>>();
                    options.put("ROOT_OBJECTS", Collections.singletonList(xmlRoot));
                    resource.save((OutputStream)byteArrayOutputStream, options);
                    this.xmlString = new String(byteArrayOutputStream.toByteArray(), UTF8);
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)"We should always be able to update the xhtml string from the given object model");
                }
            }
        }
    }

    private void updateXhtmlObjects(String xmlString) throws IOException {
        assert (this.xhtmlContent != null);
        if (xmlString == null) {
            this.xhtmlContent.unsetXhtml();
        } else {
            XMLResource resource = this.getResource();
            resource.load((InputStream)new ByteArrayInputStream(xmlString.getBytes(UTF8)), null);
            EList contents = resource.getContents();
            if (contents.size() > 0) {
                EObject rootObject = (EObject)contents.get(0);
                this.xhtmlContent.setXhtml(rootObject);
            }
        }
    }

    private XMLResource getResource() {
        if (this.resource == null) {
            this.resource = new NestedXMLResourceImpl();
        } else {
            this.resource.getContents().clear();
        }
        return this.resource;
    }

    public void setTarget(Notifier target) {
        super.setTarget(target);
        if (target instanceof XhtmlContent) {
            this.xhtmlContent = (XhtmlContent)target;
        }
    }

    private class NestedXMLResourceImpl
    extends XMLResourceImpl {
        private NestedXMLResourceImpl() {
        }

        protected XMLHelper createXMLHelper() {
            XMLHelper helper = super.createXMLHelper();
            EMap prefixToNamespaceMap = helper.getPrefixToNamespaceMap();
            prefixToNamespaceMap.put((Object)"", (Object)"http://www.w3.org/1999/xhtml");
            helper.setPrefixToNamespaceMap(prefixToNamespaceMap);
            helper.pushContext();
            helper.addPrefix("", "http://www.w3.org/1999/xhtml");
            return helper;
        }

        protected XMLSave createXMLSave() {
            return new XMLSaveImpl(this.createXMLHelper()){

                protected Object writeTopObject(EObject top) {
                    EClass eClass = top.eClass();
                    String name = this.helper.getQName(eClass);
                    this.doc.startElement(name);
                    Object mark = this.doc.mark();
                    this.root = top;
                    this.saveElementID(top);
                    return mark;
                }
            };
        }

        protected void init() {
            super.init();
            this.setEncoding(ReqIF10XHtmlContentAdapter.UTF8);
            Map loadOptions = this.getDefaultLoadOptions();
            loadOptions.put("EXTENDED_META_DATA", Boolean.TRUE);
            loadOptions.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
            loadOptions.put("SUPPRESS_DOCUMENT_ROOT", Boolean.TRUE);
            loadOptions.put("DEFER_ATTACHMENT", Boolean.TRUE);
            HashMap<String, Integer> parserProperties = new HashMap<String, Integer>();
            parserProperties.put("http://apache.org/xml/properties/input-buffer-size", 1024);
            HashMap<String, Boolean> parserFeatures = new HashMap<String, Boolean>();
            parserFeatures.put("http://xml.org/sax/features/namespaces", true);
            parserFeatures.put("http://xml.org/sax/features/namespace-prefixes", false);
            loadOptions.put("PARSER_FEATURES", parserFeatures);
            loadOptions.put("PARSER_PROPERTIES", parserProperties);
            Map saveOptions = this.getDefaultSaveOptions();
            saveOptions.put("EXTENDED_META_DATA", Boolean.TRUE);
            saveOptions.put("DECLARE_XML", Boolean.FALSE);
            saveOptions.put("SAVE_TYPE_INFORMATION", Boolean.FALSE);
            saveOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
            saveOptions.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
        }
    }
}

