/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ui.properties.widgets;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.navigator.CommonNavigator;
import org.polarsys.capella.common.ui.toolkit.browser.view.ISemanticBrowserViewPart;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.CapellaNavigatorLabelProvider;

public class TableviewUIExtender {
    public TableviewUIExtender(Menu menu, Table table) {
        this.createNavigationItems(menu, table);
    }

    public StructuredSelection getSelectedFromSelection(TableItem[] inSelection) {
        if (inSelection != null && inSelection.length > 0) {
            return new StructuredSelection(inSelection[0].getData());
        }
        return null;
    }

    private void createNavigationItems(Menu menu, Table table) {
        this.createShowInExplorerItem(menu, table);
        this.createShowInSemanticBrowserItem(menu, table);
        this.createDisplayInStatusBar(table);
    }

    private void createDisplayInStatusBar(final Table table) {
        table.addListener(7, new Listener(){

            public void handleEvent(Event e) {
                TableviewUIExtender.this.displayInStatusBar(null);
            }
        });
        table.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                StructuredSelection structuredSelection = TableviewUIExtender.this.getSelectedFromSelection(table.getSelection());
                if (structuredSelection != null) {
                    TableviewUIExtender.this.displayInStatusBar(structuredSelection);
                }
            }
        });
        table.addListener(6, new Listener(){

            public void handleEvent(Event e) {
                StructuredSelection structuredSelection = TableviewUIExtender.this.getSelectedFromSelection(table.getSelection());
                if (structuredSelection != null) {
                    TableviewUIExtender.this.displayInStatusBar(structuredSelection);
                }
            }
        });
    }

    protected void displayInStatusBar(StructuredSelection structuredSelection) {
        IStatusLineManager currentStatusLineManager;
        Image elementImage = null;
        String elementDescription = null;
        if (structuredSelection != null) {
            CapellaNavigatorLabelProvider capellaNavigatorLabelProvider = new CapellaNavigatorLabelProvider();
            elementImage = capellaNavigatorLabelProvider.getImage(structuredSelection.getFirstElement());
            elementDescription = capellaNavigatorLabelProvider.getDescription(structuredSelection.getFirstElement());
        }
        if ((currentStatusLineManager = this.getCurrentStatusLineManager()) != null) {
            currentStatusLineManager.setMessage(elementImage, elementDescription);
        }
    }

    private IStatusLineManager getCurrentStatusLineManager() {
        IWorkbenchPartSite currentSite = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
        if (currentSite instanceof IViewSite) {
            return ((IViewSite)currentSite).getActionBars().getStatusLineManager();
        }
        if (currentSite instanceof PartSite) {
            return ((PartSite)currentSite).getActionBars().getStatusLineManager();
        }
        if (currentSite instanceof IEditorSite) {
            return ((IEditorSite)currentSite).getActionBars().getStatusLineManager();
        }
        return null;
    }

    protected void createShowInExplorerItem(Menu menu, final Table table) {
        final MenuItem showInExp = new MenuItem(menu, 0);
        showInExp.setText("Select in Capella Explorer");
        showInExp.setAccelerator(0x1000011);
        CommonNavigator exp = this.getCapellaAdvanceExplorer(false);
        if (exp != null) {
            showInExp.setImage(exp.getTitleImage());
        }
        showInExp.setEnabled(true);
        table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selection = table.getSelection();
                if (selection != null && event.button == 3) {
                    boolean enable;
                    boolean bl = enable = selection.length == 1;
                    if (enable) {
                        TableItem first = selection[0];
                        enable = first instanceof TableItem;
                    }
                    showInExp.setEnabled(enable);
                }
            }
        });
        table.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                CommonNavigator innerExp;
                StructuredSelection structuredSelection = TableviewUIExtender.this.getSelectedFromSelection(table.getSelection());
                if (structuredSelection != null && event.keyCode == 0x1000011 && (innerExp = TableviewUIExtender.this.getCapellaAdvanceExplorer(true)) != null) {
                    innerExp.selectReveal((ISelection)structuredSelection);
                }
            }
        });
        showInExp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonNavigator innerExp;
                StructuredSelection structuredSelection = TableviewUIExtender.this.getSelectedFromSelection(table.getSelection());
                if (structuredSelection != null && (innerExp = TableviewUIExtender.this.getCapellaAdvanceExplorer(true)) != null) {
                    if (showInExp.getImage() == null) {
                        showInExp.setImage(innerExp.getTitleImage());
                    }
                    innerExp.selectReveal((ISelection)structuredSelection);
                }
            }
        });
    }

    protected void createShowInSemanticBrowserItem(Menu menu, final Table table) {
        final MenuItem showInSB = new MenuItem(menu, 0);
        showInSB.setText("Show in Semantic Browser");
        showInSB.setAccelerator(0x1000012);
        ISemanticBrowserViewPart sb = this.getSemanticBrowser(false);
        if (sb != null) {
            showInSB.setImage(sb.getTitleImage());
        }
        showInSB.setEnabled(true);
        table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selection = table.getSelection();
                if (selection != null && event.button == 3) {
                    boolean enable;
                    boolean bl = enable = selection.length == 1;
                    if (enable) {
                        TableItem first = selection[0];
                        enable = first instanceof TableItem;
                    }
                    showInSB.setEnabled(enable);
                }
            }
        });
        table.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                ISemanticBrowserViewPart innerSb;
                StructuredSelection structuredSelection = TableviewUIExtender.this.getSelectedFromSelection(table.getSelection());
                if (structuredSelection != null && event.keyCode == 0x1000012 && (innerSb = TableviewUIExtender.this.getSemanticBrowser(true)) != null) {
                    innerSb.setInput(structuredSelection.getFirstElement());
                }
            }
        });
        showInSB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISemanticBrowserViewPart innerSb;
                StructuredSelection structuredSelection = TableviewUIExtender.this.getSelectedFromSelection(table.getSelection());
                if (structuredSelection != null && (innerSb = TableviewUIExtender.this.getSemanticBrowser(true)) != null) {
                    if (showInSB.getImage() == null) {
                        showInSB.setImage(innerSb.getTitleImage());
                    }
                    innerSb.setInput(structuredSelection.getFirstElement());
                }
            }
        });
    }

    protected CommonNavigator getCapellaAdvanceExplorer(boolean forceShow) {
        CommonNavigator result = null;
        String viewID = "capella.project.explorer";
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart view = null;
        if (forceShow) {
            try {
                view = page.showView("capella.project.explorer");
            }
            catch (PartInitException partInitException) {}
        } else {
            view = page.findView("capella.project.explorer");
        }
        if (view instanceof CommonNavigator) {
            result = (CommonNavigator)view;
        }
        return result;
    }

    protected ISemanticBrowserViewPart getSemanticBrowser(boolean forceShow) {
        ISemanticBrowserViewPart result = null;
        String viewID = "org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID";
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart view = null;
        if (forceShow) {
            try {
                view = page.showView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
            }
            catch (PartInitException partInitException) {}
        } else {
            view = page.findView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
        }
        if (view instanceof ISemanticBrowserViewPart) {
            result = (ISemanticBrowserViewPart)view;
        }
        return result;
    }
}

