/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.reqif.resource.obfuscator;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.vp.requirements.reqif.resource.obfuscator.ResourceObfuscatorCommand;
import org.polarsys.capella.vp.requirements.reqif.resource.obfuscator.ResourceObfuscatorPlugin;

public class ResourceObfuscatorHelper {
    public static void obfuscateResource(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        ExecutionManager manager = ExecutionManagerRegistry.getInstance().addNewManager();
        TransactionalEditingDomain editingDomain = manager.getEditingDomain();
        ResourceSet resourceSet = editingDomain.getResourceSet();
        Resource resource = resourceSet.getResource(uri, true);
        manager.execute((ICommand)new ResourceObfuscatorCommand(resource));
        try {
            resource.save(new HashMap());
        }
        catch (IOException exception) {
            ResourceObfuscatorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.vp.requirements.reqif.resource.obfuscator", "Failed saving resource", (Throwable)exception));
        }
        editingDomain.dispose();
        ExecutionManagerRegistry.getInstance().removeManager(manager);
    }
}

