/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tests.ju.tests.misc;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.model.helpers.query.IGetElementsQueries;
import org.polarsys.capella.filtering.AbstractFilteringResult;
import org.polarsys.capella.filtering.ComposedFilteringResult;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.FilteringResult;
import org.polarsys.capella.filtering.sirius.analysis.FilteringServices;
import org.polarsys.capella.filtering.tests.ju.tests.helpers.FilteringTestHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class FilteringServicesTest
extends BasicTestCase {
    private static final String TEST_MODEL_NAME = "FilteringServicesTestModel";
    ComposedFilteringResult CR1;
    ComposedFilteringResult CR2;
    ComposedFilteringResult CR3;
    FilteringResult R1;
    FilteringResult R2;
    FilteringResult R3;
    FilteringCriterion C1;
    FilteringCriterion C2;
    FilteringCriterion C3;
    FilteringCriterion C4;
    String R1_ID = "7078ce5b-6723-4665-b850-f1152c25b3bf";
    String R2_ID = "76c02a79-954d-4cda-9f5e-a9a7d596a80e";
    String R3_ID = "a1e2cafb-b078-4cd2-ad84-6907b71e61d2";
    String CR1_ID = "f40c8fe4-4beb-47dd-ad5d-db7feb5be73c";
    String CR2_ID = "7a5a9b26-02e8-43b0-b102-999e5dcbe979";
    String CR3_ID = "756dc973-bda9-4b08-b680-cfc5bb2900c8";
    String C1_ID = "0d1837f3-b2d5-44a0-8d05-d42ea5d32985";
    String C2_ID = "25183b5b-cb29-4390-9afe-cb4c5d817bb8";
    String C3_ID = "a1bf6566-679f-4509-b1c8-5b69dd81c362";
    String C4_ID = "f1a55c38-86fb-44f1-aa02-9d2969e0ade4";
    PhysicalComponent RootPC;
    PhysicalComponent PC1;
    PhysicalComponent PC2;
    PhysicalComponent PC3;
    PhysicalComponent PC4;
    PhysicalComponent PC5;
    PhysicalComponent PC6;
    PhysicalComponent PC7;
    PhysicalComponent PC8;
    Part PP1;
    Part PP2;
    Part PP3;
    Part PP4;
    Part PP5;
    Part PP6;
    Part PP7;
    Part PP8;
    String PC1_ID = "f11409e9-68c4-4582-92dd-24511197423d";
    String PC2_ID = "69f433ec-a55a-41c1-8750-6a6356b5c7e8";
    String PC3_ID = "670ea8fb-d2bd-4bef-9f65-be9008a72b64";
    String PC4_ID = "0a16683f-6c78-4855-b1a1-5004b9a9ee5a";
    String PC5_ID = "6189b624-e696-4814-a71e-2583ae5be17c";
    String PC6_ID = "c5301c76-2d9d-4f9c-8977-10e27c5f2990";
    String PC7_ID = "70bea46f-8bdb-464f-8195-1df33416ac46";
    String PC8_ID = "a0404933-ad52-4597-b091-2caffd7f55f4";
    String PP1_ID = "4b7e5b1f-b752-48f6-8c9b-1d9b6ae4698a";
    String PP2_ID = "6e491bcd-61fb-42e6-a15c-2fee8b37cd40";
    String PP3_ID = "c513b32d-b54c-4152-a95a-659ab549c32b";
    String PP4_ID = "f998d42d-913c-4a04-bfce-e11e2729be05";
    String PP5_ID = "026c106f-4443-4cce-8224-cfa66123e3e5";
    String PP6_ID = "60335861-2b9e-47fe-8e68-ef8abc02fd8e";
    String PP7_ID = "9a237b56-74a5-4194-aa41-98f1a4efd5aa";
    String PP8_ID = "f1ff18f0-3b9f-4378-9b93-ac57666b3d1b";
    Set<LogicalComponent> ALL_PCs;

    protected void setUp() throws Exception {
        super.setUp();
        Session session = this.getSessionForTestModel(TEST_MODEL_NAME);
        session.open((IProgressMonitor)new NullProgressMonitor());
        Project capellaProject = FilteringTestHelper.getCapellaProject(session.getSemanticResources());
        IGetElementsQueries getElementsQueries = CapellaQueries.getInstance().getGetElementsQueries();
        this.R1 = (FilteringResult)getElementsQueries.getElementById(capellaProject, this.R1_ID);
        this.R2 = (FilteringResult)getElementsQueries.getElementById(capellaProject, this.R2_ID);
        this.R3 = (FilteringResult)getElementsQueries.getElementById(capellaProject, this.R3_ID);
        this.CR1 = (ComposedFilteringResult)getElementsQueries.getElementById(capellaProject, this.CR1_ID);
        this.CR2 = (ComposedFilteringResult)getElementsQueries.getElementById(capellaProject, this.CR2_ID);
        this.CR3 = (ComposedFilteringResult)getElementsQueries.getElementById(capellaProject, this.CR3_ID);
        this.C1 = (FilteringCriterion)getElementsQueries.getElementById(capellaProject, this.C1_ID);
        this.C2 = (FilteringCriterion)getElementsQueries.getElementById(capellaProject, this.C2_ID);
        this.C3 = (FilteringCriterion)getElementsQueries.getElementById(capellaProject, this.C3_ID);
        this.C4 = (FilteringCriterion)getElementsQueries.getElementById(capellaProject, this.C4_ID);
        this.PC1 = (PhysicalComponent)getElementsQueries.getElementById(capellaProject, this.PC1_ID);
        this.PC2 = (PhysicalComponent)getElementsQueries.getElementById(capellaProject, this.PC2_ID);
        this.PC3 = (PhysicalComponent)getElementsQueries.getElementById(capellaProject, this.PC3_ID);
        this.PC4 = (PhysicalComponent)getElementsQueries.getElementById(capellaProject, this.PC4_ID);
        this.PC5 = (PhysicalComponent)getElementsQueries.getElementById(capellaProject, this.PC5_ID);
        this.PC6 = (PhysicalComponent)getElementsQueries.getElementById(capellaProject, this.PC6_ID);
        this.PC7 = (PhysicalComponent)getElementsQueries.getElementById(capellaProject, this.PC7_ID);
        this.PC8 = (PhysicalComponent)getElementsQueries.getElementById(capellaProject, this.PC8_ID);
        this.PP1 = (Part)getElementsQueries.getElementById(capellaProject, this.PP1_ID);
        this.PP2 = (Part)getElementsQueries.getElementById(capellaProject, this.PP2_ID);
        this.PP3 = (Part)getElementsQueries.getElementById(capellaProject, this.PP3_ID);
        this.PP4 = (Part)getElementsQueries.getElementById(capellaProject, this.PP4_ID);
        this.PP5 = (Part)getElementsQueries.getElementById(capellaProject, this.PP5_ID);
        this.PP6 = (Part)getElementsQueries.getElementById(capellaProject, this.PP6_ID);
        this.PP7 = (Part)getElementsQueries.getElementById(capellaProject, this.PP7_ID);
        this.PP8 = (Part)getElementsQueries.getElementById(capellaProject, this.PP8_ID);
    }

    public void test() throws Exception {
        FilteringServices service = FilteringServices.getService();
        this.testGetAssociatedElements(service);
        this.testGetAssociatedCriteria(service);
        this.testGetAssociatedResults(service);
        this.testGetAssociatedElementsForFilteringResult(service);
    }

    private void testGetAssociatedElements(FilteringServices service) {
        FilteringServicesTest.assertEquals((int)8, (int)service.getAssociatedElements(this.C1).size());
        FilteringServicesTest.assertEquals((int)4, (int)service.getAssociatedElements(this.C2).size());
        FilteringServicesTest.assertEquals((int)6, (int)service.getAssociatedElements(this.C3).size());
        FilteringServicesTest.assertEquals((int)4, (int)service.getAssociatedElements(this.C4).size());
    }

    private void testGetAssociatedCriteria(FilteringServices service) {
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(Arrays.asList(this.C1), service.getAssociatedCriteria((EObject)this.PC1)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(Arrays.asList(this.C2, this.C1), service.getAssociatedCriteria((EObject)this.PC2)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(Arrays.asList(this.C3), service.getAssociatedCriteria((EObject)this.PC3)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(Arrays.asList(this.C4), service.getAssociatedCriteria((EObject)this.PC4)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(Arrays.asList(this.C1), service.getAssociatedCriteria((EObject)this.PC5)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(Arrays.asList(this.C2), service.getAssociatedCriteria((EObject)this.PC6)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(Arrays.asList(this.C3), service.getAssociatedCriteria((EObject)this.PC7)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(Arrays.asList(this.C1, this.C3, this.C4), service.getAssociatedCriteria((EObject)this.PC8)));
    }

    private void testGetAssociatedResults(FilteringServices service) {
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(service.getAssociatedResults((ExtensibleElement)this.PC1), Arrays.asList(this.R1, this.CR1, this.CR2)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(service.getAssociatedResults((ExtensibleElement)this.PC2), Arrays.asList(this.R1, this.R2, this.CR1, this.CR2, this.CR3)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(service.getAssociatedResults((ExtensibleElement)this.PC3), Arrays.asList(this.R2, this.R3, this.CR1)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(service.getAssociatedResults((ExtensibleElement)this.PC4), Arrays.asList(this.R3)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(service.getAssociatedResults((ExtensibleElement)this.PC5), Arrays.asList(this.R1, this.CR1, this.CR2)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(service.getAssociatedResults((ExtensibleElement)this.PC6), Arrays.asList(this.R1, this.R2, this.CR1, this.CR2, this.CR3)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(service.getAssociatedResults((ExtensibleElement)this.PC7), Arrays.asList(this.R2, this.R3, this.CR1)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(service.getAssociatedResults((ExtensibleElement)this.PC8), Arrays.asList(this.R1, this.R2, this.R3, this.CR1, this.CR3)));
    }

    private void testGetAssociatedElementsForFilteringResult(FilteringServices service) {
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(service.getAssociatedElements((AbstractFilteringResult)this.R1), Arrays.asList(this.PC1, this.PP1, this.PC2, this.PP2, this.PC5, this.PP5, this.PC6, this.PP6, this.PC8, this.PP8)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(service.getAssociatedElements((AbstractFilteringResult)this.R2), Arrays.asList(this.PC2, this.PP2, this.PC3, this.PP3, this.PC6, this.PP6, this.PC7, this.PP7, this.PC8, this.PP8)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(service.getAssociatedElements((AbstractFilteringResult)this.R3), Arrays.asList(this.PC3, this.PP3, this.PC4, this.PP4, this.PC7, this.PP7, this.PC8, this.PP8)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(service.getAssociatedElements((AbstractFilteringResult)this.CR1), Arrays.asList(this.PC1, this.PP1, this.PC2, this.PP2, this.PC3, this.PP3, this.PC5, this.PP5, this.PC6, this.PP6, this.PC7, this.PP7, this.PC8, this.PP8)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(service.getAssociatedElements((AbstractFilteringResult)this.CR2), Arrays.asList(this.PC1, this.PP1, this.PC2, this.PP2, this.PC5, this.PP5, this.PC6, this.PP6)));
        FilteringServicesTest.assertTrue((boolean)FilteringTestHelper.areEqualIgnoreOrder(service.getAssociatedElements((AbstractFilteringResult)this.CR3), Arrays.asList(this.PC2, this.PP2, this.PC6, this.PP6, this.PC8, this.PP8)));
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList(TEST_MODEL_NAME);
    }
}

