/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.validation.constraints;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.capella.filtering.validation.constraints.ConstraintsUtil;

public class MDCHK_D_Component_DeploymentLinks
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof DeploymentTarget) {
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            DeploymentTarget location = (DeploymentTarget)eObj;
            for (AbstractDeploymentLink dLink : location.getDeploymentLinks()) {
                List targetFeatures = FilteringUtils.getAssociatedCriteria((EObject)location);
                DeployableElement deployedElement = dLink.getDeployedElement();
                List deployedElementFeatures = FilteringUtils.getAssociatedCriteria((EObject)deployedElement);
                List<FilteringCriterion> missingFeatures = ConstraintsUtil.missingFilteringCriteria(deployedElementFeatures, targetFeatures);
                if (missingFeatures.isEmpty()) continue;
                statuses.add(ctx.createFailureStatus(new Object[]{ConstraintsUtil.getNameForMessage((EObject)location), FilteringUtils.getCommaSeparatedFilteringCriteriaList(missingFeatures), ConstraintsUtil.getNameForMessage((EObject)deployedElement)}));
            }
            if (!statuses.isEmpty()) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
            }
        }
        return ctx.createSuccessStatus();
    }
}

