/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.sirius.ui.dialogs;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.filtering.FilteringModel;
import org.polarsys.capella.filtering.sirius.ui.FilteringSiriusUtils;
import org.polarsys.capella.filtering.tools.dialogs.FilteringCriteriaSelectionDialog;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.capella.filtering.tools.utils.ui.CriteriaContentProvider;

public class SiriusCriteriaSelectionDialog
extends FilteringCriteriaSelectionDialog {
    EObject baseEObject;

    public SiriusCriteriaSelectionDialog(Shell parent, ILabelProvider labelProvider, CriteriaContentProvider contentProvider, Project project, EObject digaram) {
        super(parent, labelProvider, contentProvider, project);
        this.baseEObject = digaram;
    }

    public void setInitialSelections(Object[] selectedElements) {
        this.setInitialElementSelections(Arrays.asList(selectedElements));
    }

    public void setInitialElementSelections(List selectedElements) {
        DDiagram diagram = (DDiagram)this.baseEObject;
        List<FilteringModel> filteringModels = FilteringSiriusUtils.getFilteringModels(diagram, true);
        HashSet filteredSelection = Sets.newHashSet();
        if (!filteringModels.isEmpty() && FilteringUtils.hasFilteringFeatures(filteringModels)) {
            for (Object o : diagram.getDiagramElements()) {
                DDiagramElement diagramElement;
                if (!(o instanceof DDiagramElement) || !(diagramElement = (DDiagramElement)o).isVisible()) continue;
                for (EObject semanticElement : FilteringSiriusUtils.getRealSemanticElements(diagramElement)) {
                    List associatedCriteria = FilteringUtils.getExplicitAssociatedCriteria((EObject)semanticElement);
                    filteredSelection.addAll(associatedCriteria);
                }
            }
        }
        super.setInitialElementSelections(new ArrayList(filteredSelection));
    }
}

