/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.cdatetime;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class Resources {
    private static Listener disposeListener = new Listener(){

        public void handleEvent(Event event) {
            ArrayList<String> invalids = new ArrayList<String>();
            for (Map.Entry entry : images.entrySet()) {
                Image img = (Image)entry.getValue();
                if (event.display != img.getDevice()) continue;
                invalids.add((String)entry.getKey());
                if (img.isDisposed()) continue;
                img.dispose();
            }
            for (String key : invalids) {
                images.remove(key);
            }
        }
    };
    public static final String ICON_CALENDAR = "calendar.png";
    public static final String ICON_CLOCK = "clock.png";
    public static final String ICON_BULLET = "bullet.png";
    public static final String ICON_CALENDAR_CLOCK = "dateclock.png";
    private static final String BUNDLE_NAME = String.valueOf(Resources.class.getPackage().getName()) + ".messages";
    private static ResourceBundle defaultBundle;
    private static final Map<Locale, ResourceBundle> bundles;
    private static final Map<String, Image> images;

    static {
        bundles = new HashMap<Locale, ResourceBundle>();
        images = new HashMap<String, Image>();
    }

    Resources() {
    }

    private static String getDefaultString(String key) {
        if (defaultBundle == null) {
            defaultBundle = ResourceBundle.getBundle(BUNDLE_NAME);
        }
        try {
            return defaultBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static Image getIconBullet() {
        return Resources.getImage(ICON_BULLET);
    }

    public static Image getIconCalendar() {
        return Resources.getImage(ICON_CALENDAR);
    }

    public static Image getIconClock() {
        return Resources.getImage(ICON_CLOCK);
    }

    private static Image getImage(String name) {
        Image img = images.get(name);
        if (img == null || img.isDisposed()) {
            Display display = Display.getDefault();
            display.addListener(12, disposeListener);
            InputStream inputStream = Resources.class.getResourceAsStream(name);
            img = new Image((Device)display, inputStream);
            images.put(name, img);
        }
        return img;
    }

    public static String getString(String key) {
        return Resources.getString(key, Locale.getDefault());
    }

    public static String getString(String key, Locale locale) {
        ResourceBundle bundle = bundles.get(locale);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
            bundles.put(locale, bundle);
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return Resources.getDefaultString(key);
        }
    }

    public static Image getIconCalendarClock() {
        return Resources.getImage(ICON_CALENDAR_CLOCK);
    }
}

