/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.common.ui.wizards;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.common.ui.wizards.LCDecompositionController;
import org.polarsys.capella.core.common.ui.wizards.LCDecompositionValidateWizardPage;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionGeneralViewer;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModel;

public class LCDecompositionWizardPage
extends WizardPage {
    private DecompositionModel decompositionModel;
    private DecompositionGeneralViewer decompositionGeneralViewer;
    private LCDecompositionController controller;

    public LCDecompositionWizardPage(DecompositionModel decompositionModel) {
        this("Capella Logical Component Decomposition");
        this.decompositionModel = decompositionModel;
    }

    public LCDecompositionWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setMessage("This editor displays the Capella Logical Component Decomposition");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.decompositionGeneralViewer = new DecompositionGeneralViewer(parent, this.decompositionModel, true, this.getSynchronizationModeSelected(this.decompositionModel), false);
        this.decompositionGeneralViewer.setSourceTreeContentProvider(false);
        this.decompositionGeneralViewer.addTreeTipListeners();
        this.decompositionGeneralViewer.setDialogPage((DialogPage)this);
        this.setControl((Control)this.decompositionGeneralViewer.getControl());
    }

    public IWizardPage getNextPage() {
        LCDecompositionValidateWizardPage page = (LCDecompositionValidateWizardPage)super.getNextPage();
        this.decompositionModel.refreshStatusForSynthesisCheck();
        page.getDecompositionGeneralViewer().refreshItems(null);
        page.getDecompositionGeneralViewer().addTreeSelectionListener();
        return page;
    }

    public boolean canFlipToNextPage() {
        boolean flag = this.controller.canFlipToNextPage();
        return flag;
    }

    public LCDecompositionController getController() {
        return this.controller;
    }

    public void setController(LCDecompositionController controller) {
        this.controller = controller;
    }

    public DecompositionModel getDecompositionModel() {
        return this.decompositionModel;
    }

    public void setDecompositionModel(DecompositionModel decompositionModel) {
        this.decompositionModel = decompositionModel;
    }

    private boolean getSynchronizationModeSelected(DecompositionModel decompositionModel) {
        Object value;
        DecompositionComponent component;
        boolean result = true;
        if (decompositionModel != null && (component = decompositionModel.getSourceComponent()) != null && (value = component.getValue()) != null && value instanceof ModelElement) {
            ModelElement sourceElement = (ModelElement)value;
            result = CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isSingletonComponentsDriven((EObject)sourceElement));
        }
        return result;
    }
}

