/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.tools.strings;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.sirius.query.legacy.tools.AcceleoToolsMessages;
import org.eclipse.sirius.query.legacy.tools.AcceleoToolsPlugin;
import org.eclipse.sirius.query.legacy.tools.resources.FileContentMap;
import org.eclipse.sirius.query.legacy.tools.resources.Resources;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;
import org.eclipse.sirius.query.legacy.tools.strings.Jump;

public class TextSearch {
    public static final String FORCE_NOT_RECURSIVE = "__FORCE_NOT_RECURSIVE__";
    private static TextSearch defaultSearch = null;
    private static TextSearch regexSearch = null;
    private static TextSearch ignoreCaseSearch = null;
    private boolean regex;
    private boolean ignoreCase;
    private boolean recursiveInhibs;
    private Map patternMap = new HashMap();
    private FileContentMap lineNumberFileContentMap = new FileContentMap(5, true);
    private String refBuffer = "";
    private int refIndex = 0;
    private int refLineNumber = 1;

    public static TextSearch getDefaultSearch() {
        if (defaultSearch == null) {
            defaultSearch = new TextSearch(false, false, true);
        }
        return defaultSearch;
    }

    public static TextSearch getRegexSearch() {
        if (regexSearch == null) {
            regexSearch = new TextSearch(true, false, true);
        }
        return regexSearch;
    }

    public static TextSearch getIgnoreCaseSearch() {
        if (ignoreCaseSearch == null) {
            ignoreCaseSearch = new TextSearch(false, true, true);
        }
        return ignoreCaseSearch;
    }

    private TextSearch(boolean regex, boolean ignoreCase, boolean recursiveInhibs) {
        this.regex = regex;
        this.ignoreCase = ignoreCase;
        this.recursiveInhibs = recursiveInhibs;
    }

    protected Pattern compile(String regex) {
        Pattern pattern = (Pattern)this.patternMap.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            this.patternMap.put(regex, pattern);
        }
        return pattern;
    }

    public boolean matches(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (this.regex) {
            Pattern pattern = this.compile(s2);
            Matcher m = pattern.matcher(s1);
            return m.matches();
        }
        if (this.ignoreCase) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    public Int2 indexOf(String buffer, String tag) {
        return this.indexOf(buffer, tag, 0);
    }

    public Int2 indexOf(String buffer, String tag, int pos) {
        return this.indexIn(buffer, tag, pos, buffer.length());
    }

    public Int2 indexOf(String buffer, String tag, String spec, String[][] inhibs) {
        return this.indexOf(buffer, tag, 0, spec, inhibs);
    }

    public Int2 indexOf(String buffer, String tag, int pos, String spec, String[][] inhibs) {
        return this.indexOf(buffer, tag, pos, spec, null, inhibs);
    }

    public Int2 indexOf(String buffer, String tag, int pos, String spec, Jump jump, String[][] inhibs) {
        return this.indexIn(buffer, tag, pos, buffer.length(), spec, jump, inhibs);
    }

    public Int2 indexIn(String buffer, String tag, int posBegin, int posEnd) {
        if (buffer == null || posBegin < 0 || posEnd <= 0 || posEnd <= posBegin || posEnd > buffer.length()) {
            return Int2.NOT_FOUND;
        }
        if (tag == null || tag.length() == 0) {
            return Int2.NOT_FOUND;
        }
        String substring = buffer.substring(posBegin, posEnd);
        if (this.regex) {
            Pattern pattern = this.compile(tag);
            Matcher m = pattern.matcher(substring);
            if (m.find()) {
                return new Int2(posBegin + m.start(), posBegin + m.end());
            }
            return Int2.NOT_FOUND;
        }
        int i = this.ignoreCase ? substring.toLowerCase().indexOf(tag.toLowerCase()) : substring.indexOf(tag);
        if (i > -1) {
            int b = posBegin + i;
            return new Int2(b, b + tag.length());
        }
        return Int2.NOT_FOUND;
    }

    public Int2 indexIn(String buffer, String tag, int posBegin, int posEnd, String spec, String[][] inhibs) {
        return this.indexIn(buffer, tag, posBegin, posEnd, spec, null, inhibs);
    }

    public Int2 indexIn(String buffer, String tag, int posBegin, int posEnd, String spec, Jump jump, String[][] inhibs) {
        if (buffer == null || posBegin < 0 || posEnd <= 0 || posEnd <= posBegin || posEnd > buffer.length()) {
            return Int2.NOT_FOUND;
        }
        if (spec == null && inhibs == null) {
            return this.indexIn(buffer, tag, posBegin, posEnd);
        }
        if (tag == null) {
            return Int2.NOT_FOUND;
        }
        int inhibs_size = 0;
        if (inhibs != null) {
            inhibs_size = inhibs.length;
        }
        Int2[] positions = new Int2[3 + inhibs_size];
        int i = 0;
        while (i < positions.length) {
            positions[i] = new Int2(-2, -2);
            ++i;
        }
        while (posBegin > -1 && posBegin < posEnd) {
            if (positions[0].b() != -1 && spec != null && posBegin > positions[0].b()) {
                positions[0] = this.indexIn(buffer, spec, posBegin, posEnd);
            }
            if (positions[1].b() != -1 && posBegin > positions[1].b()) {
                positions[1] = this.indexIn(buffer, tag, posBegin, posEnd);
            }
            if (positions[2].b() != -1 && jump != null && posBegin > positions[2].b()) {
                positions[2] = jump.begin(buffer, posBegin, posEnd);
            }
            i = 3;
            while (i < positions.length) {
                if (positions[i].b() != -1 && posBegin > positions[i].b()) {
                    positions[i] = this.indexIn(buffer, inhibs[i - 3][0], posBegin, posEnd);
                }
                ++i;
            }
            int positionMin = posEnd;
            int iPositionMin = -1;
            int i2 = 0;
            while (i2 < positions.length) {
                if (positions[i2].b() > -1 && positions[i2].b() < positionMin) {
                    iPositionMin = i2;
                    positionMin = positions[i2].b();
                }
                ++i2;
            }
            if (iPositionMin == -1) {
                return Int2.NOT_FOUND;
            }
            if (iPositionMin == 0) {
                posBegin = positions[iPositionMin].e();
                continue;
            }
            if (iPositionMin == 1) {
                return positions[iPositionMin];
            }
            if (iPositionMin == 2) {
                posBegin = jump.end(buffer, positions[iPositionMin], posEnd, spec, inhibs);
                continue;
            }
            if (iPositionMin < 3) continue;
            boolean forceNotRecursive = inhibs[iPositionMin - 3].length >= 3 && inhibs[iPositionMin - 3][2] != null ? inhibs[iPositionMin - 3][2].indexOf(FORCE_NOT_RECURSIVE) > -1 : false;
            posBegin = this.blockIndexEndIn(buffer, inhibs[iPositionMin - 3][0], inhibs[iPositionMin - 3][1], positions[iPositionMin].b(), posEnd, this.recursiveInhibs && !forceNotRecursive, spec, jump, this.recursiveInhibs && !forceNotRecursive ? inhibs : null).e();
        }
        return Int2.NOT_FOUND;
    }

    public Int2 blockIndexEndOf(String buffer, String beginTag, String endTag, int posBegin, boolean recursive) {
        return this.blockIndexEndOf(buffer, beginTag, endTag, posBegin, recursive, null, null);
    }

    public Int2 blockIndexEndOf(String buffer, String beginTag, String endTag, int posBegin, boolean recursive, String spec, String[][] inhibs) {
        return this.blockIndexEndOf(buffer, beginTag, endTag, posBegin, recursive, spec, null, inhibs);
    }

    public Int2 blockIndexEndOf(String buffer, String beginTag, String endTag, int posBegin, boolean recursive, String spec, Jump jump, String[][] inhibs) {
        return this.blockIndexEndIn(buffer, beginTag, endTag, posBegin, buffer.length(), recursive, spec, jump, inhibs);
    }

    public Int2 blockIndexEndIn(String buffer, String beginTag, String endTag, int posBegin, int posEnd, boolean recursive) {
        return this.blockIndexEndIn(buffer, beginTag, endTag, posBegin, posEnd, recursive, null, null);
    }

    public Int2 blockIndexEndIn(String buffer, String beginTag, String endTag, int posBegin, int posEnd, boolean recursive, String spec, String[][] inhibs) {
        return this.blockIndexEndIn(buffer, beginTag, endTag, posBegin, posEnd, recursive, spec, null, inhibs);
    }

    public Int2 blockIndexEndIn(String buffer, String beginTag, String endTag, int posBegin, int posEnd, boolean recursive, String spec, Jump jump, String[][] inhibs) {
        if (buffer == null || posBegin < 0 || posEnd <= 0 || posEnd <= posBegin || posEnd > buffer.length()) {
            return Int2.NOT_FOUND;
        }
        if (beginTag == null) {
            return Int2.NOT_FOUND;
        }
        if (endTag == null) {
            return Int2.NOT_FOUND;
        }
        Int2 posBeginInt2 = this.indexIn(buffer, beginTag, posBegin, posEnd);
        if (beginTag.length() == 0) {
            recursive = false;
        } else if (posBeginInt2.b() != posBegin) {
            return Int2.NOT_FOUND;
        }
        if (endTag.length() == 0) {
            return new Int2(posEnd, posEnd);
        }
        int nbBeginTagOuvert = 1;
        int pos = posBeginInt2.e();
        int inhibs_size = 0;
        if (inhibs != null) {
            inhibs_size = inhibs.length;
        }
        Int2[] positions = new Int2[4 + inhibs_size];
        int i = 0;
        while (i < positions.length) {
            positions[i] = new Int2(-2, -2);
            ++i;
        }
        while (pos > -1 && pos < posEnd) {
            if (positions[0].b() != -1 && spec != null && pos > positions[0].b()) {
                positions[0] = this.indexIn(buffer, spec, pos, posEnd);
            }
            if (positions[1].b() != -1 && pos > positions[1].b()) {
                positions[1] = this.indexIn(buffer, endTag, pos, posEnd);
            }
            if (positions[2].b() != -1 && recursive && pos > positions[2].b()) {
                positions[2] = this.indexIn(buffer, beginTag, pos, posEnd);
            }
            if (positions[3].b() != -1 && jump != null && pos > positions[3].b()) {
                positions[3] = jump.begin(buffer, pos, posEnd);
            }
            i = 4;
            while (i < positions.length) {
                if (positions[i].b() != -1 && pos > positions[i].b()) {
                    positions[i] = this.indexIn(buffer, inhibs[i - 4][0], pos, posEnd);
                }
                ++i;
            }
            int positionMin = posEnd;
            int iPositionMin = -1;
            int i2 = 0;
            while (i2 < positions.length) {
                if (positions[i2].b() > -1 && positions[i2].b() < positionMin) {
                    iPositionMin = i2;
                    positionMin = positions[i2].b();
                }
                ++i2;
            }
            if (iPositionMin == -1) {
                return Int2.NOT_FOUND;
            }
            if (iPositionMin == 0) {
                pos = positions[iPositionMin].e();
            } else if (iPositionMin == 1) {
                --nbBeginTagOuvert;
                pos = positions[iPositionMin].e();
                if (!recursive) {
                    return positions[iPositionMin];
                }
            } else if (iPositionMin == 2) {
                ++nbBeginTagOuvert;
                pos = positions[iPositionMin].e();
            } else if (iPositionMin == 3) {
                pos = jump.end(buffer, positions[iPositionMin], posEnd, spec, inhibs);
            } else if (iPositionMin >= 4) {
                boolean forceNotRecursive = inhibs[iPositionMin - 4].length >= 3 && inhibs[iPositionMin - 4][2] != null ? inhibs[iPositionMin - 4][2].indexOf(FORCE_NOT_RECURSIVE) > -1 : false;
                pos = this.blockIndexEndIn(buffer, inhibs[iPositionMin - 4][0], inhibs[iPositionMin - 4][1], positions[iPositionMin].b(), posEnd, this.recursiveInhibs && !forceNotRecursive, spec, jump, this.recursiveInhibs && !forceNotRecursive ? inhibs : null).e();
            }
            if (nbBeginTagOuvert != 0) continue;
            return positions[iPositionMin];
        }
        return Int2.NOT_FOUND;
    }

    public Int2 lastIndexOf(String buffer, String tag) {
        return this.lastIndexOf(buffer, tag, 0);
    }

    public Int2 lastIndexOf(String buffer, String tag, int pos) {
        return this.lastIndexOf(buffer, tag, pos, null, null);
    }

    public Int2 lastIndexOf(String buffer, String tag, String spec, String[][] inhibs) {
        return this.lastIndexOf(buffer, tag, 0, spec, inhibs);
    }

    public Int2 lastIndexOf(String buffer, String tag, int pos, String spec, String[][] inhibs) {
        return this.lastIndexIn(buffer, tag, pos, buffer.length(), spec, inhibs);
    }

    public Int2 lastIndexIn(String buffer, String tag, int posBegin, int posEnd) {
        return this.lastIndexIn(buffer, tag, posBegin, posEnd, null, null);
    }

    public Int2 lastIndexIn(String buffer, String tag, int posBegin, int posEnd, String spec, String[][] inhibs) {
        Int2 i;
        if (buffer == null || posBegin < 0 || posEnd <= 0 || posEnd <= posBegin || posEnd > buffer.length()) {
            return Int2.NOT_FOUND;
        }
        Int2 last_i = i = this.indexIn(buffer, tag, posBegin, posEnd, spec, inhibs);
        while (i.b() > -1) {
            if ((i = this.indexIn(buffer, tag, i.e(), posEnd, spec, inhibs)).b() <= -1) continue;
            last_i = i;
        }
        return last_i;
    }

    public Int2[] allIndexOf(String buffer, String tag) {
        return this.allIndexOf(buffer, tag, 0);
    }

    public Int2[] allIndexOf(String buffer, String tag, int pos) {
        return this.allIndexOf(buffer, tag, pos, null, null);
    }

    public Int2[] allIndexOf(String buffer, String tag, String spec, String[][] inhibs) {
        return this.allIndexOf(buffer, tag, 0, spec, inhibs);
    }

    public Int2[] allIndexOf(String buffer, String tag, int pos, String spec, String[][] inhibs) {
        return this.allIndexIn(buffer, tag, pos, buffer.length(), spec, inhibs);
    }

    public Int2[] allIndexIn(String buffer, String tag, int posBegin, int posEnd) {
        return this.allIndexIn(buffer, tag, posBegin, posEnd, null, null);
    }

    public Int2[] allIndexIn(String buffer, String tag, int posBegin, int posEnd, String spec, String[][] inhibs) {
        if (buffer == null || posBegin < 0 || posEnd <= 0 || posEnd <= posBegin || posEnd > buffer.length()) {
            return new Int2[0];
        }
        ArrayList<Int2> lst = new ArrayList<Int2>();
        Int2 i = this.indexIn(buffer, tag, posBegin, posEnd, spec, inhibs);
        while (i.b() > -1) {
            lst.add(i);
            i = this.indexIn(buffer, tag, i.e(), posEnd, spec, inhibs);
        }
        return lst.toArray(new Int2[lst.size()]);
    }

    public String[] splitOf(String buffer, String[] separators, boolean keepSeparators) {
        return this.splitOf(buffer, separators, keepSeparators, null, null);
    }

    public String[] splitOf(String buffer, String[] separators, boolean keepSeparators, String spec, String[][] inhibs) {
        return this.splitOf(buffer, 0, separators, keepSeparators, spec, inhibs);
    }

    public String[] splitOf(String buffer, int posBegin, String[] separators, boolean keepSeparators) {
        return this.splitOf(buffer, posBegin, separators, keepSeparators, null, null);
    }

    public String[] splitOf(String buffer, int posBegin, String[] separators, boolean keepSeparators, String spec, String[][] inhibs) {
        return this.splitIn(buffer, posBegin, buffer.length(), separators, keepSeparators, spec, inhibs);
    }

    public String[] splitIn(String buffer, int posBegin, int posEnd, String[] separators, boolean keepSeparators) {
        return this.splitIn(buffer, posBegin, posEnd, separators, keepSeparators, null, null);
    }

    public String[] splitIn(String buffer, int posBegin, int posEnd, String[] separators, boolean keepSeparators, String spec, String[][] inhibs) {
        List list = this.split(buffer, posBegin, posEnd, separators, keepSeparators, spec, inhibs);
        return list.toArray(new String[list.size()]);
    }

    private List split(String buffer, int posBegin, int posEnd, String[] separators, boolean keepSeparators, String spec, String[][] inhibs) {
        LinkedList<String> result = new LinkedList<String>();
        if (buffer == null || buffer.length() == 0 || posBegin < 0 || posEnd <= 0 || posEnd <= posBegin || posEnd > buffer.length()) {
            return result;
        }
        if (separators == null) {
            return result;
        }
        String[] stringArray = separators;
        int n = separators.length;
        int n2 = 0;
        while (n2 < n) {
            String separator = stringArray[n2];
            if (separator != null && separator.length() > 0) {
                Int2 index = this.indexIn(buffer, separator, posBegin, posEnd, spec, inhibs);
                if (keepSeparators) {
                    if (index.b() == posBegin) {
                        return this.concat(buffer.substring(index.b(), index.e()), this.split(buffer, index.e(), posEnd, separators, keepSeparators, spec, inhibs));
                    }
                    if (index.e() == buffer.length()) {
                        return this.concat(this.split(buffer, posBegin, index.b(), separators, keepSeparators, spec, inhibs), buffer.substring(index.b(), index.e()));
                    }
                    if (index.b() > -1) {
                        return this.concat(this.split(buffer, posBegin, index.b(), separators, keepSeparators, spec, inhibs), buffer.substring(index.b(), index.e()), this.split(buffer, index.e(), posEnd, separators, keepSeparators, spec, inhibs));
                    }
                } else {
                    if (index.b() == 0) {
                        return this.split(buffer, index.e(), posEnd, separators, keepSeparators, spec, inhibs);
                    }
                    if (index.e() == buffer.length()) {
                        return this.split(buffer, posBegin, index.b(), separators, keepSeparators, spec, inhibs);
                    }
                    if (index.b() > -1) {
                        return this.concat(this.split(buffer, posBegin, index.b(), separators, keepSeparators, spec, inhibs), this.split(buffer, index.e(), posEnd, separators, keepSeparators, spec, inhibs));
                    }
                }
            }
            ++n2;
        }
        result.add(buffer.substring(posBegin, posEnd));
        return result;
    }

    public Int2[] splitPositionsOf(String buffer, String[] separators, boolean keepSeparators) {
        return this.splitPositionsOf(buffer, separators, keepSeparators, null, null);
    }

    public Int2[] splitPositionsOf(String buffer, String[] separators, boolean keepSeparators, String spec, String[][] inhibs) {
        return this.splitPositionsOf(buffer, 0, separators, keepSeparators, spec, inhibs);
    }

    public Int2[] splitPositionsOf(String buffer, int posBegin, String[] separators, boolean keepSeparators) {
        return this.splitPositionsOf(buffer, posBegin, separators, keepSeparators, null, null);
    }

    public Int2[] splitPositionsOf(String buffer, int posBegin, String[] separators, boolean keepSeparators, String spec, String[][] inhibs) {
        return this.splitPositionsIn(buffer, posBegin, buffer.length(), separators, keepSeparators, spec, inhibs);
    }

    public Int2[] splitPositionsIn(String buffer, int posBegin, int posEnd, String[] separators, boolean keepSeparators) {
        return this.splitPositionsIn(buffer, posBegin, posEnd, separators, keepSeparators, null, null);
    }

    public Int2[] splitPositionsIn(String buffer, int posBegin, int posEnd, String[] separators, boolean keepSeparators, String spec, String[][] inhibs) {
        List list = this.splitPositions(buffer, posBegin, posEnd, separators, keepSeparators, spec, inhibs);
        return list.toArray(new Int2[list.size()]);
    }

    private List splitPositions(String buffer, int posBegin, int posEnd, String[] separators, boolean keepSeparators, String spec, String[][] inhibs) {
        LinkedList<Int2> result = new LinkedList<Int2>();
        if (buffer == null || buffer.length() == 0 || posBegin < 0 || posEnd <= 0 || posEnd <= posBegin || posEnd > buffer.length()) {
            return result;
        }
        if (separators == null) {
            return result;
        }
        Int2[] positions = new Int2[separators.length];
        int i = 0;
        while (i < positions.length) {
            positions[i] = new Int2(-2, -2);
            ++i;
        }
        while (posBegin > -1 && posBegin < posEnd) {
            i = 0;
            while (i < positions.length) {
                if (positions[i].b() != -1 && posBegin > positions[i].b()) {
                    positions[i] = separators[i] != null && separators[i].length() > 0 ? this.indexIn(buffer, separators[i], posBegin, posEnd, spec, inhibs) : Int2.NOT_FOUND;
                }
                ++i;
            }
            int positionMin = posEnd;
            int iPositionMin = -1;
            int i2 = 0;
            while (i2 < positions.length) {
                if (positions[i2].b() > -1 && positions[i2].b() < positionMin) {
                    iPositionMin = i2;
                    positionMin = positions[i2].b();
                }
                ++i2;
            }
            if (iPositionMin == -1) {
                if (posEnd <= posBegin) break;
                result.add(new Int2(posBegin, posEnd));
                break;
            }
            if (positions[iPositionMin].b() > posBegin) {
                result.add(new Int2(posBegin, positions[iPositionMin].b()));
            }
            if (keepSeparators) {
                result.add(positions[iPositionMin]);
            }
            posBegin = positions[iPositionMin].e();
        }
        return result;
    }

    private List concat(List t1, Object o, List t2) {
        t1.add(o);
        t1.addAll(t2);
        return t1;
    }

    private List concat(List t1, List t2) {
        t1.addAll(t2);
        return t1;
    }

    private List concat(List t1, Object o) {
        t1.add(o);
        return t1;
    }

    private List concat(Object o, List t2) {
        t2.add(0, o);
        return t2;
    }

    public String[] extractValues(String buffer, String sRegex, String arg, String argRegex) {
        if (buffer == null || sRegex == null || arg == null || argRegex == null) {
            return new String[0];
        }
        ArrayList<String> res = new ArrayList<String>();
        String[] regex = this.splitOf(sRegex, new String[]{arg}, true, null, null);
        boolean posOK = true;
        int iPosOK = 0;
        int i = 0;
        while (posOK && i < regex.length) {
            String ex = regex[i];
            boolean isArg = ex.equals(arg);
            if (isArg) {
                ex = argRegex;
            }
            Int2 pos = this.indexOf(buffer, ex, iPosOK);
            if (isArg) {
                res.add(buffer.substring(pos.b(), pos.e()));
            }
            posOK = pos.b() == iPosOK;
            iPosOK = pos.e();
            ++i;
        }
        boolean bl = posOK = iPosOK == buffer.length();
        if (posOK) {
            return res.toArray(new String[res.size()]);
        }
        return new String[0];
    }

    /*
     * Unable to fully structure code
     */
    public Int2 trim(String buffer, int posBegin, int posEnd) {
        if (buffer == null) {
            return Int2.NOT_FOUND;
        }
        if (posBegin < 0 || posBegin >= buffer.length()) {
            return Int2.NOT_FOUND;
        }
        if (posEnd < 0 || posEnd > buffer.length()) {
            return Int2.NOT_FOUND;
        }
        if (posBegin <= posEnd) ** GOTO lbl11
        return Int2.NOT_FOUND;
        while ((c = buffer.charAt(posBegin)) == ' ' || c == '\t' || c == '\r' || c == '\n') {
            ++posBegin;
lbl11:
            // 2 sources

            if (posBegin < posEnd) continue;
        }
        while (posEnd > posBegin) {
            c = buffer.charAt(posEnd - 1);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') break;
            --posEnd;
        }
        if (posBegin < posEnd) {
            return new Int2(posBegin, posEnd);
        }
        return Int2.NOT_FOUND;
    }

    public int countOf(String buffer, String tag) {
        return this.countOf(buffer, tag, 0);
    }

    public int countOf(String buffer, String tag, int pos) {
        return this.countOf(buffer, tag, pos, null, null);
    }

    public int countOf(String buffer, String tag, String spec, String[][] inhibs) {
        return this.countOf(buffer, tag, 0, spec, inhibs);
    }

    public int countOf(String buffer, String tag, int pos, String spec, String[][] inhibs) {
        return this.countIn(buffer, tag, pos, buffer.length(), spec, inhibs);
    }

    public int countIn(String buffer, String tag, int posBegin, int posEnd) {
        return this.countIn(buffer, tag, posBegin, posEnd, null, null);
    }

    public int countIn(String buffer, String tag, int posBegin, int posEnd, String spec, String[][] inhibs) {
        return this.allIndexIn(buffer, tag, posBegin, posEnd, spec, inhibs).length;
    }

    public int lineNumber(File file, int index) {
        Object[] object = (Object[])this.lineNumberFileContentMap.get(file);
        if (object == null) {
            object = new Object[2];
            object[0] = new HashMap();
            ((Map)object[0]).put(new Integer(0), new Integer(1));
            String buffer = Resources.getFileContent(file).toString();
            object[1] = buffer;
            Int2[] endLines = this.allIndexOf(buffer, "\n");
            int i = 0;
            while (i < endLines.length) {
                ((Map)object[0]).put(new Integer(endLines[i].e()), new Integer(i + 2));
                ++i;
            }
            this.lineNumberFileContentMap.put(file, (Object)object);
        }
        Map firstCharToLine = (Map)object[0];
        String buffer = (String)object[1];
        int firstChar = index;
        while (firstChar > 0 && buffer.charAt(firstChar - 1) != '\n') {
            --firstChar;
        }
        Integer lineNumber = (Integer)firstCharToLine.get(new Integer(firstChar));
        if (lineNumber != null) {
            return lineNumber;
        }
        AcceleoToolsPlugin.getDefault().log(AcceleoToolsMessages.getString("TextSearch.CharacterLineNotFound", new Object[]{Integer.toString(index), file.getAbsolutePath()}), true);
        return 0;
    }

    public int lineNumber(String buffer, int index) {
        if (buffer != null && index >= 0 && index < buffer.length()) {
            if (this.refBuffer.equals(buffer) && index >= this.refIndex) {
                int i = this.refIndex;
                while (i < index) {
                    if (buffer.charAt(i) == '\n') {
                        ++this.refLineNumber;
                    }
                    ++i;
                }
            } else {
                this.refLineNumber = 1;
                int i = 0;
                while (i < index) {
                    if (buffer.charAt(i) == '\n') {
                        ++this.refLineNumber;
                    }
                    ++i;
                }
            }
            this.refBuffer = buffer;
            this.refIndex = index;
            return this.refLineNumber;
        }
        return 0;
    }

    public int columnNumber(String buffer, int index) {
        if (buffer != null && index > 0 && index < buffer.length()) {
            int column = 0;
            int i = index - 1;
            while (i >= 0) {
                if (buffer.charAt(i) == '\n') break;
                ++column;
                --i;
            }
            return column;
        }
        return 0;
    }

    public String replaceAllIn(String buffer, String string, String replacementString, int posBegin, int posEnd, String[][] inhibs) {
        if (buffer == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(buffer);
        Int2[] positions = this.allIndexIn(buffer, string, posBegin, posEnd, null, inhibs);
        if (positions.length > 0) {
            int i = positions.length - 1;
            while (i >= 0) {
                Int2 pos = positions[i];
                result.replace(pos.b(), pos.e(), replacementString);
                --i;
            }
        }
        return result.toString();
    }
}

