/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.tools.classloaders;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.sirius.query.legacy.tools.classloaders.AcceleoClassLoader;
import org.eclipse.sirius.query.legacy.tools.resources.Resources;
import org.osgi.framework.Bundle;

public class AcceleoGenClassLoader
extends AcceleoClassLoader {
    private static Map cacheURL = new HashMap();

    public AcceleoGenClassLoader(IProject project, ClassLoader parent) {
        super(AcceleoGenClassLoader.computeURLs(project), parent);
    }

    public AcceleoGenClassLoader(Bundle bundle, ClassLoader parent) {
        super(bundle, parent);
    }

    private static URL[] computeURLs(IProject project) {
        ArrayList list = new ArrayList();
        AcceleoGenClassLoader.computeURLs(project, list);
        return list.toArray(new URL[list.size()]);
    }

    private static void computeURLs(IProject project, List URLs) {
        IClasspathEntry[] entries;
        IFolder binFolder = Resources.getOutputFolder(project);
        if (binFolder != null) {
            String location = binFolder.getLocation().toString();
            if (location.startsWith("/")) {
                location = String.valueOf('/') + location;
            }
            try {
                URLs.add(new URL("file:/" + location + '/'));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            entries = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException javaModelException) {
            entries = new IClasspathEntry[]{};
        }
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            block20: {
                IProject reference;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 2) {
                    reference = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().toString());
                    if (reference.exists()) {
                        AcceleoGenClassLoader.computeURLs(reference, URLs);
                    }
                } else if (entry.getEntryKind() == 1) {
                    try {
                        URL url;
                        reference = ResourcesPlugin.getWorkspace().getRoot().getFile(entry.getPath());
                        if (reference.exists()) {
                            url = (URL)cacheURL.get(reference.getLocation().toFile());
                            if (url == null) {
                                url = reference.getLocation().toFile().toURL();
                                cacheURL.put(reference.getLocation().toFile(), url);
                            }
                            URLs.add(url);
                            break block20;
                        }
                        url = (URL)cacheURL.get(entry.getPath().toFile());
                        if (url == null) {
                            url = entry.getPath().toFile().toURL();
                            cacheURL.put(entry.getPath().toFile(), url);
                        }
                        URLs.add(url);
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else {
                    try {
                        URL url = (URL)cacheURL.get(entry.getPath().toFile());
                        if (url == null) {
                            url = entry.getPath().toFile().toURL();
                            cacheURL.put(entry.getPath().toFile(), url);
                        }
                        URLs.add(url);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
            ++n2;
        }
    }
}

