/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.scripts.imports;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.gen.AcceleoEcoreGenPlugin;
import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeList;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateCallExpression;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateExpression;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateLiteralExpression;
import org.eclipse.sirius.query.legacy.gen.template.scripts.AbstractScript;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IEvalSettings;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.JavaServiceNotFoundException;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.services.ContextServices;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.services.ENodeServices;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.services.EObjectServices;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.services.RequestServices;
import org.eclipse.sirius.query.legacy.tools.classloaders.AcceleoClassLoader;
import org.eclipse.sirius.query.legacy.tools.classloaders.AcceleoGenClassLoader;
import org.eclipse.sirius.query.legacy.tools.plugins.AcceleoModuleProvider;
import org.osgi.framework.Bundle;

public class EvalJavaService
implements IEvalSettings {
    private static String[] SERVICES_WITH_TYPE_RESOLVE = new String[]{"filter", "cast", "until", "eContainer", "eAllContents", "current"};
    private static String[] SERVICES_WITH_TYPE_BRIDGE = new String[]{"select", "delete", "sep", "nGet", "trace", "debug", "nFirst", "nLast", "sort", "nSort", "minimize", "nMinimize", "reverse", "nReverse"};
    private static List typeResolveList = null;
    private static List typeBridgeList = null;
    public static final int MODE_DEFAULT = 0;
    public static final int MODE_ENODE = 1;
    public static final int MODE_LIST = 2;
    protected int mode = 0;
    protected Object instance;
    private ClassLoader loader = null;
    private final Map name2service = new HashMap();
    private boolean hasScriptContext = true;
    private final Map quickResolveType = new HashMap();

    private static List getTypeResolveList() {
        if (typeResolveList == null) {
            typeResolveList = new ArrayList();
            String[] stringArray = SERVICES_WITH_TYPE_RESOLVE;
            int n = SERVICES_WITH_TYPE_RESOLVE.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                typeResolveList.add(element);
                ++n2;
            }
        }
        return typeResolveList;
    }

    private static List getTypeBridgeList() {
        if (typeBridgeList == null) {
            typeBridgeList = new ArrayList();
            String[] stringArray = SERVICES_WITH_TYPE_BRIDGE;
            int n = SERVICES_WITH_TYPE_BRIDGE.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                typeBridgeList.add(element);
                ++n2;
            }
        }
        return typeBridgeList;
    }

    public EvalJavaService(Object instance, boolean hasScriptContext) {
        this.instance = instance;
        this.hasScriptContext = hasScriptContext;
        this.initializeName2service();
    }

    public EvalJavaService(File script, String className) throws JavaServiceNotFoundException {
        String shortName = className;
        String path = "";
        int jDot = className.lastIndexOf(".");
        if (jDot > -1) {
            shortName = className.substring(jDot + 1);
            path = className.substring(0, jDot);
        }
        if (shortName.length() > 0) {
            shortName = String.valueOf(shortName.substring(0, 1).toUpperCase()) + shortName.substring(1);
        }
        className = String.valueOf(path.length() > 0 ? String.valueOf(path) + '.' : "") + shortName;
        this.initialize(script, className);
        this.initializeName2service();
    }

    public EvalJavaService(File script) throws JavaServiceNotFoundException {
        String name = new Path(script.getName()).removeFileExtension().lastSegment();
        if (name.length() > 0) {
            name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
        }
        String[] segments = this.getPackagePath(script).append(name).segments();
        StringBuffer className = new StringBuffer();
        className.append(segments[0]);
        int i = 1;
        while (i < segments.length) {
            className.append('.');
            className.append(segments[i]);
            ++i;
        }
        this.initialize(script, className.toString());
        this.initializeName2service();
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public boolean hasScriptContext() {
        return this.hasScriptContext;
    }

    public Object getInstance() {
        return this.instance;
    }

    private void initialize(File script, String className) throws JavaServiceNotFoundException {
        try {
            this.loader = this.createClassLoader(script);
            Class<?> c = this.loader.loadClass(className);
            this.instance = c.newInstance();
        }
        catch (Exception e) {
            throw new JavaServiceNotFoundException(AcceleoGenMessages.getString("EvalJavaService.UnresolvedService", new Object[]{e.getMessage()}));
        }
    }

    private void initializeName2service() {
        this.name2service.clear();
        if (this.instance != null) {
            Method[] methods;
            Method[] methodArray = methods = this.instance.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getDeclaringClass() == this.instance.getClass() && method.getParameterTypes().length > 0) {
                    String key = String.valueOf(method.getName()) + method.getParameterTypes().length;
                    Method[] name2values = (Method[])this.name2service.get(key);
                    if (name2values == null) {
                        this.name2service.put(key, new Method[]{method});
                    } else {
                        ArrayList<Method> name2values_ = new ArrayList<Method>(name2values.length + 1);
                        boolean ok = false;
                        Method[] methodArray2 = name2values;
                        int n3 = name2values.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Method name2value = methodArray2[n4];
                            if (name2value.getParameterTypes()[0].isAssignableFrom(method.getParameterTypes()[0]) || name2value.getParameterTypes()[0] == ENode.class) {
                                name2values_.add(method);
                                ok = true;
                            }
                            name2values_.add(name2value);
                            ++n4;
                        }
                        if (!ok) {
                            name2values_.add(method);
                        }
                        this.name2service.put(key, name2values_.toArray(new Method[name2values_.size()]));
                    }
                }
                ++n2;
            }
        }
    }

    private Method[] getPotentialMethods(String name, int argsCount) {
        String key = String.valueOf(name) + argsCount;
        return (Method[])this.name2service.get(key);
    }

    private IPath getPackagePath(File script) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(script.getAbsolutePath()));
        if (file != null && file.isAccessible()) {
            return file.getProjectRelativePath().removeLastSegments(1).removeFirstSegments(1);
        }
        String path = AcceleoModuleProvider.getDefault().getRelativePath(script);
        if (path != null) {
            return new Path(path).removeLastSegments(1);
        }
        return new Path("");
    }

    private ClassLoader createClassLoader(File script) {
        Bundle bundle;
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(script.getAbsolutePath()));
        if (file != null && file.isAccessible()) {
            return new AcceleoGenClassLoader(file.getProject(), EvalJavaService.class.getClassLoader());
        }
        String pluginId = AcceleoModuleProvider.getDefault().getPluginId(script);
        if (pluginId != null && (bundle = Platform.getBundle((String)pluginId)) != null) {
            return new AcceleoGenClassLoader(bundle, EvalJavaService.class.getClassLoader());
        }
        return EvalJavaService.class.getClassLoader();
    }

    @Override
    public ENode eGet(TemplateCallExpression call, ENode node, ENode[] args, LaunchManager mode, boolean recursiveSearch) throws FactoryException, ENodeException {
        if (this.name2service.containsKey(String.valueOf(call.getLink()) + (args.length + 1))) {
            if (node.isEObject()) {
                ClassLoader old = AcceleoClassLoader.getPreferredClassLoader();
                try {
                    AcceleoClassLoader.setPreferredLoader(node.getEObject());
                    ENode eNode = this.eGetSub(call, node, args, mode);
                    return eNode;
                }
                catch (ENodeCastException eNodeCastException) {
                    return null;
                }
                finally {
                    AcceleoClassLoader.setPreferredClassLoader(old);
                }
            }
            return this.eGetSub(call, node, args, mode);
        }
        return null;
    }

    private ENode eGetSub(TemplateCallExpression call, ENode node, ENode[] args, LaunchManager runMode) throws FactoryException, ENodeException {
        Method[] methods;
        ArrayList<Class> argTypesList = new ArrayList<Class>(args.length + 1);
        ArrayList<Object> argValuesList = new ArrayList<Object>(args.length + 1);
        argTypesList.add(null);
        argValuesList.add(null);
        ENode[] eNodeArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ENode arg = eNodeArray[n2];
            argTypesList.add(arg.getTypeClass());
            argValuesList.add(arg.getValue());
            ++n2;
        }
        Class[] argTypes = argTypesList.toArray(new Class[argTypesList.size()]);
        Object[] argValues = argValuesList.toArray();
        Method m = null;
        if (this.mode == 0 && !node.isNull()) {
            argTypes[0] = node.getTypeClass();
            argValues[0] = node.getValue();
            m = this.eGetMethod(call.getLink(), argTypes, argValues[0]);
        } else if (this.mode == 1) {
            argTypes[0] = ENode.class;
            argValues[0] = node;
            m = this.eGetMethod(call.getLink(), argTypes, argValues[0]);
        } else if (this.mode == 2 && node.isList()) {
            try {
                argTypes[0] = ENodeList.class;
                argValues[0] = node.getList();
                m = this.eGetMethod(call.getLink(), argTypes, argValues[0]);
            }
            catch (ENodeCastException eNodeCastException) {
                m = null;
            }
            if (m == null) {
                try {
                    argTypes[0] = List.class;
                    argValues[0] = node.getList().asList();
                    m = this.eGetMethod(call.getLink(), argTypes, argValues[0]);
                }
                catch (ENodeCastException eNodeCastException) {
                    m = null;
                }
            }
        }
        if (m == null && this.instance != null && (methods = this.getPotentialMethods(call.getLink(), argTypes.length)) != null) {
            int i = 0;
            while (m == null && i < methods.length) {
                boolean ok = true;
                Class<?>[] parameterTypes = methods[i].getParameterTypes();
                if (parameterTypes.length > 0) {
                    if (this.mode == 0) {
                        Class parameterType = ENode.getAdapterType(parameterTypes[0]);
                        if (parameterType != null) {
                            argTypes[0] = parameterType;
                            try {
                                argValues[0] = node.getAdapterValue(parameterType);
                            }
                            catch (ENodeCastException eNodeCastException) {
                                ok = false;
                            }
                        } else {
                            ok = false;
                        }
                    }
                    if (this.mode == 0 && ok || this.mode == 1 && parameterTypes[0] == ENode.class || this.mode == 2 && parameterTypes[0] == ENodeList.class) {
                        int j2 = 1;
                        while (j2 < parameterTypes.length) {
                            block46: {
                                Class parameterType = ENode.getAdapterType(parameterTypes[j2]);
                                if (parameterType != null) {
                                    argTypes[j2] = parameterType;
                                    try {
                                        argValues[j2] = args[j2 - 1].getAdapterValue(parameterType);
                                        break block46;
                                    }
                                    catch (ENodeCastException eNodeCastException) {
                                        ok = false;
                                        break;
                                    }
                                }
                                ok = false;
                                break;
                            }
                            ++j2;
                        }
                        if (ok) {
                            m = methods[i];
                        }
                    }
                }
                ++i;
            }
        }
        if (m != null) {
            ENode createTry;
            Object result;
            String displayString;
            block48: {
                StringBuffer errorMessage;
                displayString = String.valueOf(m.getName()) + " (";
                Class<?>[] paramTypes = m.getParameterTypes();
                int j = 1;
                while (j < paramTypes.length) {
                    Class<?> paramType = paramTypes[j];
                    displayString = String.valueOf(displayString) + EvalJavaService.getSimpleName(paramType);
                    if (j + 1 < paramTypes.length) {
                        displayString = String.valueOf(displayString) + ", ";
                    }
                    ++j;
                }
                displayString = String.valueOf(displayString) + ')';
                if (m.getReturnType() != null) {
                    displayString = String.valueOf(displayString) + ' ' + EvalJavaService.getSimpleName(m.getReturnType());
                }
                displayString = String.valueOf(displayString) + " - " + EvalJavaService.getSimpleName(m.getDeclaringClass());
                try {
                    if (call.getLink().equals("select") && call.getScript() instanceof AbstractScript && call.countArguments() > 0) {
                        ((AbstractScript)call.getScript()).contextPush(IScript.ARGUMENT_POSITION, call.getFirstArgument().getPos());
                    }
                    try {
                        try {
                            if (m.getReturnType() != null && "void".equals(EvalJavaService.getSimpleName(m.getReturnType()))) {
                                m.invoke(this.instance, argValues);
                                result = "";
                            } else {
                                result = m.invoke(this.instance, argValues);
                            }
                        }
                        catch (Exception npe) {
                            if (this.mode != 0 || argValues.length <= 0 || argValues[0] != null) {
                                throw npe;
                            }
                            result = null;
                            if (call.getLink().equals("select") && call.getScript() instanceof AbstractScript && call.countArguments() > 0) {
                                ((AbstractScript)call.getScript()).contextPop(IScript.ARGUMENT_POSITION);
                            }
                            break block48;
                        }
                    }
                    catch (Throwable j2) {
                        if (call.getLink().equals("select") && call.getScript() instanceof AbstractScript && call.countArguments() > 0) {
                            ((AbstractScript)call.getScript()).contextPop(IScript.ARGUMENT_POSITION);
                        }
                        throw j2;
                    }
                    if (call.getLink().equals("select") && call.getScript() instanceof AbstractScript && call.countArguments() > 0) {
                        ((AbstractScript)call.getScript()).contextPop(IScript.ARGUMENT_POSITION);
                    }
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof FactoryException) {
                        throw (FactoryException)e.getTargetException();
                    }
                    if (e.getTargetException() instanceof ENodeException) {
                        throw (ENodeException)e.getTargetException();
                    }
                    errorMessage = new StringBuffer("\n");
                    errorMessage.append(e.getTargetException() != null ? String.valueOf(e.getTargetException().getClass().getName()) + " : " + e.getTargetException().getMessage() : "");
                    throw new ENodeException(AcceleoGenMessages.getString("EvalJavaService.RuntimeException", new Object[]{displayString, errorMessage.toString()}), call.getPos(), call.getScript(), node, true, e.getTargetException());
                }
                catch (Exception e) {
                    errorMessage = new StringBuffer("\n");
                    errorMessage.append(e.getClass().getName());
                    errorMessage.append(" : ");
                    errorMessage.append(e.getMessage());
                    throw new ENodeException(AcceleoGenMessages.getString("EvalJavaService.RuntimeException", new Object[]{displayString, errorMessage.toString()}), call.getPos(), call.getScript(), node, true, e);
                }
            }
            if ((createTry = ENode.createTry(result, node)) != null) {
                return createTry;
            }
            throw new ENodeException(AcceleoGenMessages.getString("EvalJavaService.RuntimeType", new Object[]{displayString, result.getClass().getName()}), call.getPos(), call.getScript(), node, true);
        }
        return null;
    }

    public static String getSimpleName(Class c) {
        String name = c.getName();
        int i = name.lastIndexOf(".");
        if (i > -1) {
            name = name.substring(i + 1);
        }
        return name;
    }

    public static boolean isExternalService(Method m) {
        boolean isExternal = false;
        Class<?>[] interfaces = m.getDeclaringClass().getInterfaces();
        if (interfaces != null) {
            Class<?>[] classArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interface1 = classArray[n2];
                isExternal = isExternal || EvalJavaService.getSimpleName(interface1).equals("IExternalJavaService");
                ++n2;
            }
        }
        return isExternal;
    }

    public static boolean isDeprecatedService(Method m0) {
        boolean isDeprecated = false;
        try {
            Object methods;
            Method m2 = m0.getDeclaringClass().getDeclaredMethod("getDeprecatedMethods", null);
            if (m2 != null && (methods = m2.invoke(m0.getDeclaringClass().newInstance(), null)) != null && methods instanceof Method[]) {
                Method[] mts;
                Method[] methodArray = mts = (Method[])methods;
                int n = mts.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m1 = methodArray[n2];
                    isDeprecated = isDeprecated || (String.valueOf(m0.getName()) + m0.toString()).equals(String.valueOf(m1.getName()) + m1.toString());
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            AcceleoEcoreGenPlugin.getDefault().log(e.getMessage(), true);
        }
        return isDeprecated;
    }

    private Method eGetMethod(String name, Class[] argTypes, Object receiver) {
        Method[] methods = this.getPotentialMethods(name, argTypes.length);
        if (methods != null) {
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (argTypes[0] != EObject.class || parameterTypes[0].isInstance(receiver)) {
                    boolean ok = true;
                    int j = 0;
                    while (j < parameterTypes.length) {
                        if (argTypes[j] == EObject.class && !argTypes[j].isAssignableFrom(parameterTypes[j]) || argTypes[j] != EObject.class && argTypes[j] != parameterTypes[j]) {
                            ok = false;
                            break;
                        }
                        ++j;
                    }
                    if (ok) {
                        return method;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public Object resolveType(Object type, TemplateCallExpression call, int depth) {
        if (this.instance != null && type != null) {
            Method[] methods;
            EClassifier result;
            TemplateExpression firstArg;
            ArrayList<Object> quickKey = new ArrayList<Object>();
            quickKey.add(type);
            quickKey.add(call.toString());
            if (this.quickResolveType.containsKey(quickKey)) {
                return this.quickResolveType.get(quickKey);
            }
            Object resolvedType = null;
            if ((this.instance instanceof ENodeServices || this.instance instanceof EObjectServices) && EvalJavaService.getTypeResolveList().contains(call.getLink()) && call.countArguments() > 0 && (firstArg = call.getFirstArgument()) instanceof TemplateLiteralExpression && (result = ((TemplateLiteralExpression)firstArg).resolveAsEClassifier()) != null) {
                resolvedType = result;
            }
            if (resolvedType == null && (this.instance instanceof RequestServices || this.instance instanceof ENodeServices || this.instance instanceof ContextServices) && EvalJavaService.getTypeBridgeList().contains(call.getLink())) {
                resolvedType = type;
            }
            if (resolvedType == null && (methods = this.getPotentialMethods(call.getLink(), call.countArguments() + 1)) != null && methods.length > 0 && methods[0].getDeclaringClass() == this.instance.getClass()) {
                resolvedType = IEvalSettings.GENERIC_TYPE;
            }
            this.quickResolveType.put(quickKey, resolvedType);
            return resolvedType;
        }
        return null;
    }

    @Override
    public Object[] getCompletionProposals(Object type, int depth) {
        if (this.instance != null) {
            Method[] methods;
            TreeSet<Method> result = new TreeSet<Method>(new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    Method m0 = (Method)arg0;
                    Method m1 = (Method)arg1;
                    return (String.valueOf(m0.getName()) + m0.toString()).compareTo(String.valueOf(m1.getName()) + m1.toString());
                }
            });
            Method[] methodArray = methods = this.instance.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getDeclaringClass() == this.instance.getClass() && method.getParameterTypes().length >= 1) {
                    result.add(method);
                }
                ++n2;
            }
            return result.toArray();
        }
        return new Object[0];
    }

    @Override
    public boolean validateCall(TemplateCallExpression call) {
        return "".equals(call.getPrefix()) || TemplateConstants.LINK_PREFIX_JAVA.equals(call.getPrefix());
    }
}

