/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.expressions;

import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.TemplateElement;
import org.eclipse.sirius.query.legacy.gen.template.TemplateSyntaxException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateCallSetExpression;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateLiteralExpression;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateNotExpression;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateOperatorExpression;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateParenthesisExpression;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;
import org.eclipse.sirius.query.legacy.tools.strings.TextSearch;

public abstract class TemplateExpression
extends TemplateElement {
    public TemplateExpression(IScript script) {
        super(script);
    }

    public abstract ENode evaluate(ENode var1, IScript var2, LaunchManager var3) throws ENodeException, FactoryException;

    public static TemplateExpression fromString(String buffer, Int2 limits, IScript script) throws TemplateSyntaxException {
        Int2 trim = TextSearch.getDefaultSearch().trim(buffer, limits.b(), limits.e());
        if (trim.b() == -1) {
            throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.MissingElement"), script, limits);
        }
        limits = trim;
        TemplateExpression expression = TemplateOperatorExpression.fromString(buffer, limits, script);
        if (expression != null) {
            return expression;
        }
        expression = TemplateNotExpression.fromString(buffer, limits, script);
        if (expression != null) {
            return expression;
        }
        expression = TemplateParenthesisExpression.fromString(buffer, limits, script);
        if (expression != null) {
            return expression;
        }
        expression = TemplateLiteralExpression.fromString(buffer, limits, script);
        if (expression != null) {
            return expression;
        }
        expression = TemplateCallSetExpression.fromString(buffer, limits, script);
        return expression;
    }
}

